/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.extracolumns;

import hudson.Extension;
import hudson.model.AbstractProject;
import hudson.model.Job;
import hudson.scheduler.CronTabList;
import hudson.scheduler.Hash;
import hudson.triggers.TimerTrigger;
import hudson.triggers.Trigger;
import hudson.views.ListViewColumn;
import hudson.views.ListViewColumnDescriptor;
import java.text.DateFormat;
import java.util.Calendar;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.ParameterizedJobMixIn;
import jenkins.plugins.extracolumns.Messages;
import org.kohsuke.stapler.DataBoundConstructor;

public class CronTriggerColumn
extends ListViewColumn {
    private static final String DEFAULT_TRIGGER = "N/A";
    private static final Logger LOGGER = Logger.getLogger(CronTriggerColumn.class.getName());

    @DataBoundConstructor
    public CronTriggerColumn() {
    }

    public String getCronTrigger(Job job) {
        String cronTrigger = DEFAULT_TRIGGER;
        if (job == null) {
            return cronTrigger;
        }
        Map triggers = null;
        if (job instanceof AbstractProject) {
            triggers = ((AbstractProject)job).getTriggers();
        }
        if (job instanceof ParameterizedJobMixIn.ParameterizedJob) {
            triggers = ((ParameterizedJobMixIn.ParameterizedJob)job).getTriggers();
        }
        if (triggers == null) {
            return cronTrigger;
        }
        for (Trigger trigger : triggers.values()) {
            if (!(trigger instanceof TimerTrigger)) continue;
            cronTrigger = trigger.getSpec();
        }
        return cronTrigger;
    }

    public String getCronTriggerToolTip(Job job) {
        String toolTip = DEFAULT_TRIGGER;
        if (job == null) {
            return toolTip;
        }
        String cronTrigger = this.getCronTrigger(job);
        if (cronTrigger == null || cronTrigger.isEmpty() || DEFAULT_TRIGGER.equals(cronTrigger)) {
            return toolTip;
        }
        try {
            CronTabList ctl = CronTabList.create((String)cronTrigger, (Hash)Hash.from((String)job.getFullName()));
            if (ctl == null) {
                return toolTip;
            }
            DateFormat fmt = DateFormat.getDateTimeInstance(0, 0);
            Calendar previous = ctl.previous();
            Calendar next = ctl.next();
            if (previous == null || next == null) {
                return toolTip;
            }
            return Messages.CronTriggerColumn_ToolTipFormat(fmt.format(previous.getTime()), fmt.format(next.getTime()));
        }
        catch (IllegalArgumentException ex) {
            LOGGER.log(Level.WARNING, "IllegalArgumentException: %s", ex);
            return toolTip;
        }
    }

    @Extension
    public static class DescriptorImpl
    extends ListViewColumnDescriptor {
        public boolean shownByDefault() {
            return false;
        }

        public String getDisplayName() {
            return Messages.CronTriggerColumn_DisplayName();
        }

        public String getHelpFile() {
            return "/plugin/extra-columns/help-cron-trigger-column.html";
        }
    }
}

