// CHECKSTYLE:OFF

package jenkins.plugins.extracolumns;

import org.jvnet.localizer.Localizable;
import org.jvnet.localizer.ResourceBundleHolder;
import org.kohsuke.accmod.Restricted;


/**
 * Generated localization support class.
 * 
 */
@SuppressWarnings({
    "",
    "PMD",
    "all"
})
@Restricted(org.kohsuke.accmod.restrictions.NoExternalUse.class)
public class Messages {

    /**
     * The resource bundle reference
     * 
     */
    private final static ResourceBundleHolder holder = ResourceBundleHolder.get(Messages.class);

    /**
     * Key {@code LastBuildColumn.DisplayName}: {@code Last Build}.
     * 
     * @return
     *     {@code Last Build}
     */
    public static String LastBuildColumn_DisplayName() {
        return holder.format("LastBuildColumn.DisplayName");
    }

    /**
     * Key {@code LastBuildColumn.DisplayName}: {@code Last Build}.
     * 
     * @return
     *     {@code Last Build}
     */
    public static Localizable _LastBuildColumn_DisplayName() {
        return new Localizable(holder, "LastBuildColumn.DisplayName");
    }

    /**
     * Key {@code SlaveOrLabelColumn.DisplayName}: {@code Agent Allocation}.
     * 
     * @return
     *     {@code Agent Allocation}
     */
    public static String SlaveOrLabelColumn_DisplayName() {
        return holder.format("SlaveOrLabelColumn.DisplayName");
    }

    /**
     * Key {@code SlaveOrLabelColumn.DisplayName}: {@code Agent Allocation}.
     * 
     * @return
     *     {@code Agent Allocation}
     */
    public static Localizable _SlaveOrLabelColumn_DisplayName() {
        return new Localizable(holder, "SlaveOrLabelColumn.DisplayName");
    }

    /**
     * Key {@code CronTriggerColumn.ToolTipFormat}: {@code Would have last
     * run at {0}; would next run at {1}.}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Would have last run at {0}; would next run at {1}.}
     */
    public static String CronTriggerColumn_ToolTipFormat(Object arg0, Object arg1) {
        return holder.format("CronTriggerColumn.ToolTipFormat", arg0, arg1);
    }

    /**
     * Key {@code CronTriggerColumn.ToolTipFormat}: {@code Would have last
     * run at {0}; would next run at {1}.}.
     * 
     * @param arg1
     *      2nd format parameter, {@code {1}}, as {@link String#valueOf(Object)}.
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Would have last run at {0}; would next run at {1}.}
     */
    public static Localizable _CronTriggerColumn_ToolTipFormat(Object arg0, Object arg1) {
        return new Localizable(holder, "CronTriggerColumn.ToolTipFormat", arg0, arg1);
    }

    /**
     * Key {@code LastBuildColumn.LastBuild}: {@code Last Build}.
     * 
     * @return
     *     {@code Last Build}
     */
    public static String LastBuildColumn_LastBuild() {
        return holder.format("LastBuildColumn.LastBuild");
    }

    /**
     * Key {@code LastBuildColumn.LastBuild}: {@code Last Build}.
     * 
     * @return
     *     {@code Last Build}
     */
    public static Localizable _LastBuildColumn_LastBuild() {
        return new Localizable(holder, "LastBuildColumn.LastBuild");
    }

    /**
     * Key {@code JobTypeColumn.ExternalName}: {@code External}.
     * 
     * @return
     *     {@code External}
     */
    public static String JobTypeColumn_ExternalName() {
        return holder.format("JobTypeColumn.ExternalName");
    }

    /**
     * Key {@code JobTypeColumn.ExternalName}: {@code External}.
     * 
     * @return
     *     {@code External}
     */
    public static Localizable _JobTypeColumn_ExternalName() {
        return new Localizable(holder, "JobTypeColumn.ExternalName");
    }

    /**
     * Key {@code DisableProjectColumn.DisplayName}: {@code Disable/Enable
     * Project}.
     * 
     * @return
     *     {@code Disable/Enable Project}
     */
    public static String DisableProjectColumn_DisplayName() {
        return holder.format("DisableProjectColumn.DisplayName");
    }

    /**
     * Key {@code DisableProjectColumn.DisplayName}: {@code Disable/Enable
     * Project}.
     * 
     * @return
     *     {@code Disable/Enable Project}
     */
    public static Localizable _DisableProjectColumn_DisplayName() {
        return new Localizable(holder, "DisableProjectColumn.DisplayName");
    }

    /**
     * Key {@code LastBuildColumn.LastCompletedBuild}: {@code Last Completed
     * Build}.
     * 
     * @return
     *     {@code Last Completed Build}
     */
    public static String LastBuildColumn_LastCompletedBuild() {
        return holder.format("LastBuildColumn.LastCompletedBuild");
    }

    /**
     * Key {@code LastBuildColumn.LastCompletedBuild}: {@code Last Completed
     * Build}.
     * 
     * @return
     *     {@code Last Completed Build}
     */
    public static Localizable _LastBuildColumn_LastCompletedBuild() {
        return new Localizable(holder, "LastBuildColumn.LastCompletedBuild");
    }

    /**
     * Key {@code JobTypeColumn.WorkflowMultiBranchProjectName}: {@code
     * Multibranch Pipeline}.
     * 
     * @return
     *     {@code Multibranch Pipeline}
     */
    public static String JobTypeColumn_WorkflowMultiBranchProjectName() {
        return holder.format("JobTypeColumn.WorkflowMultiBranchProjectName");
    }

    /**
     * Key {@code JobTypeColumn.WorkflowMultiBranchProjectName}: {@code
     * Multibranch Pipeline}.
     * 
     * @return
     *     {@code Multibranch Pipeline}
     */
    public static Localizable _JobTypeColumn_WorkflowMultiBranchProjectName() {
        return new Localizable(holder, "JobTypeColumn.WorkflowMultiBranchProjectName");
    }

    /**
     * Key {@code BuildParametersColumn.DisplayName}: {@code Build
     * Parameters}.
     * 
     * @return
     *     {@code Build Parameters}
     */
    public static String BuildParametersColumn_DisplayName() {
        return holder.format("BuildParametersColumn.DisplayName");
    }

    /**
     * Key {@code BuildParametersColumn.DisplayName}: {@code Build
     * Parameters}.
     * 
     * @return
     *     {@code Build Parameters}
     */
    public static Localizable _BuildParametersColumn_DisplayName() {
        return new Localizable(holder, "BuildParametersColumn.DisplayName");
    }

    /**
     * Key {@code ConfigureProjectColumn.DisplayName}: {@code Configure
     * Project}.
     * 
     * @return
     *     {@code Configure Project}
     */
    public static String ConfigureProjectColumn_DisplayName() {
        return holder.format("ConfigureProjectColumn.DisplayName");
    }

    /**
     * Key {@code ConfigureProjectColumn.DisplayName}: {@code Configure
     * Project}.
     * 
     * @return
     *     {@code Configure Project}
     */
    public static Localizable _ConfigureProjectColumn_DisplayName() {
        return new Localizable(holder, "ConfigureProjectColumn.DisplayName");
    }

    /**
     * Key {@code LastBuildNodeColumn.DisplayName}: {@code Last Build Node}.
     * 
     * @return
     *     {@code Last Build Node}
     */
    public static String LastBuildNodeColumn_DisplayName() {
        return holder.format("LastBuildNodeColumn.DisplayName");
    }

    /**
     * Key {@code LastBuildNodeColumn.DisplayName}: {@code Last Build Node}.
     * 
     * @return
     *     {@code Last Build Node}
     */
    public static Localizable _LastBuildNodeColumn_DisplayName() {
        return new Localizable(holder, "LastBuildNodeColumn.DisplayName");
    }

    /**
     * Key {@code JobTypeColumn.FreestyleName}: {@code Free-style}.
     * 
     * @return
     *     {@code Free-style}
     */
    public static String JobTypeColumn_FreestyleName() {
        return holder.format("JobTypeColumn.FreestyleName");
    }

    /**
     * Key {@code JobTypeColumn.FreestyleName}: {@code Free-style}.
     * 
     * @return
     *     {@code Free-style}
     */
    public static Localizable _JobTypeColumn_FreestyleName() {
        return new Localizable(holder, "JobTypeColumn.FreestyleName");
    }

    /**
     * Key {@code LastBuildColumn.LastStableBuild}: {@code Last Stable
     * Build}.
     * 
     * @return
     *     {@code Last Stable Build}
     */
    public static String LastBuildColumn_LastStableBuild() {
        return holder.format("LastBuildColumn.LastStableBuild");
    }

    /**
     * Key {@code LastBuildColumn.LastStableBuild}: {@code Last Stable
     * Build}.
     * 
     * @return
     *     {@code Last Stable Build}
     */
    public static Localizable _LastBuildColumn_LastStableBuild() {
        return new Localizable(holder, "LastBuildColumn.LastStableBuild");
    }

    /**
     * Key {@code LastJobConfigurationModificationColumn.DisplayName}: {@code
     * Last Configuration Modification}.
     * 
     * @return
     *     {@code Last Configuration Modification}
     */
    public static String LastJobConfigurationModificationColumn_DisplayName() {
        return holder.format("LastJobConfigurationModificationColumn.DisplayName");
    }

    /**
     * Key {@code LastJobConfigurationModificationColumn.DisplayName}: {@code
     * Last Configuration Modification}.
     * 
     * @return
     *     {@code Last Configuration Modification}
     */
    public static Localizable _LastJobConfigurationModificationColumn_DisplayName() {
        return new Localizable(holder, "LastJobConfigurationModificationColumn.DisplayName");
    }

    /**
     * Key {@code JobTypeColumn.MultiConfigName}: {@code Multi-config}.
     * 
     * @return
     *     {@code Multi-config}
     */
    public static String JobTypeColumn_MultiConfigName() {
        return holder.format("JobTypeColumn.MultiConfigName");
    }

    /**
     * Key {@code JobTypeColumn.MultiConfigName}: {@code Multi-config}.
     * 
     * @return
     *     {@code Multi-config}
     */
    public static Localizable _JobTypeColumn_MultiConfigName() {
        return new Localizable(holder, "JobTypeColumn.MultiConfigName");
    }

    /**
     * Key {@code JobTypeColumn.IvyName}: {@code Ivy}.
     * 
     * @return
     *     {@code Ivy}
     */
    public static String JobTypeColumn_IvyName() {
        return holder.format("JobTypeColumn.IvyName");
    }

    /**
     * Key {@code JobTypeColumn.IvyName}: {@code Ivy}.
     * 
     * @return
     *     {@code Ivy}
     */
    public static Localizable _JobTypeColumn_IvyName() {
        return new Localizable(holder, "JobTypeColumn.IvyName");
    }

    /**
     * Key {@code JobTypeColumn.MavenName}: {@code Maven}.
     * 
     * @return
     *     {@code Maven}
     */
    public static String JobTypeColumn_MavenName() {
        return holder.format("JobTypeColumn.MavenName");
    }

    /**
     * Key {@code JobTypeColumn.MavenName}: {@code Maven}.
     * 
     * @return
     *     {@code Maven}
     */
    public static Localizable _JobTypeColumn_MavenName() {
        return new Localizable(holder, "JobTypeColumn.MavenName");
    }

    /**
     * Key {@code JobTypeColumn.FolderName}: {@code Folder}.
     * 
     * @return
     *     {@code Folder}
     */
    public static String JobTypeColumn_FolderName() {
        return holder.format("JobTypeColumn.FolderName");
    }

    /**
     * Key {@code JobTypeColumn.FolderName}: {@code Folder}.
     * 
     * @return
     *     {@code Folder}
     */
    public static Localizable _JobTypeColumn_FolderName() {
        return new Localizable(holder, "JobTypeColumn.FolderName");
    }

    /**
     * Key {@code CronTriggerColumn.DisplayName}: {@code Periodic Build
     * Trigger}.
     * 
     * @return
     *     {@code Periodic Build Trigger}
     */
    public static String CronTriggerColumn_DisplayName() {
        return holder.format("CronTriggerColumn.DisplayName");
    }

    /**
     * Key {@code CronTriggerColumn.DisplayName}: {@code Periodic Build
     * Trigger}.
     * 
     * @return
     *     {@code Periodic Build Trigger}
     */
    public static Localizable _CronTriggerColumn_DisplayName() {
        return new Localizable(holder, "CronTriggerColumn.DisplayName");
    }

    /**
     * Key {@code LastBuildColumn.LastUnsuccessfulBuild}: {@code Last
     * Unsuccessful Build}.
     * 
     * @return
     *     {@code Last Unsuccessful Build}
     */
    public static String LastBuildColumn_LastUnsuccessfulBuild() {
        return holder.format("LastBuildColumn.LastUnsuccessfulBuild");
    }

    /**
     * Key {@code LastBuildColumn.LastUnsuccessfulBuild}: {@code Last
     * Unsuccessful Build}.
     * 
     * @return
     *     {@code Last Unsuccessful Build}
     */
    public static Localizable _LastBuildColumn_LastUnsuccessfulBuild() {
        return new Localizable(holder, "LastBuildColumn.LastUnsuccessfulBuild");
    }

    /**
     * Key {@code LastBuildConsoleColumn.DisplayName}: {@code Last/Current
     * Build Console Output}.
     * 
     * @return
     *     {@code Last/Current Build Console Output}
     */
    public static String LastBuildConsoleColumn_DisplayName() {
        return holder.format("LastBuildConsoleColumn.DisplayName");
    }

    /**
     * Key {@code LastBuildConsoleColumn.DisplayName}: {@code Last/Current
     * Build Console Output}.
     * 
     * @return
     *     {@code Last/Current Build Console Output}
     */
    public static Localizable _LastBuildConsoleColumn_DisplayName() {
        return new Localizable(holder, "LastBuildConsoleColumn.DisplayName");
    }

    /**
     * Key {@code BuildDurationColumn.DisplayName}: {@code Build Duration}.
     * 
     * @return
     *     {@code Build Duration}
     */
    public static String BuildDurationColumn_DisplayName() {
        return holder.format("BuildDurationColumn.DisplayName");
    }

    /**
     * Key {@code BuildDurationColumn.DisplayName}: {@code Build Duration}.
     * 
     * @return
     *     {@code Build Duration}
     */
    public static Localizable _BuildDurationColumn_DisplayName() {
        return new Localizable(holder, "BuildDurationColumn.DisplayName");
    }

    /**
     * Key {@code DescriptionColumn.DisplayName}: {@code Project
     * Description}.
     * 
     * @return
     *     {@code Project Description}
     */
    public static String DescriptionColumn_DisplayName() {
        return holder.format("DescriptionColumn.DisplayName");
    }

    /**
     * Key {@code DescriptionColumn.DisplayName}: {@code Project
     * Description}.
     * 
     * @return
     *     {@code Project Description}
     */
    public static Localizable _DescriptionColumn_DisplayName() {
        return new Localizable(holder, "DescriptionColumn.DisplayName");
    }

    /**
     * Key {@code WorkspaceColumn.DisplayName}: {@code Workspace}.
     * 
     * @return
     *     {@code Workspace}
     */
    public static String WorkspaceColumn_DisplayName() {
        return holder.format("WorkspaceColumn.DisplayName");
    }

    /**
     * Key {@code WorkspaceColumn.DisplayName}: {@code Workspace}.
     * 
     * @return
     *     {@code Workspace}
     */
    public static Localizable _WorkspaceColumn_DisplayName() {
        return new Localizable(holder, "WorkspaceColumn.DisplayName");
    }

    /**
     * Key {@code JobTypeColumn.MultiJobName}: {@code MultiJob}.
     * 
     * @return
     *     {@code MultiJob}
     */
    public static String JobTypeColumn_MultiJobName() {
        return holder.format("JobTypeColumn.MultiJobName");
    }

    /**
     * Key {@code JobTypeColumn.MultiJobName}: {@code MultiJob}.
     * 
     * @return
     *     {@code MultiJob}
     */
    public static Localizable _JobTypeColumn_MultiJobName() {
        return new Localizable(holder, "JobTypeColumn.MultiJobName");
    }

    /**
     * Key {@code UserNameColumn.DisplayName}: {@code User Name}.
     * 
     * @return
     *     {@code User Name}
     */
    public static String UserNameColumn_DisplayName() {
        return holder.format("UserNameColumn.DisplayName");
    }

    /**
     * Key {@code UserNameColumn.DisplayName}: {@code User Name}.
     * 
     * @return
     *     {@code User Name}
     */
    public static Localizable _UserNameColumn_DisplayName() {
        return new Localizable(holder, "UserNameColumn.DisplayName");
    }

    /**
     * Key {@code LastBuildColumn.LastUnstableBuild}: {@code Last Unstable
     * Build}.
     * 
     * @return
     *     {@code Last Unstable Build}
     */
    public static String LastBuildColumn_LastUnstableBuild() {
        return holder.format("LastBuildColumn.LastUnstableBuild");
    }

    /**
     * Key {@code LastBuildColumn.LastUnstableBuild}: {@code Last Unstable
     * Build}.
     * 
     * @return
     *     {@code Last Unstable Build}
     */
    public static Localizable _LastBuildColumn_LastUnstableBuild() {
        return new Localizable(holder, "LastBuildColumn.LastUnstableBuild");
    }

    /**
     * Key {@code BuildDescriptionColumn.DisplayName}: {@code Build
     * Description}.
     * 
     * @return
     *     {@code Build Description}
     */
    public static String BuildDescriptionColumn_DisplayName() {
        return holder.format("BuildDescriptionColumn.DisplayName");
    }

    /**
     * Key {@code BuildDescriptionColumn.DisplayName}: {@code Build
     * Description}.
     * 
     * @return
     *     {@code Build Description}
     */
    public static Localizable _BuildDescriptionColumn_DisplayName() {
        return new Localizable(holder, "BuildDescriptionColumn.DisplayName");
    }

    /**
     * Key {@code LastBuildColumn.LastSuccessfulBuild}: {@code Last
     * Successful Build}.
     * 
     * @return
     *     {@code Last Successful Build}
     */
    public static String LastBuildColumn_LastSuccessfulBuild() {
        return holder.format("LastBuildColumn.LastSuccessfulBuild");
    }

    /**
     * Key {@code LastBuildColumn.LastSuccessfulBuild}: {@code Last
     * Successful Build}.
     * 
     * @return
     *     {@code Last Successful Build}
     */
    public static Localizable _LastBuildColumn_LastSuccessfulBuild() {
        return new Localizable(holder, "LastBuildColumn.LastSuccessfulBuild");
    }

    /**
     * Key {@code JobTypeColumn.DisplayName}: {@code Job Type}.
     * 
     * @return
     *     {@code Job Type}
     */
    public static String JobTypeColumn_DisplayName() {
        return holder.format("JobTypeColumn.DisplayName");
    }

    /**
     * Key {@code JobTypeColumn.DisplayName}: {@code Job Type}.
     * 
     * @return
     *     {@code Job Type}
     */
    public static Localizable _JobTypeColumn_DisplayName() {
        return new Localizable(holder, "JobTypeColumn.DisplayName");
    }

    /**
     * Key {@code TestResultColumn.DisplayName}: {@code Test Result}.
     * 
     * @return
     *     {@code Test Result}
     */
    public static String TestResultColumn_DisplayName() {
        return holder.format("TestResultColumn.DisplayName");
    }

    /**
     * Key {@code TestResultColumn.DisplayName}: {@code Test Result}.
     * 
     * @return
     *     {@code Test Result}
     */
    public static Localizable _TestResultColumn_DisplayName() {
        return new Localizable(holder, "TestResultColumn.DisplayName");
    }

    /**
     * Key {@code JobTypeColumn.WorkflowJobName}: {@code Pipeline}.
     * 
     * @return
     *     {@code Pipeline}
     */
    public static String JobTypeColumn_WorkflowJobName() {
        return holder.format("JobTypeColumn.WorkflowJobName");
    }

    /**
     * Key {@code JobTypeColumn.WorkflowJobName}: {@code Pipeline}.
     * 
     * @return
     *     {@code Pipeline}
     */
    public static Localizable _JobTypeColumn_WorkflowJobName() {
        return new Localizable(holder, "JobTypeColumn.WorkflowJobName");
    }

    /**
     * Key {@code SCMTypeColumn.DisplayName}: {@code SCM Type}.
     * 
     * @return
     *     {@code SCM Type}
     */
    public static String SCMTypeColumn_DisplayName() {
        return holder.format("SCMTypeColumn.DisplayName");
    }

    /**
     * Key {@code SCMTypeColumn.DisplayName}: {@code SCM Type}.
     * 
     * @return
     *     {@code SCM Type}
     */
    public static Localizable _SCMTypeColumn_DisplayName() {
        return new Localizable(holder, "SCMTypeColumn.DisplayName");
    }

    /**
     * Key {@code LastBuildColumn.LastFailedBuild}: {@code Last Failed
     * Build}.
     * 
     * @return
     *     {@code Last Failed Build}
     */
    public static String LastBuildColumn_LastFailedBuild() {
        return holder.format("LastBuildColumn.LastFailedBuild");
    }

    /**
     * Key {@code LastBuildColumn.LastFailedBuild}: {@code Last Failed
     * Build}.
     * 
     * @return
     *     {@code Last Failed Build}
     */
    public static Localizable _LastBuildColumn_LastFailedBuild() {
        return new Localizable(holder, "LastBuildColumn.LastFailedBuild");
    }

}
