/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.badge;

import hudson.PluginWrapper;
import jakarta.servlet.ServletException;
import java.awt.Canvas;
import java.awt.Font;
import java.awt.FontFormatException;
import java.awt.FontMetrics;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import org.apache.commons.io.IOUtils;
import org.apache.commons.text.StringEscapeUtils;
import org.kohsuke.stapler.HttpResponse;
import org.kohsuke.stapler.StaplerRequest2;
import org.kohsuke.stapler.StaplerResponse2;

class StatusImage
implements HttpResponse {
    public static final Logger LOGGER = Logger.getLogger(StatusImage.class.getName());
    private final byte[] payload;
    private static final String PLGIN_NAME = "embeddable-build-status";
    private static final Jenkins jInstance = Jenkins.get();
    private static final PluginWrapper plugin = StatusImage.jInstance.pluginManager.getPlugin("embeddable-build-status");
    private static final URL baseUrl = plugin != null ? StatusImage.plugin.baseResourceURL : null;
    private final String etag;
    private final String length;
    private String contentType;
    private static final Map<String, String> COLORS = Map.of("red", "#e05d44", "brightgreen", "#44cc11", "green", "#97CA00", "yellowgreen", "#a4a61d", "yellow", "#dfb317", "orange", "#fe7d37", "lightgrey", "#9f9f9f", "blue", "#007ec6");
    private static volatile FontMetrics cachedFontMetrics;
    private static final Object fontLoadLock;
    private static final String FONT_NAME = "fonts/Bitstream-Vera-Sans-Roman.ttf";

    StatusImage() {
        this.etag = "\"" + Jenkins.RESOURCE_PATH + "/empty\"";
        this.length = Integer.toString(0);
        this.payload = new byte[0];
    }

    StatusImage(String fileName) throws IOException {
        URL rootUrl = new URL(jInstance.getRootUrl());
        this.etag = "\"" + fileName + "\"";
        URL image = new URL(rootUrl, fileName);
        try (InputStream s = image.openStream();){
            this.payload = IOUtils.toByteArray((InputStream)s);
        }
        this.length = Integer.toString(this.payload.length);
    }

    StatusImage(String subject, String status, String colorName, String animatedColorName, String style, String link) throws IOException {
        if (subject != null) {
            subject = StringEscapeUtils.escapeHtml4((String)subject);
        }
        if (status != null) {
            status = StringEscapeUtils.escapeHtml4((String)status);
        }
        if (animatedColorName != null) {
            animatedColorName = StringEscapeUtils.escapeHtml4((String)animatedColorName);
        }
        if (colorName != null) {
            colorName = StringEscapeUtils.escapeHtml4((String)colorName);
        }
        if (link != null) {
            link = StringEscapeUtils.escapeHtml4((String)StringEscapeUtils.escapeHtml4((String)link));
        }
        if (baseUrl != null) {
            Object color;
            this.etag = Jenkins.RESOURCE_PATH + "/" + subject + status + colorName + animatedColorName + style;
            if (style == null || !Arrays.asList("flat-square", "plastic").contains(style)) {
                style = "flat";
            }
            URL image = new URL(baseUrl, "status/" + style + ".svg");
            URL animatedSnippet = null;
            Object animatedColor = null;
            if (animatedColorName != null) {
                animatedSnippet = new URL(baseUrl, "status/animatedOverlay.svg.snippet");
                animatedColor = COLORS.get(animatedColorName.toLowerCase());
                if (animatedColor == null) {
                    animatedColor = colorName.matches("-?[0-9a-fA-F]+") ? "#" + animatedColorName : animatedColorName;
                }
            }
            double[] widths = new double[]{this.measureText(subject) + 20, this.measureText(status) + 20};
            if (animatedColor != null) {
                widths[1] = widths[1] + 4.0;
            }
            if ((color = COLORS.get(colorName.toLowerCase())) == null) {
                color = colorName.matches("-?[0-9a-fA-F]+") ? "#" + colorName : colorName;
            }
            String fullwidth = String.valueOf(widths[0] + widths[1]);
            String subjectWidth = String.valueOf(widths[0]);
            String statusWidth = String.valueOf(widths[1]);
            String subjectPos = String.valueOf(widths[0] / 2.0 + 1.0);
            String statusPos = String.valueOf(widths[0] + widths[1] / 2.0 - 1.0);
            String animatedOverlay = "";
            Object linkCode = "<svg xmlns";
            if (animatedSnippet != null) {
                String reducedStatusWidth = String.valueOf(widths[1] - 4.0);
                try (InputStream animatedOverlayStream = animatedSnippet.openStream();){
                    animatedOverlay = IOUtils.toString((InputStream)animatedOverlayStream, (Charset)StandardCharsets.UTF_8).replace("{{reducedStatusWidth}}", reducedStatusWidth).replace("{{animatedColor}}", (CharSequence)animatedColor);
                }
            }
            if (link != null) {
                try {
                    URL url = new URL(link);
                    String protocol = url.getProtocol();
                    if ("http".equals(protocol) || "https".equals(protocol)) {
                        linkCode = "<svg onclick=\"window.open(&quot;" + link + "&quot;);\" style=\"cursor: pointer;\" xmlns";
                    } else {
                        LOGGER.log(Level.FINE, "Invalid link protocol: {0}", protocol);
                    }
                }
                catch (MalformedURLException ex) {
                    LOGGER.log(Level.FINE, "Invalid link URL: " + link, ex);
                }
            }
            try (InputStream s = image.openStream();){
                this.payload = IOUtils.toString((InputStream)s, (Charset)StandardCharsets.UTF_8).replace("{{animatedOverlayColor}}", animatedOverlay).replace("{{fullwidth}}", fullwidth).replace("{{subjectWidth}}", subjectWidth).replace("{{statusWidth}}", statusWidth).replace("{{subjectPos}}", subjectPos).replace("{{statusPos}}", statusPos).replace("{{subject}}", subject).replace("{{status}}", status).replace("{{color}}", (CharSequence)color).replace("<svg xmlns", (CharSequence)linkCode).getBytes(StandardCharsets.UTF_8);
            }
            this.length = Integer.toString(this.payload.length);
            this.contentType = "image/svg+xml;charset=utf-8";
        } else {
            this.etag = "\"" + Jenkins.RESOURCE_PATH + "/empty\"";
            this.length = Integer.toString(0);
            this.payload = new byte[0];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static FontMetrics getDefaultFontMetrics() {
        if (cachedFontMetrics == null) {
            Object object = fontLoadLock;
            synchronized (object) {
                if (cachedFontMetrics == null) {
                    Font defaultFont;
                    block17: {
                        defaultFont = null;
                        try {
                            if (baseUrl == null) break block17;
                            URL fontURL = new URL(baseUrl, FONT_NAME);
                            try (InputStream fontStream = fontURL.openStream();){
                                defaultFont = Font.createFont(0, fontStream);
                                defaultFont = defaultFont.deriveFont(11.0f);
                            }
                            catch (FontFormatException ex) {
                                LOGGER.log(Level.SEVERE, "Font format exception fonts/Bitstream-Vera-Sans-Roman.ttf", ex);
                            }
                            catch (IOException ex) {
                                LOGGER.log(Level.SEVERE, "IOException reading fonts/Bitstream-Vera-Sans-Roman.ttf", ex);
                            }
                        }
                        catch (MalformedURLException ex) {
                            LOGGER.log(Level.SEVERE, "Malformed URL on static font fonts/Bitstream-Vera-Sans-Roman.ttf", ex);
                        }
                    }
                    if (defaultFont == null) {
                        defaultFont = new Font("SansSerif", 0, 11);
                    }
                    Canvas canvas = new Canvas();
                    cachedFontMetrics = canvas.getFontMetrics(defaultFont);
                }
            }
        }
        return cachedFontMetrics;
    }

    public int measureText(String text) throws IOException {
        return baseUrl != null ? StatusImage.getDefaultFontMetrics().stringWidth(text) : 0;
    }

    public void generateResponse(StaplerRequest2 req, StaplerResponse2 rsp, Object node) throws IOException, ServletException {
        String v = req.getHeader("If-None-Match");
        if (this.etag.equals(v)) {
            rsp.setStatus(304);
            return;
        }
        rsp.setHeader("ETag", this.etag);
        rsp.setHeader("Expires", "Fri, 01 Jan 1984 00:00:00 GMT");
        rsp.setHeader("Cache-Control", "no-cache, no-store, private");
        if (this.contentType != null) {
            rsp.setHeader("Content-Type", this.contentType);
        }
        rsp.setHeader("Content-Length", this.length);
        rsp.getOutputStream().write(this.payload);
    }

    String getEtag() {
        return this.etag;
    }

    String getLength() {
        return this.length;
    }

    String getContentType() {
        return this.contentType;
    }

    static {
        fontLoadLock = new Object();
    }
}

