/*
 * Decompiled with CFR 0.152.
 */
package com.robestone.hudson.compactcolumns;

import com.robestone.hudson.compactcolumns.AbstractCompactColumn;
import com.robestone.hudson.compactcolumns.AbstractStatusesColumn;
import com.robestone.hudson.compactcolumns.BuildInfo;
import com.robestone.hudson.compactcolumns.Messages;
import hudson.Extension;
import hudson.model.Job;
import hudson.model.Result;
import hudson.model.Run;
import java.io.IOException;
import java.util.List;
import java.util.Locale;
import jenkins.model.Jenkins;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.DataBoundConstructor;

public class JobNameColorColumn
extends AbstractCompactColumn {
    private final boolean showColor;
    private final boolean showDescription;
    private final boolean showLastBuild;

    @DataBoundConstructor
    public JobNameColorColumn(boolean showColor, boolean showDescription, boolean showLastBuild, String colorblindHint) {
        super(colorblindHint);
        this.showColor = showColor;
        this.showDescription = showDescription;
        this.showLastBuild = showLastBuild;
    }

    public String getStyle(Job job) {
        String underline;
        String color;
        Run run;
        Result result = null;
        if (job != null && (run = job.getLastBuild()) != null) {
            result = run.getResult();
        }
        if (result == null) {
            color = BuildInfo.getOtherColor();
            underline = "1px dashed";
        } else if (Result.ABORTED.equals(result)) {
            color = BuildInfo.getOtherColor();
            underline = "1px dashed";
        } else if (Result.FAILURE.equals(result)) {
            color = BuildInfo.getFailedColor();
            underline = "1px solid";
        } else if (Result.NOT_BUILT.equals(result)) {
            color = BuildInfo.getOtherColor();
            underline = "1px dashed";
        } else if (Result.SUCCESS.equals(result)) {
            color = BuildInfo.getStableColor();
            underline = "0px solid";
        } else if (Result.UNSTABLE.equals(result)) {
            color = BuildInfo.getUnstableColor();
            underline = "1px dashed";
        } else {
            color = BuildInfo.getOtherColor();
            underline = "1px dashed";
        }
        Object style = "";
        if (this.showColor) {
            style = (String)style + "color: " + color + ";";
        }
        if (this.isShowColorblindUnderlineHint()) {
            style = (String)style + "text-decoration: none; border-bottom: " + underline + ";";
        }
        return style;
    }

    public String getToolTip(Job job, Locale locale) throws IOException {
        BuildInfo build;
        String desc;
        List<BuildInfo> builds;
        String desc2;
        StringBuilder tip = new StringBuilder();
        if (this.showDescription && !(desc2 = Jenkins.get().getMarkupFormatter().translate(job.getDescription())).isBlank()) {
            tip.append(desc2);
        }
        if (this.showLastBuild && !(builds = AbstractStatusesColumn.getBuilds(job, locale, false, false, true, this.isShowColorblindUnderlineHint(), AbstractStatusesColumn.TimeAgoType.DIFF, 0)).isEmpty() && !(desc = AbstractStatusesColumn.getBuildDescriptionToolTip(build = builds.get(0), locale)).isEmpty()) {
            if (!tip.isEmpty()) {
                tip.append("<hr/>");
            }
            tip.append(desc);
        }
        return !tip.isEmpty() ? tip.toString() : null;
    }

    public boolean isShowColor() {
        return this.showColor;
    }

    public boolean isShowDescription() {
        return this.showDescription;
    }

    public boolean isShowLastBuild() {
        return this.showLastBuild;
    }

    @Extension
    @Symbol(value={"compactJobNameColor"})
    public static class DescriptorImpl
    extends AbstractStatusesColumn.AbstractCompactColumnDescriptor {
        public String getColumnDisplayName() {
            return Messages.jobColumn_displayName();
        }

        public String getDisplayName() {
            return Messages.Compact_Column_Job_Name_w_Options();
        }

        public String getHelpFile() {
            return "/plugin/compact-columns/job-name-color-column.html";
        }
    }
}

