/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hudson.plugins.collapsingconsolesections;

import hudson.MarkupText;
import hudson.Util;
import hudson.console.ConsoleAnnotator;
import hudson.model.Run;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.Stack;
import java.util.regex.Matcher;
import javax.annotation.Nonnull;
import org.jvnet.hudson.plugins.collapsingconsolesections.CollapsingSectionsConfiguration;
import org.jvnet.hudson.plugins.collapsingconsolesections.SectionDefinition;

public class CollapsingSectionAnnotator
extends ConsoleAnnotator<Object> {
    @Nonnull
    private List<SectionDefinition> sections;
    @Nonnull
    private Stack<SectionDefinition> currentSections;
    @Nonnull
    private Stack<StackLevel> numberingStack;
    @Nonnull
    private CollapsingSectionsConfiguration configs;

    public CollapsingSectionAnnotator(@Nonnull CollapsingSectionsConfiguration configs) {
        this.configs = configs;
        this.sections = Arrays.asList(configs.getSectionDefinitions());
        this.currentSections = new Stack();
        this.numberingStack = new Stack();
        this.numberingStack.add(new StackLevel());
    }

    public ConsoleAnnotator annotate(Object context, MarkupText text) {
        SectionDefinition currentSection;
        if (!(context instanceof Run)) {
            return null;
        }
        while (!this.currentSections.empty() && (currentSection = this.currentSections.peek()).getSectionEndPattern().matcher(text.getText().trim()).matches()) {
            this.popSection(text);
            if (!currentSection.isCollapseOnlyOneLevel()) continue;
            break;
        }
        for (SectionDefinition section : this.sections) {
            Matcher m = section.getSectionStartPattern().matcher(text.getText().trim());
            if (!m.matches()) continue;
            this.pushSection(text, m, section);
        }
        return this;
    }

    @Nonnull
    private String getCurrentLevelPrefix() {
        StringBuilder str = new StringBuilder();
        if (this.configs.isNumberingEnabled()) {
            for (int i = 0; i < this.currentSections.size() + 1; ++i) {
                str.append(((StackLevel)this.numberingStack.get(i)).getCounter());
                str.append(".");
            }
            str.append(' ');
        }
        return str.toString();
    }

    private void pushSection(@Nonnull MarkupText text, @Nonnull Matcher m, @Nonnull SectionDefinition section) {
        this.numberingStack.peek().increment();
        text.addMarkup(0, 0, "", "<details class=\"collapsingSection\" " + (section.isCollapseSection() ? "" : " open") + "><summary class=\"collapseHeader\">" + this.getCurrentLevelPrefix() + Util.escape((String)section.getSectionDisplayName(m)) + "</summary><div>");
        this.numberingStack.add(new StackLevel());
        this.currentSections.push(section);
    }

    private void popSection(@Nonnull MarkupText text) {
        text.addMarkup(text.getText().length(), "</div></details>");
        this.currentSections.pop();
        this.numberingStack.pop();
    }

    private static class StackLevel
    implements Serializable {
        int counter = 0;

        private StackLevel() {
        }

        public void increment() {
            ++this.counter;
        }

        public int getCounter() {
            return this.counter;
        }
    }
}

