/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.codesonar.services;

import java.io.BufferedInputStream;
import java.io.InputStream;
import java.io.Serializable;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import org.jenkinsci.plugins.codesonar.CodeSonarPluginException;

public class XmlSerializationService
implements Serializable {
    private CodeSonarPluginException createError(String msg, Throwable cause) {
        return new CodeSonarPluginException(msg, cause, new Object[0]);
    }

    public <T extends Serializable> T deserialize(InputStream content, Class<T> t) throws CodeSonarPluginException {
        ClassLoader originalClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
            JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{t});
            Unmarshaller un = context.createUnmarshaller();
            BufferedInputStream bis = new BufferedInputStream(content);
            Serializable serializable = (Serializable)un.unmarshal((InputStream)bis);
            return (T)serializable;
        }
        catch (JAXBException ex) {
            throw this.createError("Error deserializing XML.", ex);
        }
        finally {
            Thread.currentThread().setContextClassLoader(originalClassLoader);
        }
    }
}

