/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.codesonar.services;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonSyntaxException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.http.client.utils.URIBuilder;
import org.javatuples.Pair;
import org.jenkinsci.plugins.codesonar.CodeSonarHubCommunicationException;
import org.jenkinsci.plugins.codesonar.CodeSonarJsonSyntaxException;
import org.jenkinsci.plugins.codesonar.CodeSonarPluginException;
import org.jenkinsci.plugins.codesonar.CodeSonarRequestURISyntaxException;
import org.jenkinsci.plugins.codesonar.models.json.CodeSonarWarningSearchData;
import org.jenkinsci.plugins.codesonar.models.json.SearchConfigData;
import org.jenkinsci.plugins.codesonar.services.AbstractService;
import org.jenkinsci.plugins.codesonar.services.HttpService;
import org.jenkinsci.plugins.codesonar.services.HttpServiceResponse;
import org.jenkinsci.plugins.codesonar.services.JsonStringPairSerializer;
import org.jenkinsci.plugins.codesonar.services.Utils;

public class WarningsService
extends AbstractService {
    private static final Logger LOGGER = Logger.getLogger(WarningsService.class.getName());
    private final HttpService httpService;
    private boolean strictQueryParameters;

    public WarningsService(HttpService httpService, boolean strictQueryParameters) {
        this.httpService = httpService;
        this.strictQueryParameters = strictQueryParameters;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getNumberOfWarningsWithScoreAboveThreshold(URI baseHubUri, long analysisId, int threshold, String visibilityFilter) throws CodeSonarPluginException {
        SearchConfigData searchConfig = new SearchConfigData();
        searchConfig.setCount(true);
        searchConfig.setLimit(0);
        Gson gsonSerializer = new GsonBuilder().registerTypeAdapter(Pair.class, (Object)new JsonStringPairSerializer()).create();
        String searchConfigAsJson = gsonSerializer.toJson((Object)searchConfig);
        URIBuilder uriBuilder = new URIBuilder(baseHubUri);
        uriBuilder.setPath("search.json");
        uriBuilder.addParameter("scope", String.format("aid:%d", analysisId));
        if (visibilityFilter != null && visibilityFilter.length() > 0) {
            uriBuilder.addParameter("filter", Utils.formatParameter(visibilityFilter, this.strictQueryParameters));
        }
        uriBuilder.addParameter("swarnings_json", searchConfigAsJson);
        uriBuilder.addParameter("query", String.format("score>%d", threshold));
        URI requestUri = null;
        try {
            requestUri = uriBuilder.build();
        }
        catch (URISyntaxException e) {
            throw new CodeSonarRequestURISyntaxException(e);
        }
        String requestUriString = requestUri.toASCIIString();
        CodeSonarWarningSearchData warningSearchData = null;
        HttpServiceResponse response = this.httpService.getResponseFromUrl(requestUriString);
        try {
            if (response.getStatusCode() != 200) {
                throw new CodeSonarHubCommunicationException(requestUriString, response.getStatusCode(), response.getReasonPhrase(), this.readResponseContent(response, requestUriString));
            }
            Gson gsonDeserializer = new Gson();
            try {
                warningSearchData = (CodeSonarWarningSearchData)gsonDeserializer.fromJson((Reader)new InputStreamReader(response.getContentInputStream(), StandardCharsets.UTF_8), CodeSonarWarningSearchData.class);
                LOGGER.log(Level.INFO, "response warningSearchData={0}", warningSearchData.toString());
            }
            catch (JsonSyntaxException e) {
                throw new CodeSonarJsonSyntaxException((Exception)((Object)e));
            }
        }
        finally {
            block14: {
                try {
                    response.close();
                }
                catch (IOException ex) {
                    if (warningSearchData != null) break block14;
                    throw new CodeSonarPluginException("Failed to close HTTP response", (Throwable)ex, new Object[0]);
                }
            }
        }
        return warningSearchData.getCount();
    }
}

