/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.codesonar.services;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.http.client.utils.URIBuilder;
import org.javatuples.Pair;
import org.jenkinsci.plugins.codesonar.CodeSonarHubCommunicationException;
import org.jenkinsci.plugins.codesonar.CodeSonarPluginException;
import org.jenkinsci.plugins.codesonar.CodeSonarRequestURISyntaxException;
import org.jenkinsci.plugins.codesonar.models.json.ProcedureJsonRow;
import org.jenkinsci.plugins.codesonar.models.json.SearchConfigData;
import org.jenkinsci.plugins.codesonar.models.procedures.Procedures;
import org.jenkinsci.plugins.codesonar.services.AbstractService;
import org.jenkinsci.plugins.codesonar.services.HttpService;
import org.jenkinsci.plugins.codesonar.services.HttpServiceResponse;
import org.jenkinsci.plugins.codesonar.services.JsonStringPairSerializer;
import org.jenkinsci.plugins.codesonar.services.ProcedureJsonRowReader;
import org.jenkinsci.plugins.codesonar.services.Utils;
import org.jenkinsci.plugins.codesonar.services.XmlSerializationService;

public class ProceduresService
extends AbstractService {
    private static final Logger LOGGER = Logger.getLogger(ProceduresService.class.getName());
    private final HttpService httpService;
    private final XmlSerializationService xmlSerializationService;
    private boolean strictQueryParameters;

    public ProceduresService(HttpService httpService, XmlSerializationService xmlSerializationService, boolean strictQueryParameters) {
        this.httpService = httpService;
        this.xmlSerializationService = xmlSerializationService;
        this.strictQueryParameters = strictQueryParameters;
    }

    public URI getProceduresUriFromAnAnalysisId(URI baseHubUri, String analysisId) {
        return baseHubUri.resolve(String.format("/analysis/%s-procedures.xml", analysisId));
    }

    public Procedures getProceduresFromUri(URI proceduresUri) throws CodeSonarPluginException {
        LOGGER.log(Level.INFO, String.format("Calling getProceduresFromUri", new Object[0]));
        HttpServiceResponse response = this.httpService.getResponseFromUrl(proceduresUri);
        if (response.getStatusCode() != 200) {
            throw new CodeSonarHubCommunicationException(proceduresUri, response.getStatusCode(), response.getReasonPhrase(), this.readResponseContent(response, proceduresUri));
        }
        return this.xmlSerializationService.deserialize(response.getContentInputStream(), Procedures.class);
    }

    public ProcedureJsonRow getProcedureWithMaxCyclomaticComplexity(URI baseHubUri, long analysisId) throws CodeSonarPluginException {
        URI requestUri;
        SearchConfigData searchConfig = new SearchConfigData();
        searchConfig.setLimit(100);
        searchConfig.getColumns().add("metricCyclomaticComplexity");
        searchConfig.getColumns().add("procedure");
        searchConfig.addOrderByCondition("metricCyclomaticComplexity", SearchConfigData.SortingOrder.DESCENDING);
        Gson gsonSerializer = new GsonBuilder().registerTypeAdapter(Pair.class, (Object)new JsonStringPairSerializer()).create();
        String searchConfigAsJson = gsonSerializer.toJson((Object)searchConfig);
        URIBuilder uriBuilder = new URIBuilder(baseHubUri);
        uriBuilder.setPath(String.format("/analysis/%d-procedures.json", analysisId));
        uriBuilder.addParameter("aproc_json", searchConfigAsJson);
        uriBuilder.addParameter("proc_filter", Utils.formatParameter("all", this.strictQueryParameters));
        try {
            requestUri = uriBuilder.build();
        }
        catch (URISyntaxException e) {
            throw new CodeSonarRequestURISyntaxException(e);
        }
        String requestUriString = requestUri.toASCIIString();
        HttpServiceResponse response = this.httpService.getResponseFromUrl(requestUriString);
        if (response.getStatusCode() != 200) {
            throw new CodeSonarHubCommunicationException(requestUriString, response.getStatusCode(), response.getReasonPhrase(), this.readResponseContent(response, requestUriString));
        }
        ArrayList<ProcedureJsonRow> rows = new ArrayList<ProcedureJsonRow>();
        ProcedureJsonRowReader reader = new ProcedureJsonRowReader(response.getContentInputStream());
        try {
            ProcedureJsonRow row = reader.readNextRow();
            while (row != null) {
                rows.add(row);
                row = reader.readNextRow();
            }
        }
        catch (IOException e) {
            reader.close();
            throw new CodeSonarPluginException("Error parsing procedures response: {0}", (Throwable)e, requestUriString);
        }
        LOGGER.fine("rows (before sorting)=" + String.valueOf(rows));
        Collections.sort(rows);
        LOGGER.fine("rows (after sorting)=" + String.valueOf(rows));
        ProcedureJsonRow maxCyclomaticComplexityProcedure = null;
        if (rows.size() <= 0) {
            throw new CodeSonarPluginException("Procedures search returned 0 rows", new Object[0]);
        }
        maxCyclomaticComplexityProcedure = (ProcedureJsonRow)rows.get(0);
        return maxCyclomaticComplexityProcedure;
    }
}

