/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.codesonar.services;

import com.google.gson.stream.JsonReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jenkinsci.plugins.codesonar.models.json.ProcedureJsonRow;

class ProcedureJsonRowReader {
    private static final Logger LOGGER = Logger.getLogger(ProcedureJsonRowReader.class.getName());
    private JsonReader inputJsonReader;
    private JsonReader rowsJsonReader = null;

    public ProcedureJsonRowReader(InputStream inputStream) {
        InputStreamReader inputStreamReader = new InputStreamReader(inputStream, StandardCharsets.UTF_8);
        this.inputJsonReader = new JsonReader((Reader)inputStreamReader);
    }

    public void close() {
        if (this.inputJsonReader != null) {
            try {
                this.inputJsonReader.close();
            }
            catch (IOException e) {
                LOGGER.log(Level.SEVERE, "Error closing JsonReader", e);
            }
        }
        this.inputJsonReader = null;
        this.rowsJsonReader = null;
    }

    public ProcedureJsonRow readNextRow() throws IOException {
        JsonReader jsonReader = this.inputJsonReader;
        ProcedureJsonRow row = null;
        if (jsonReader != null && this.rowsJsonReader == null) {
            jsonReader.beginObject();
            while (jsonReader.hasNext() && this.rowsJsonReader == null) {
                String propertyName = jsonReader.nextName();
                if (propertyName.equals("rows")) {
                    jsonReader.beginArray();
                    this.rowsJsonReader = jsonReader;
                    continue;
                }
                jsonReader.skipValue();
            }
            if (this.rowsJsonReader == null) {
                jsonReader.endObject();
                throw new IOException("A 'rows' property was expected, but not found in the Procedures JSON results");
            }
        }
        if (this.rowsJsonReader != null) {
            if (this.rowsJsonReader.hasNext()) {
                row = this.readProcedureJsonRowObject(jsonReader);
            } else {
                this.rowsJsonReader = null;
                this.close();
            }
        }
        return row;
    }

    private ProcedureJsonRow readProcedureJsonRowObject(JsonReader jsonReader) throws IOException {
        ProcedureJsonRow row = new ProcedureJsonRow();
        jsonReader.beginObject();
        while (jsonReader.hasNext()) {
            String propertyName = jsonReader.nextName();
            if (propertyName.equals("procedure")) {
                row.setProcedure(jsonReader.nextString());
                continue;
            }
            if (propertyName.equals("metricCyclomaticComplexity")) {
                row.setMetricCyclomaticComplexity(jsonReader.nextInt());
                continue;
            }
            jsonReader.skipValue();
        }
        jsonReader.endObject();
        return row;
    }
}

