/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.codesonar.services;

import com.google.common.base.Throwables;
import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import java.io.IOException;
import java.net.URI;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.apache.http.client.fluent.Request;
import org.jenkinsci.plugins.codesonar.CodeSonarHubCommunicationException;
import org.jenkinsci.plugins.codesonar.CodeSonarJsonSyntaxException;
import org.jenkinsci.plugins.codesonar.CodeSonarLogger;
import org.jenkinsci.plugins.codesonar.CodeSonarPluginException;
import org.jenkinsci.plugins.codesonar.models.CodeSonarHubClientCompatibilityInfo;
import org.jenkinsci.plugins.codesonar.models.CodeSonarHubInfo;
import org.jenkinsci.plugins.codesonar.services.AbstractService;
import org.jenkinsci.plugins.codesonar.services.HttpService;
import org.jenkinsci.plugins.codesonar.services.HttpServiceResponse;

public class HubInfoService
extends AbstractService {
    private static final Logger LOGGER = Logger.getLogger(HubInfoService.class.getName());
    public static final String CODESONAR_HUB_CLIENT_NAME = "jenkins";
    public static final int CODESONAR_HUB_CLIENT_PROTOCOL_VERSION_NUMBER = 2;
    private HttpService httpService;

    public HubInfoService(HttpService httpService) {
        this.httpService = httpService;
    }

    private CodeSonarPluginException createError(String msg, Object ... args) {
        return new CodeSonarPluginException(msg, args);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public CodeSonarHubInfo fetchHubInfo(URI baseHubUri) throws CodeSonarPluginException {
        LOGGER.log(Level.INFO, String.format("Retrieving CodeSonar hub info", new Object[0]));
        CodeSonarHubInfo hubInfo = new CodeSonarHubInfo();
        CodeSonarHubClientCompatibilityInfo cci = this.fetchVersionCompatibilityInfo(baseHubUri, CODESONAR_HUB_CLIENT_NAME, 2);
        if (cci != null) {
            hubInfo.setVersion(cci.getHubVersion());
            if (!this.checkClientOk(cci)) throw this.createError("client rejected by the hub. %nclientOK={0}", cci.getClientOK().toString());
            hubInfo.setOpenAPISupported(this.supportsOpenAPI(cci));
            hubInfo.setStrictQueryParametersEnforced(this.supportsStrictQueryParameters(cci));
            hubInfo.setJsonGridConfigSupported(this.supportsJsonGridConfig(cci));
            hubInfo.setUserSessionPoolingSupported(this.supportsUserSessionPooling(cci));
            return hubInfo;
        } else {
            LOGGER.log(Level.INFO, String.format("Hub did not provide client compatibility information. Attempting to query hub version signature.", new Object[0]));
            String hubSignatureVersion = this.fetchHubSignatureVersionString(baseHubUri);
            hubInfo.setVersion(hubSignatureVersion);
        }
        return hubInfo;
    }

    private CodeSonarHubClientCompatibilityInfo fetchVersionCompatibilityInfo(URI baseHubUri, String clientName, int clientVersion) throws CodeSonarPluginException {
        HttpServiceResponse response;
        URI resolvedURI = baseHubUri;
        resolvedURI = baseHubUri.resolve(String.format("/command/check_version/%s/?version=%d&capability=openapi&capability=strictQueryParameters&capability=gridConfigJson&capability=userSessionPool", clientName, clientVersion));
        LOGGER.log(Level.INFO, "Calling " + resolvedURI.toString());
        try {
            response = this.httpService.execute(Request.Get((URI)resolvedURI));
        }
        catch (IOException e) {
            LOGGER.log(Level.WARNING, "failed to get a response. %nIOException: {0}%nStack Trace: {1}", new Object[]{e.getMessage(), Throwables.getStackTraceAsString((Throwable)e)});
            return null;
        }
        if (response.getStatusCode() == 404) {
            LOGGER.log(Level.INFO, "specified endpoint seems not to exist on the hub. %nresponse is \"{0,number,integer}, {1}\"", new Object[]{response.getStatusCode(), response.getReasonPhrase()});
            return null;
        }
        if (response.getStatusCode() != 200) {
            throw new CodeSonarHubCommunicationException(resolvedURI, response.getStatusCode(), response.getReasonPhrase(), this.readResponseContent(response, resolvedURI));
        }
        String responseBody = this.readResponseContent(response, resolvedURI);
        if (responseBody == null) {
            return null;
        }
        if (StringUtils.isEmpty((String)responseBody)) {
            LOGGER.log(Level.INFO, "response is empty. %nresponse is \"{0}\"", responseBody);
            return null;
        }
        Gson gson = new Gson();
        CodeSonarHubClientCompatibilityInfo cci = null;
        try {
            cci = (CodeSonarHubClientCompatibilityInfo)gson.fromJson(responseBody, CodeSonarHubClientCompatibilityInfo.class);
            LOGGER.log(Level.INFO, CodeSonarLogger.formatMessage(cci.toString(), new Object[0]));
        }
        catch (JsonSyntaxException e) {
            throw new CodeSonarJsonSyntaxException((Exception)((Object)e));
        }
        return cci;
    }

    private boolean supportsOpenAPI(CodeSonarHubClientCompatibilityInfo cci) {
        return cci.getCapabilities() != null && cci.getCapabilities().getOpenapi() != null && cci.getCapabilities().getOpenapi() != false;
    }

    private boolean supportsStrictQueryParameters(CodeSonarHubClientCompatibilityInfo cci) {
        return cci.getCapabilities() != null && cci.getCapabilities().getStrictQueryParameters() != null && cci.getCapabilities().getStrictQueryParameters() != false;
    }

    private boolean supportsJsonGridConfig(CodeSonarHubClientCompatibilityInfo cci) {
        return cci.getCapabilities() != null && cci.getCapabilities().getGridConfigJson() != null && cci.getCapabilities().getGridConfigJson() != false;
    }

    private boolean supportsUserSessionPooling(CodeSonarHubClientCompatibilityInfo cci) {
        return cci.getCapabilities() != null && cci.getCapabilities().getUserSessionPool() != null && cci.getCapabilities().getUserSessionPool() != false;
    }

    private boolean checkClientOk(CodeSonarHubClientCompatibilityInfo cci) {
        return cci.getClientOK() == null || cci.getClientOK() != false;
    }

    private String fetchHubSignatureVersionString(URI baseHubUri) throws CodeSonarPluginException {
        HttpServiceResponse response;
        URI endpoint = baseHubUri.resolve("/command/anon_info/");
        LOGGER.log(Level.INFO, "Calling " + endpoint.toString());
        String bodyContent = null;
        try {
            response = this.httpService.getResponseFromUrl(endpoint);
            bodyContent = this.readResponseContent(response, endpoint);
            if (response.getStatusCode() != 200) {
                throw new CodeSonarHubCommunicationException(endpoint, response.getStatusCode(), response.getReasonPhrase(), bodyContent);
            }
        }
        catch (CodeSonarPluginException e) {
            return "4.0";
        }
        Pattern pattern = Pattern.compile("Version:\\s(\\d+\\.\\d+)");
        Matcher matcher = pattern.matcher(bodyContent);
        if (matcher.find()) {
            String version = matcher.group(1);
            if (StringUtils.isBlank((String)version)) {
                throw this.createError(CodeSonarLogger.formatMessage("Hub version cannot be parsed", new Object[0]), new Object[0]);
            }
            return version;
        }
        LOGGER.log(Level.WARNING, "Version info could not be determined by data:\n" + String.valueOf(response));
        throw this.createError(CodeSonarLogger.formatMessage("Hub version could not be determined", new Object[0]), new Object[0]);
    }
}

