/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.codesonar.services;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;

public class HttpServiceResponse
implements Closeable {
    private int statusCode;
    private String reasonPhrase;
    private InputStream contentInputStream;

    public HttpServiceResponse(int statusCode, String reasonPhrase, InputStream contentInputStream) {
        this.statusCode = statusCode;
        this.reasonPhrase = reasonPhrase;
        this.contentInputStream = contentInputStream;
    }

    @Override
    public void close() throws IOException {
        if (this.contentInputStream != null) {
            this.contentInputStream.close();
        }
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public String getReasonPhrase() {
        return this.reasonPhrase;
    }

    public InputStream getContentInputStream() {
        return this.contentInputStream;
    }

    public String readContent() throws IOException {
        if (this.contentInputStream == null) {
            return null;
        }
        StringBuilder content = new StringBuilder();
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(this.contentInputStream, StandardCharsets.UTF_8));){
            int c = 0;
            while ((c = ((Reader)reader).read()) != -1) {
                content.append((char)c);
            }
        }
        return content.toString();
    }
}

