/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.codesonar.services;

import hudson.util.Secret;
import java.io.IOException;
import java.net.URI;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.util.Collection;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.SSLContext;
import org.apache.http.HttpResponse;
import org.apache.http.client.CookieStore;
import org.apache.http.client.HttpClient;
import org.apache.http.client.fluent.Executor;
import org.apache.http.client.fluent.Request;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.impl.client.BasicCookieStore;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.ssl.SSLContextBuilder;
import org.apache.http.ssl.TrustStrategy;
import org.jenkinsci.plugins.codesonar.CodeSonarPluginException;
import org.jenkinsci.plugins.codesonar.models.CodeSonarHubInfo;
import org.jenkinsci.plugins.codesonar.services.CertificateFileTrustStrategy;
import org.jenkinsci.plugins.codesonar.services.HttpServiceRequest;
import org.jenkinsci.plugins.codesonar.services.HttpServiceResponse;

public class HttpService {
    private static final Logger LOGGER = Logger.getLogger(HttpService.class.getName());
    private CookieStore httpCookieStore;
    private Executor executor;
    private int socketTimeoutMS = -1;
    private CodeSonarHubInfo hubInfo = null;

    public HttpService(Collection<? extends Certificate> serverCertificates, KeyStore clientCertificateKeyStore, Secret clientCertificatePassword, int socketTimeoutMS) throws CodeSonarPluginException {
        LOGGER.log(Level.INFO, "Initializing HttpService");
        this.socketTimeoutMS = socketTimeoutMS;
        this.httpCookieStore = new BasicCookieStore();
        HttpClientBuilder httpClientBuilder = HttpClients.custom();
        if (serverCertificates != null || clientCertificateKeyStore != null && clientCertificatePassword != null) {
            LOGGER.log(Level.INFO, "Initializing SSL context");
            SSLContextBuilder sslContextBuilder = SSLContextBuilder.create();
            if (serverCertificates != null) {
                LOGGER.log(Level.INFO, "Adding server certificates to the SSL context");
                LOGGER.log(Level.INFO, "Server certificates list size {0}", serverCertificates.size());
                try {
                    sslContextBuilder.loadTrustMaterial((TrustStrategy)new CertificateFileTrustStrategy(serverCertificates));
                }
                catch (KeyStoreException | NoSuchAlgorithmException e) {
                    throw this.createError("Error setting up server certificates", e);
                }
            }
            if (clientCertificateKeyStore != null && clientCertificatePassword != null) {
                LOGGER.log(Level.INFO, "Adding client certificate to the SSL context");
                try {
                    sslContextBuilder.loadKeyMaterial(clientCertificateKeyStore, clientCertificatePassword.getPlainText().toCharArray());
                }
                catch (KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException e) {
                    throw this.createError("Error setting up client certificate.", e);
                }
            }
            try {
                SSLContext sslContext = sslContextBuilder.build();
                SSLConnectionSocketFactory csf = new SSLConnectionSocketFactory(sslContext);
                httpClientBuilder.setSSLSocketFactory((LayeredConnectionSocketFactory)csf);
                LOGGER.log(Level.INFO, "SSL context initialized");
            }
            catch (KeyManagementException | NoSuchAlgorithmException e) {
                throw this.createError("Error initiating SSL context.", e);
            }
        }
        CloseableHttpClient httpClient = httpClientBuilder.evictExpiredConnections().build();
        this.executor = Executor.newInstance((HttpClient)httpClient).use(this.httpCookieStore);
        LOGGER.log(Level.INFO, "HttpService initialized");
    }

    private CodeSonarPluginException createError(String msg, Throwable cause, Object ... args) {
        return new CodeSonarPluginException(msg, cause, args);
    }

    private CodeSonarPluginException createError(String msg, Object ... args) {
        return new CodeSonarPluginException(msg, args);
    }

    private CodeSonarPluginException createError(String msg, Throwable cause) {
        return new CodeSonarPluginException(msg, cause, new Object[0]);
    }

    public void setSocketTimeoutMS(int socketTimeoutMS) {
        LOGGER.log(Level.FINE, "HttpService - setSocketTimeoutMS to {0}", socketTimeoutMS);
        this.socketTimeoutMS = socketTimeoutMS;
    }

    public CodeSonarHubInfo getHubInfo() {
        return this.hubInfo;
    }

    public void setHubInfo(CodeSonarHubInfo hubInfo) {
        this.hubInfo = hubInfo;
    }

    public HttpServiceResponse getResponseFromUrl(URI uri) throws CodeSonarPluginException {
        HttpServiceRequest request = new HttpServiceRequest(uri);
        return this.getResponse(request);
    }

    public HttpServiceResponse getResponseFromUrl(String url) throws CodeSonarPluginException {
        HttpServiceRequest request = new HttpServiceRequest(url);
        return this.getResponse(request);
    }

    public HttpServiceResponse getResponse(HttpServiceRequest request) throws CodeSonarPluginException {
        boolean openAPISupported;
        Object url = request.getURIString();
        CodeSonarHubInfo hubInfo = this.getHubInfo();
        boolean bl = openAPISupported = hubInfo == null ? false : hubInfo.isOpenAPISupported();
        if (!openAPISupported && !((String)url).contains("response_try_plaintext")) {
            url = ((String)url).contains("?") ? (String)url + "&response_try_plaintext=1" : (String)url + "?response_try_plaintext=1";
        }
        String httpMethod = request.getHTTPMethod();
        Request req = null;
        if (httpMethod == null || httpMethod.equals("")) {
            httpMethod = "GET";
        }
        if (httpMethod.equals("GET")) {
            req = Request.Get((String)url);
        } else if (httpMethod.equals("DELETE")) {
            req = Request.Delete((String)url);
        } else if (httpMethod.equals("POST")) {
            req = Request.Post((String)url);
        } else if (httpMethod.equals("PUT")) {
            req = Request.Put((String)url);
        } else if (httpMethod.equals("PATCH")) {
            req = Request.Patch((String)url);
        } else if (httpMethod.equals("HEAD")) {
            req = Request.Head((String)url);
        } else if (httpMethod.equals("OPTIONS")) {
            req = Request.Options((String)url);
        } else {
            throw this.createError("Unrecognized HTTP method verb in: {0} {1}", httpMethod, url);
        }
        LOGGER.log(Level.INFO, "HTTP {0} {1}", new String[]{httpMethod, url});
        if (this.socketTimeoutMS >= 0) {
            req.socketTimeout(this.socketTimeoutMS);
        }
        for (Map.Entry<String, String> header : request.getHeaderCollection()) {
            req.addHeader(header.getKey(), header.getValue());
        }
        HttpServiceResponse serviceResponse = null;
        try {
            HttpResponse resp = this.getExecutor().execute(req).returnResponse();
            serviceResponse = new HttpServiceResponse(resp.getStatusLine().getStatusCode(), resp.getStatusLine().getReasonPhrase(), resp.getEntity().getContent());
        }
        catch (IOException e) {
            throw this.createError("Error requesting URL: {0}", e, url);
        }
        return serviceResponse;
    }

    public HttpServiceResponse execute(Request request) throws IOException {
        if (this.socketTimeoutMS >= 0) {
            request.socketTimeout(this.socketTimeoutMS);
        }
        HttpResponse resp = this.getExecutor().execute(request).returnResponse();
        return new HttpServiceResponse(resp.getStatusLine().getStatusCode(), resp.getStatusLine().getReasonPhrase(), resp.getEntity().getContent());
    }

    public Executor getExecutor() {
        return this.executor;
    }
}

