/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.codesonar.services;

import java.util.logging.Logger;
import org.jenkinsci.plugins.codesonar.AnalysisServiceFactory;
import org.jenkinsci.plugins.codesonar.CodeSonarPluginException;
import org.jenkinsci.plugins.codesonar.models.CodeSonarHubInfo;
import org.jenkinsci.plugins.codesonar.services.AlertsService;
import org.jenkinsci.plugins.codesonar.services.HttpService;
import org.jenkinsci.plugins.codesonar.services.IAnalysisService;
import org.jenkinsci.plugins.codesonar.services.MetricsService;
import org.jenkinsci.plugins.codesonar.services.ProceduresService;
import org.jenkinsci.plugins.codesonar.services.WarningsService;
import org.jenkinsci.plugins.codesonar.services.XmlSerializationService;

public class CodeSonarServices {
    private static final Logger LOGGER = Logger.getLogger(CodeSonarServices.class.getName());
    private HttpService httpService;
    private CodeSonarHubInfo hubInfo;
    private XmlSerializationService xmlSerializationService;
    private AnalysisServiceFactory analysisServiceFactory;
    private IAnalysisService analysisService;
    private MetricsService metricsService;
    private ProceduresService proceduresService;
    private AlertsService alertsService;
    private WarningsService warningsService;

    public CodeSonarServices(HttpService httpService, CodeSonarHubInfo hubInfo) {
        this.httpService = httpService;
        this.hubInfo = hubInfo;
    }

    private XmlSerializationService getXmlSerializationService() {
        if (this.xmlSerializationService == null) {
            this.xmlSerializationService = new XmlSerializationService();
        }
        return this.xmlSerializationService;
    }

    public AnalysisServiceFactory getAnalysisServiceFactory() {
        if (this.analysisServiceFactory == null) {
            this.analysisServiceFactory = new AnalysisServiceFactory();
            this.analysisServiceFactory.setHubInfo(this.hubInfo);
        }
        return this.analysisServiceFactory;
    }

    public IAnalysisService getAnalysisService() throws CodeSonarPluginException {
        if (this.analysisService == null) {
            this.analysisService = this.getAnalysisServiceFactory().getAnalysisService(this.httpService, this.getXmlSerializationService());
        }
        return this.analysisService;
    }

    public MetricsService getMetricsService() throws CodeSonarPluginException {
        if (this.metricsService == null) {
            this.metricsService = new MetricsService(this.httpService, this.getXmlSerializationService());
        }
        return this.metricsService;
    }

    public ProceduresService getProceduresService() throws CodeSonarPluginException {
        if (this.proceduresService == null) {
            this.proceduresService = new ProceduresService(this.httpService, this.getXmlSerializationService(), this.hubInfo.isStrictQueryParametersEnforced());
        }
        return this.proceduresService;
    }

    public AlertsService getAlertsService() throws CodeSonarPluginException {
        if (this.alertsService == null) {
            this.alertsService = new AlertsService(this.httpService);
        }
        return this.alertsService;
    }

    public WarningsService getWarningsService() throws CodeSonarPluginException {
        if (this.warningsService == null) {
            this.warningsService = new WarningsService(this.httpService, this.hubInfo.isStrictQueryParametersEnforced());
        }
        return this.warningsService;
    }
}

