/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.codesonar.services;

import java.net.URI;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jenkinsci.plugins.codesonar.CodeSonarPluginException;
import org.jenkinsci.plugins.codesonar.models.CodeSonarAlertLevels;
import org.jenkinsci.plugins.codesonar.models.CodeSonarHubInfo;
import org.jenkinsci.plugins.codesonar.models.Metric;
import org.jenkinsci.plugins.codesonar.models.analysis.Analysis;
import org.jenkinsci.plugins.codesonar.models.analysis.Warning;
import org.jenkinsci.plugins.codesonar.models.json.CodeSonarWarningCountChartRow;
import org.jenkinsci.plugins.codesonar.models.json.ProcedureJsonRow;
import org.jenkinsci.plugins.codesonar.models.metrics.Metrics;
import org.jenkinsci.plugins.codesonar.models.procedures.ProcedureRow;
import org.jenkinsci.plugins.codesonar.models.procedures.Procedures;
import org.jenkinsci.plugins.codesonar.services.CodeSonarAlertCounter;
import org.jenkinsci.plugins.codesonar.services.CodeSonarServices;
import org.jenkinsci.plugins.codesonar.services.HttpService;

public class CodeSonarHubAnalysisDataLoader {
    private static final Logger LOGGER = Logger.getLogger(CodeSonarHubAnalysisDataLoader.class.getName());
    protected CodeSonarServices services;
    protected CodeSonarHubInfo hubInfo;
    private URI baseHubUri;
    private Long analysisId;
    private String visibilityFilter;
    private String newWarningsVisibilityFilter;
    private CodeSonarWarningCountChartRow activeWarningsForAnalysis;
    private CodeSonarWarningCountChartRow newWarningsForAnalysis;
    private Analysis analysisViewActive;
    private Analysis analysisViewNew;
    private Metrics metrics;
    private Procedures procedures;
    private ProcedureJsonRow maxCyclomaticComplexityProcedure;
    private CodeSonarAlertCounter alertCounter;
    private Map<Integer, Long> numberOfWarningsAboveThreshold = new HashMap<Integer, Long>();

    public CodeSonarHubAnalysisDataLoader(HttpService httpService, CodeSonarHubInfo hubInfo, URI baseHubUri, Long analysisId, String visibilityFilter, String newWarningsVisibilityFilter) {
        this.services = new CodeSonarServices(httpService, hubInfo);
        this.hubInfo = hubInfo;
        this.baseHubUri = baseHubUri;
        this.analysisId = analysisId;
        this.visibilityFilter = visibilityFilter;
        this.newWarningsVisibilityFilter = newWarningsVisibilityFilter;
    }

    public URI getBaseHubUri() {
        return this.baseHubUri;
    }

    protected Long getAnalysisId() {
        return this.analysisId;
    }

    protected String getVisibilityFilter() {
        return this.visibilityFilter;
    }

    protected String getNewWarningsVisibilityFilter() {
        return this.newWarningsVisibilityFilter;
    }

    protected Analysis getLegacyAnalysisViewActive() throws CodeSonarPluginException {
        LOGGER.log(Level.INFO, "AnalysisViewActive not already set, loading from corresponding legacy service");
        this.services.getAnalysisService().setVisibilityFilter(this.visibilityFilter);
        return this.services.getAnalysisService().getAnalysisFromUrlWarningsByFilter(this.getBaseHubUri(), this.getAnalysisId());
    }

    protected Analysis getLegacyAnalysisViewNew() throws CodeSonarPluginException {
        LOGGER.log(Level.INFO, "AnalysisViewNew not already set, loading from corresponding legacy service");
        this.services.getAnalysisService().setVisibilityFilter(this.newWarningsVisibilityFilter);
        return this.services.getAnalysisService().getAnalysisFromUrlWithNewWarnings(this.getBaseHubUri(), this.getAnalysisId());
    }

    protected Procedures getLegacyProcedures() throws CodeSonarPluginException {
        LOGGER.log(Level.INFO, "Procedures not already set, loading from corresponding legacy service");
        URI proceduresUri = this.services.getProceduresService().getProceduresUriFromAnAnalysisId(this.baseHubUri, String.valueOf(this.analysisId));
        return this.services.getProceduresService().getProceduresFromUri(proceduresUri);
    }

    protected Metrics getLegacyMetrics() throws CodeSonarPluginException {
        LOGGER.log(Level.INFO, "Metrics not already set, loading from corresponding legacy service");
        URI metricsUri = this.services.getMetricsService().getMetricsUriFromAnAnalysisId(this.getBaseHubUri(), String.valueOf(this.analysisId));
        return this.services.getMetricsService().getMetricsFromUri(metricsUri);
    }

    public long getNumberOfActiveWarnings() throws CodeSonarPluginException {
        LOGGER.log(Level.INFO, "getNumberOfActiveWarnings");
        if (this.hubInfo.isJsonGridConfigSupported()) {
            if (this.activeWarningsForAnalysis == null) {
                LOGGER.log(Level.INFO, "ActiveWarningsCount not already set, loading from corresponding service");
                this.activeWarningsForAnalysis = this.services.getAnalysisService().getNumberOfWarnings(this.getBaseHubUri(), this.getAnalysisId(), this.getVisibilityFilter());
                LOGGER.log(Level.INFO, "ActiveWarningsCount new instance {0}", this.activeWarningsForAnalysis);
            }
            return this.activeWarningsForAnalysis.getNumberOfWarnings();
        }
        if (this.analysisViewActive == null) {
            this.analysisViewActive = this.getLegacyAnalysisViewActive();
            LOGGER.log(Level.INFO, "Legacy AnalysisViewActive new instance {0}", this.analysisViewActive);
        }
        return this.analysisViewActive.getWarnings().size();
    }

    public long getNumberOfNewWarnings() throws CodeSonarPluginException {
        LOGGER.log(Level.INFO, "getNumberOfNewWarnings");
        if (this.hubInfo.isJsonGridConfigSupported()) {
            if (this.newWarningsForAnalysis == null) {
                LOGGER.log(Level.INFO, "NewWarningsCount not already set, loading from corresponding service");
                this.newWarningsForAnalysis = this.services.getAnalysisService().getNumberOfWarnings(this.getBaseHubUri(), this.getAnalysisId(), this.getNewWarningsVisibilityFilter());
                LOGGER.log(Level.INFO, "NewWarningsCount new instance {0}", this.newWarningsForAnalysis);
            }
            return this.newWarningsForAnalysis.getNumberOfWarnings();
        }
        if (this.analysisViewNew == null) {
            this.analysisViewNew = this.getLegacyAnalysisViewNew();
            LOGGER.log(Level.INFO, "Legacy AnalysisViewNew new instance {0}", this.analysisViewNew);
        }
        return this.analysisViewNew.getWarnings().size();
    }

    public ProcedureJsonRow getProcedureWithMaxCyclomaticComplexity() throws CodeSonarPluginException {
        LOGGER.log(Level.INFO, "getProcedureWithMaxCyclomaticComplexity");
        if (this.hubInfo.isJsonGridConfigSupported()) {
            if (this.maxCyclomaticComplexityProcedure == null) {
                LOGGER.log(Level.INFO, "MaxCyclomaticComplexityProcedure not already set, loading from corresponding service");
                this.maxCyclomaticComplexityProcedure = this.services.getProceduresService().getProcedureWithMaxCyclomaticComplexity(this.getBaseHubUri(), this.getAnalysisId());
            }
            LOGGER.log(Level.INFO, "MaxCyclomaticComplexityProcedure new instance {0}", this.maxCyclomaticComplexityProcedure);
            return this.maxCyclomaticComplexityProcedure;
        }
        if (this.procedures == null) {
            this.procedures = this.getLegacyProcedures();
            LOGGER.log(Level.INFO, "Legacy Procedures new instance {0}", this.procedures);
            if (this.procedures == null) {
                throw new CodeSonarPluginException("Procedures list is null", new Object[0]);
            }
        }
        List<ProcedureRow> procedureRows = this.procedures.getProcedureRows();
        String procedure = null;
        int maxCC = 0;
        for (ProcedureRow procedureRow : procedureRows) {
            Metric cyclomaticComplexityMetric = procedureRow.getMetricByName("Cyclomatic Complexity");
            int value = Integer.parseInt(cyclomaticComplexityMetric.getValue());
            if (value <= maxCC) continue;
            maxCC = value;
            procedure = procedureRow.getProcedure();
        }
        if (procedure != null) {
            return new ProcedureJsonRow(procedure, maxCC);
        }
        throw new CodeSonarPluginException("Procedure row can not ben found", new Object[0]);
    }

    public int getNumberOfAlerts(CodeSonarAlertLevels level) throws CodeSonarPluginException {
        LOGGER.log(Level.INFO, "getNumberOfAlerts");
        if (this.hubInfo.isJsonGridConfigSupported()) {
            if (this.alertCounter == null) {
                LOGGER.log(Level.INFO, "AlertCounter not already set, loading from corresponding service");
                this.alertCounter = this.services.getAlertsService().getAlertCounter(this.getBaseHubUri(), this.getAnalysisId());
                LOGGER.log(Level.INFO, "AlertCounter new instance {0}", this.alertCounter);
            }
            return this.alertCounter.getAlertCount(level);
        }
        if (this.analysisViewActive == null) {
            LOGGER.log(Level.INFO, "AnalysisViewActive not already set, loading from corresponding service");
            this.analysisViewActive = this.getLegacyAnalysisViewActive();
            LOGGER.log(Level.INFO, "AnalysisViewActive new instance {0}", this.analysisViewActive);
        }
        return this.analysisViewActive.getRedAlerts().size();
    }

    public long getNumberOfWarningsWithScoreAboveThreshold(int threshold) throws CodeSonarPluginException {
        LOGGER.log(Level.INFO, "getNumberOfWarningsWithScoreAboveThreshold");
        if (this.hubInfo.isJsonGridConfigSupported()) {
            if (this.numberOfWarningsAboveThreshold.get(threshold) == null) {
                LOGGER.log(Level.INFO, "NumberOfWarningsAboveThreshold not already set for threshold {0}, loading from corresponding service", threshold);
                long numberOfWarnings = this.services.getWarningsService().getNumberOfWarningsWithScoreAboveThreshold(this.getBaseHubUri(), this.getAnalysisId(), threshold, this.visibilityFilter);
                this.numberOfWarningsAboveThreshold.put(threshold, numberOfWarnings);
                LOGGER.log(Level.INFO, "NumberOfWarningsAboveThreshold new value {0}", numberOfWarnings);
            }
            return this.numberOfWarningsAboveThreshold.get(threshold);
        }
        if (this.analysisViewActive == null) {
            LOGGER.log(Level.INFO, "AnalysisViewActive not already set, loading from corresponding service");
            this.analysisViewActive = this.getLegacyAnalysisViewActive();
            LOGGER.log(Level.INFO, "AnalysisViewActive new instance {0}", this.analysisViewActive);
        }
        long severeWarnings = 0L;
        List<Warning> warnings = this.analysisViewActive.getWarnings();
        for (Warning warning : warnings) {
            if (warning.getScore() < threshold) continue;
            ++severeWarnings;
        }
        return severeWarnings;
    }
}

