/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.codesonar.services;

import java.io.IOException;
import java.net.URI;
import java.nio.charset.Charset;
import java.util.Base64;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.http.NameValuePair;
import org.apache.http.client.fluent.Form;
import org.apache.http.client.fluent.Request;
import org.jenkinsci.plugins.codesonar.CodeSonarHubCommunicationException;
import org.jenkinsci.plugins.codesonar.CodeSonarPluginException;
import org.jenkinsci.plugins.codesonar.models.CodeSonarHubInfo;
import org.jenkinsci.plugins.codesonar.services.AbstractService;
import org.jenkinsci.plugins.codesonar.services.HttpService;
import org.jenkinsci.plugins.codesonar.services.HttpServiceRequest;
import org.jenkinsci.plugins.codesonar.services.HttpServiceResponse;

public class AuthenticationService
extends AbstractService {
    private static final Logger LOGGER = Logger.getLogger(AuthenticationService.class.getName());
    private static final String HTTP_HEADER_AUTHORIZATION = "Authorization";
    private static final String USER_SESSION_POOL_NAME = "jenkins+codesonar";
    private final HttpService httpService;

    public AuthenticationService(HttpService httpService) {
        this.httpService = httpService;
    }

    private CodeSonarPluginException createError(String msg, Object ... args) {
        return new CodeSonarPluginException(msg, args);
    }

    private CodeSonarPluginException createError(String msg, Throwable cause, Object ... args) {
        return new CodeSonarPluginException(msg, cause, args);
    }

    private CodeSonarHubInfo getHubInfo() {
        return this.httpService.getHubInfo();
    }

    public void authenticate(URI baseHubUri) throws CodeSonarPluginException {
        LOGGER.log(Level.INFO, "Starting new certificate authentication request");
        CodeSonarHubInfo hubInfo = this.getHubInfo();
        if (hubInfo != null && hubInfo.isOpenAPISupported()) {
            this.authenticate702(baseHubUri, hubInfo);
        } else {
            this.authenticate701(baseHubUri);
        }
    }

    private void authenticate702(URI baseHubUri, CodeSonarHubInfo hubInfo) throws CodeSonarPluginException {
        LOGGER.log(Level.INFO, "OpenAPI certificate authentication request");
        List<NameValuePair> loginForm = this.createLoginForm702(hubInfo);
        URI resolvedURI = baseHubUri;
        HttpServiceResponse response = null;
        try {
            resolvedURI = baseHubUri.resolve("/session/create-tls-client-certificate/");
            response = this.httpService.execute(Request.Post((URI)resolvedURI).addHeader("X-CSHUB-USE-TLS-CLIENT-AUTH", "1").bodyForm(loginForm));
        }
        catch (IOException e) {
            throw this.createError("failed to authenticate.", e, new Object[0]);
        }
        if (response.getStatusCode() == 301 && baseHubUri.getScheme().equalsIgnoreCase("http")) {
            throw this.createError("failed to authenticate. Possible reason could be the CodeSonar hub running on https, while protocol http was specified.%nHTTP status code: {0} - {1} %nHTTP Body: {2}", response.getStatusCode(), response.getReasonPhrase(), this.readResponseContent(response, resolvedURI));
        }
        if (response.getStatusCode() != 200) {
            throw new CodeSonarHubCommunicationException(resolvedURI, response.getStatusCode(), response.getReasonPhrase(), this.readResponseContent(response, resolvedURI));
        }
    }

    private void authenticate701(URI baseHubUri) throws CodeSonarPluginException {
        LOGGER.log(Level.INFO, "Legacy certificate authentication request");
        List loginForm = Form.form().add("sif_use_tls", "yes").add("sif_sign_in", "yes").add("sif_log_out_competitor", "yes").add("response_try_plaintext", "1").build();
        int status = -1;
        String reason = "";
        String body = "";
        URI resolvedURI = baseHubUri;
        HttpServiceResponse response = null;
        try {
            resolvedURI = baseHubUri.resolve("/sign_in.html?response_try_plaintext=1");
            response = this.httpService.execute(Request.Post((URI)resolvedURI).bodyForm((Iterable)loginForm));
        }
        catch (IOException e) {
            throw this.createError("failed to authenticate.", e, new Object[0]);
        }
        if (response.getStatusCode() == 301 && baseHubUri.getScheme().equalsIgnoreCase("http")) {
            throw this.createError("failed to authenticate. Possible reason could be the CodeSonar hub running on https, while protocol http was specified.%nHTTP status code: {0} - {1} %nHTTP Body: {2}", response.getStatusCode(), response.getReasonPhrase(), this.readResponseContent(response, resolvedURI));
        }
        if (response.getStatusCode() != 200) {
            throw new CodeSonarHubCommunicationException(resolvedURI, response.getStatusCode(), response.getReasonPhrase(), this.readResponseContent(response, resolvedURI));
        }
    }

    public void authenticate(URI baseHubUri, String username, String password) throws CodeSonarPluginException {
        LOGGER.log(Level.INFO, "Starting new password authentication request");
        CodeSonarHubInfo hubInfo = this.getHubInfo();
        if (hubInfo != null && hubInfo.isOpenAPISupported()) {
            this.authenticate702(baseHubUri, hubInfo, username, password);
        } else {
            this.authenticate701(baseHubUri, username, password);
        }
    }

    private void authenticate702(URI baseHubUri, CodeSonarHubInfo hubInfo, String username, String password) throws CodeSonarPluginException {
        LOGGER.log(Level.INFO, "OpenAPI password authentication request");
        List<NameValuePair> loginForm = this.createLoginForm702(hubInfo);
        URI resolvedURI = baseHubUri;
        HttpServiceResponse response = null;
        try {
            resolvedURI = baseHubUri.resolve("/session/create-basic-auth/");
            response = this.httpService.execute(Request.Post((URI)resolvedURI).addHeader(HTTP_HEADER_AUTHORIZATION, AuthenticationService.formatBasicAuthHeader(username, password)).bodyForm(loginForm));
        }
        catch (IOException e) {
            throw this.createError("failed to authenticate.", e, new Object[0]);
        }
        if (response.getStatusCode() == 301 && baseHubUri.getScheme().equalsIgnoreCase("http")) {
            throw this.createError("failed to authenticate. Possible reason could be the CodeSonar hub running on https, while protocol http was specified.%nHTTP status code: {0} - {1} %nHTTP Body: {2}", response.getStatusCode(), response.getReasonPhrase(), this.readResponseContent(response, resolvedURI));
        }
        if (response.getStatusCode() != 200) {
            throw new CodeSonarHubCommunicationException(resolvedURI, response.getStatusCode(), response.getReasonPhrase(), this.readResponseContent(response, resolvedURI));
        }
    }

    private void authenticate701(URI baseHubUri, String username, String password) throws CodeSonarPluginException {
        LOGGER.log(Level.INFO, "Legacy password authentication request");
        List loginForm = Form.form().add("sif_username", username).add("sif_password", password).add("sif_sign_in", "yes").add("sif_log_out_competitor", "yes").add("response_try_plaintext", "1").build();
        URI resolvedURI = baseHubUri;
        HttpServiceResponse response = null;
        try {
            resolvedURI = baseHubUri.resolve("/sign_in.html?response_try_plaintext=1");
            response = this.httpService.execute(Request.Post((URI)resolvedURI).bodyForm((Iterable)loginForm));
        }
        catch (IOException e) {
            throw this.createError("failed to authenticate.", e, new Object[0]);
        }
        if (response.getStatusCode() == 301 && baseHubUri.getScheme().equalsIgnoreCase("http")) {
            throw this.createError("failed to authenticate. Possible reason could be the CodeSonar hub running on https, while protocol http was specified.%nHTTP status code: {0} - {1} %nHTTP Body: {2}", response.getStatusCode(), response.getReasonPhrase(), this.readResponseContent(response, resolvedURI));
        }
        if (response.getStatusCode() != 200) {
            throw new CodeSonarHubCommunicationException(resolvedURI, response.getStatusCode(), response.getReasonPhrase(), this.readResponseContent(response, resolvedURI));
        }
    }

    private List<NameValuePair> createLoginForm702(CodeSonarHubInfo hubInfo) {
        Form formBuilder = Form.form();
        formBuilder.add("key", "cookie");
        if (hubInfo.isUserSessionPoolingSupported()) {
            LOGGER.log(Level.INFO, "Using hub user session pooling.");
            formBuilder.add("pool", USER_SESSION_POOL_NAME);
            formBuilder.add("keepalive", "true");
            formBuilder.add("overflow_ok", "false");
        }
        return formBuilder.build();
    }

    private static String formatBasicAuthHeader(String user, String password) {
        return "Basic " + Base64.getEncoder().encodeToString((user + ":" + password).getBytes(Charset.forName("UTF-8")));
    }

    public void signOut(URI baseHubUri) throws CodeSonarPluginException {
        CodeSonarHubInfo hubInfo = this.getHubInfo();
        try {
            HttpServiceRequest request;
            URI resolvedURI;
            if (hubInfo != null && hubInfo.isOpenAPISupported()) {
                resolvedURI = baseHubUri.resolve("/sign_out.html");
                request = new HttpServiceRequest(resolvedURI);
                request.addHeader("Accept", "text/plain");
            } else {
                resolvedURI = baseHubUri.resolve("/sign_out.html?response_try_plaintext=1");
                request = new HttpServiceRequest(resolvedURI);
            }
            HttpServiceResponse response = this.httpService.getResponse(request);
            if (response.getStatusCode() != 200) {
                throw new CodeSonarHubCommunicationException(resolvedURI, response.getStatusCode(), response.getReasonPhrase(), this.readResponseContent(response, resolvedURI));
            }
        }
        catch (IOException ex) {
            throw this.createError("Failed to sign out.", ex, new Object[0]);
        }
    }
}

