/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.codesonar.services;

import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.text.MessageFormat;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.http.client.utils.URIBuilder;
import org.jenkinsci.plugins.codesonar.CodeSonarJsonSyntaxException;
import org.jenkinsci.plugins.codesonar.CodeSonarPluginException;
import org.jenkinsci.plugins.codesonar.CodeSonarRequestURISyntaxException;
import org.jenkinsci.plugins.codesonar.models.json.CodeSonarAlertData;
import org.jenkinsci.plugins.codesonar.services.AbstractService;
import org.jenkinsci.plugins.codesonar.services.CodeSonarAlertCounter;
import org.jenkinsci.plugins.codesonar.services.HttpService;
import org.jenkinsci.plugins.codesonar.services.HttpServiceResponse;

public class AlertsService
extends AbstractService {
    private static final Logger LOGGER = Logger.getLogger(AlertsService.class.getName());
    private final HttpService httpService;

    public AlertsService(HttpService httpService) {
        this.httpService = httpService;
    }

    public CodeSonarAlertCounter getAlertCounter(URI baseHubUri, long analysisId) throws CodeSonarPluginException {
        CodeSonarAlertCounter counter = new CodeSonarAlertCounter();
        boolean foundExpectedResponse = false;
        int unexpectedErrorCounter = 0;
        for (long kind = 0L; kind < 50L; ++kind) {
            HttpServiceResponse response;
            block15: {
                URIBuilder uriBuilder = new URIBuilder(baseHubUri);
                uriBuilder.setPath(String.format("/analysis/%d-alert%d.json", analysisId, kind));
                URI requestUri = null;
                try {
                    requestUri = uriBuilder.build();
                }
                catch (URISyntaxException e) {
                    throw new CodeSonarRequestURISyntaxException(e);
                }
                String requestUriString = requestUri.toASCIIString();
                response = null;
                try {
                    response = this.httpService.getResponseFromUrl(requestUriString);
                    if (response.getStatusCode() == 200) {
                        foundExpectedResponse = true;
                        break block15;
                    }
                    if (response.getStatusCode() == 404) {
                        foundExpectedResponse = true;
                        continue;
                    }
                    if (response.getStatusCode() == 500) {
                        LOGGER.log(Level.INFO, MessageFormat.format("Stop looping through alert kinds at kind id {0}, URI: {1}, HTTP status code: {2} - {3}, HTTP Body: {4}", kind, requestUriString, response.getStatusCode(), response.getReasonPhrase(), this.readResponseContent(response, requestUriString)));
                        break;
                    }
                    ++unexpectedErrorCounter;
                    if (foundExpectedResponse) {
                        if (unexpectedErrorCounter > 2) {
                            throw new CodeSonarPluginException("Too many unexpected errors found communicating with CodeSonar Hub. %nURI: {0}%nHTTP status code: {1} - {2} %nHTTP Body: {3}", requestUriString, response.getStatusCode(), response.getReasonPhrase(), this.readResponseContent(response, requestUriString));
                        }
                        LOGGER.log(Level.INFO, MessageFormat.format("Found an unexpected error in the response, try skipping current alert kind {0}, URI: {1}, HTTP status code: {2} - {3}, HTTP Body: {4}", kind, requestUriString, response.getStatusCode(), response.getReasonPhrase(), this.readResponseContent(response, requestUriString)));
                        continue;
                    }
                    LOGGER.log(Level.INFO, "Unexpected error in the response without earlier expected ones, stop looping.");
                    throw new CodeSonarPluginException("Unexpected error in the response without earlier expected ones communicating with CodeSonar Hub. %nURI: {0}%nHTTP status code: {1} - {2} %nHTTP Body: {3}", requestUriString, response.getStatusCode(), response.getReasonPhrase(), this.readResponseContent(response, requestUriString));
                }
                catch (CodeSonarPluginException e) {
                    if (++unexpectedErrorCounter > 2) {
                        throw new CodeSonarPluginException("Too many exeptions communicating with CodeSonar Hub. %nURI: {0}", (Throwable)e, requestUriString);
                    }
                    LOGGER.log(Level.INFO, MessageFormat.format("Exception querying the hub, skipping current alert kind {0}", kind), e);
                    continue;
                }
            }
            Gson gsonDeserializer = new Gson();
            CodeSonarAlertData alertData = null;
            try {
                alertData = (CodeSonarAlertData)gsonDeserializer.fromJson((Reader)new InputStreamReader(response.getContentInputStream(), StandardCharsets.UTF_8), CodeSonarAlertData.class);
                LOGGER.log(Level.INFO, "response alertData={0}", alertData.toString());
            }
            catch (JsonSyntaxException e) {
                throw new CodeSonarJsonSyntaxException((Exception)((Object)e));
            }
            if (alertData.getUndef_funcs() != null && alertData.getUndef_funcs().size() > 0) {
                LOGGER.log(Level.INFO, "Counting {0} new alerts from \"undef_funcs\" for color {1}", new Object[]{alertData.getUndef_funcs().size(), alertData.getColor()});
                counter.incrementOf(alertData.getColor(), alertData.getUndef_funcs().size());
            }
            if (alertData.getIssues() != null && alertData.getIssues().size() > 0) {
                LOGGER.log(Level.INFO, "Counting {0} new alerts from \"issues\" for color {1}", new Object[]{alertData.getIssues().size(), alertData.getColor()});
                counter.incrementOf(alertData.getColor(), alertData.getIssues().size());
            }
            if (alertData.getFacts() == null || alertData.getFacts().size() <= 0) continue;
            LOGGER.log(Level.INFO, "Counting {0} new alerts from \"facts\" for color {1}", new Object[]{alertData.getFacts().size(), alertData.getColor()});
            counter.incrementOf(alertData.getColor(), alertData.getFacts().size());
        }
        return counter;
    }
}

