/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.codesonar.models.projects;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.jenkinsci.plugins.codesonar.CodeSonarPluginException;
import org.jenkinsci.plugins.codesonar.models.ProjectTree;
import org.jenkinsci.plugins.codesonar.models.projects.Project;

@XmlRootElement(name="projects")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class Projects
implements Serializable {
    @XmlElement(name="projecttree")
    private List<ProjectTree> projectTrees;
    @XmlElement(name="project")
    private List<Project> projects;

    private CodeSonarPluginException createError(String msg, Object ... args) {
        return new CodeSonarPluginException(msg, args);
    }

    public Project getProjectByName(String projectName) throws CodeSonarPluginException {
        for (Project project : this.getProjects()) {
            if (!project.getName().equals(projectName)) continue;
            return project;
        }
        throw this.createError("Project by the name {0} was not found on the hub", projectName);
    }

    public List<ProjectTree> getProjectTrees() {
        if (this.projectTrees == null) {
            this.projectTrees = new ArrayList<ProjectTree>();
        }
        return this.projectTrees;
    }

    public void setProjectTrees(List<ProjectTree> projectTrees) {
        this.projectTrees = projectTrees;
    }

    public List<Project> getProjects() {
        if (this.projects == null) {
            this.projects = new ArrayList<Project>();
        }
        return this.projects;
    }

    public void setProjects(List<Project> projects) {
        this.projects = projects;
    }

    public String toString() {
        return "Projects{projectTrees=" + String.valueOf(this.getProjectTrees()) + ", projects=" + String.valueOf(this.getProjects()) + "}";
    }
}

