/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.codesonar.models.procedures;

import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.jenkinsci.plugins.codesonar.models.Metric;

@XmlRootElement(name="procedure_row")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class ProcedureRow
implements Serializable {
    private String file;
    private String procedure;
    @XmlElement(name="metric")
    private List<Metric> metrics;

    public Metric getMetricByName(String metricName) {
        if (this.metrics == null) {
            this.metrics = Collections.EMPTY_LIST;
        }
        for (Metric metric : this.metrics) {
            if (!metric.getName().equals(metricName)) continue;
            return metric;
        }
        return null;
    }

    public String getFile() {
        return this.file;
    }

    public void setFile(String file) {
        this.file = file;
    }

    public String getProcedure() {
        return this.procedure;
    }

    public void setProcedure(String procedure) {
        this.procedure = procedure;
    }

    public List<Metric> getMetrics() {
        return this.metrics;
    }

    public void setMetrics(List<Metric> metrics) {
        this.metrics = metrics;
    }

    public int hashCode() {
        int hash = 5;
        hash = 23 * hash + Objects.hashCode(this.file);
        hash = 23 * hash + Objects.hashCode(this.procedure);
        hash = 23 * hash + Objects.hashCode(this.metrics);
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ProcedureRow other = (ProcedureRow)obj;
        if (!Objects.equals(this.file, other.file)) {
            return false;
        }
        if (!Objects.equals(this.procedure, other.procedure)) {
            return false;
        }
        return Objects.equals(this.metrics, other.metrics);
    }

    public String toString() {
        return "ProcedureRow{file=" + this.file + ", procedure=" + this.procedure + ", metrics=" + String.valueOf(this.metrics) + "}";
    }
}

