/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.codesonar.models.metrics;

import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.jenkinsci.plugins.codesonar.CodeSonarPluginException;
import org.jenkinsci.plugins.codesonar.models.metrics.Metric;

@XmlRootElement(name="metrics")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class Metrics
implements Serializable {
    @XmlElement(name="metric")
    private List<Metric> metrics;

    private CodeSonarPluginException createError(String msg, Object ... args) {
        return new CodeSonarPluginException(msg, args);
    }

    public Metric getMetricByName(String name) throws CodeSonarPluginException {
        if (this.metrics == null) {
            this.metrics = Collections.EMPTY_LIST;
        }
        for (Metric metric : this.metrics) {
            if (!metric.getName().equals(name)) continue;
            return metric;
        }
        throw this.createError("Metric by the name {0} was not found on the hub", name);
    }

    public List<Metric> getMetrics() {
        if (this.metrics == null) {
            return Collections.EMPTY_LIST;
        }
        return this.metrics;
    }

    public void setMetrics(List<Metric> metrics) {
        this.metrics = metrics;
    }

    public int hashCode() {
        int hash = 7;
        hash = 37 * hash + Objects.hashCode(this.metrics);
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Metrics other = (Metrics)obj;
        return Objects.equals(this.metrics, other.metrics);
    }

    public String toString() {
        return "Metrics{metrics=" + String.valueOf(this.metrics) + "}";
    }
}

