/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.codesonar.models;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.jenkinsci.plugins.codesonar.CodeSonarPluginException;
import org.jenkinsci.plugins.codesonar.models.projects.Project;

@XmlRootElement(name="search_results")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class SearchResults
implements Serializable {
    @XmlElement(name="project")
    private List<Project> projects;

    private CodeSonarPluginException createError(String msg, Object ... args) {
        return new CodeSonarPluginException(msg, args);
    }

    public Project getProjectByName(String projectName) throws CodeSonarPluginException {
        ArrayList<Project> duplicates = new ArrayList<Project>();
        for (Project project : this.getProjects()) {
            if (!project.getName().equals(projectName)) continue;
            duplicates.add(project);
        }
        if (duplicates.size() > 1) {
            throw this.createError("Multiple projects found with name: {0}%nMake sure projects do not share the same name.", projectName);
        }
        if (duplicates.size() == 0) {
            throw this.createError("Project by the name {0} was not found on the hub", projectName);
        }
        return (Project)duplicates.get(0);
    }

    public List<Project> getProjects() {
        if (this.projects == null) {
            this.projects = new ArrayList<Project>();
        }
        return this.projects;
    }

    public void setProjects(List<Project> projects) {
        this.projects = projects;
    }

    public String toString() {
        return "SearchResults{projects=" + String.valueOf(this.getProjects()) + "}";
    }
}

