/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.codesonar.models;

import java.net.URI;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.javatuples.Pair;
import org.jenkinsci.plugins.codesonar.models.analysis.Analysis;
import org.jenkinsci.plugins.codesonar.models.metrics.Metrics;
import org.jenkinsci.plugins.codesonar.models.procedures.Procedures;

public class CodeSonarBuildActionDTO {
    public static final int MEMORY_GREEDY_VERSION = 1;
    public static final int MEMORY_OPTIMIZED_VERSION = 2;
    private static final Logger LOGGER = Logger.getLogger(CodeSonarBuildActionDTO.class.getName());
    private int dtoVersion;
    private Long analysisId;
    private Analysis analysisActiveWarnings;
    private Analysis analysisNewWarnings;
    private Metrics metrics;
    private Procedures procedures;
    private URI baseHubUri;
    private List<Pair<String, String>> conditionNamesAndResults;

    public CodeSonarBuildActionDTO(Long analysisId, URI baseHubUri) {
        this(2, analysisId, null, null, null, null, baseHubUri);
    }

    public CodeSonarBuildActionDTO(Long analysisId, Analysis analysisActiveWarnings, Analysis analysisNewWarnings, Metrics metrics, Procedures procedures, URI baseHubUri) {
        this(1, analysisId, analysisActiveWarnings, analysisNewWarnings, metrics, procedures, baseHubUri);
    }

    private CodeSonarBuildActionDTO(int dtoVersion, Long analysisId, Analysis analysisActiveWarnings, Analysis analysisNewWarnings, Metrics metrics, Procedures procedures, URI baseHubUri) {
        this.dtoVersion = dtoVersion;
        this.analysisId = analysisId;
        this.analysisActiveWarnings = analysisActiveWarnings;
        this.analysisNewWarnings = analysisNewWarnings;
        this.metrics = metrics;
        this.procedures = procedures;
        this.baseHubUri = baseHubUri;
    }

    public Long getAnalysisId() {
        return this.analysisId;
    }

    public Analysis getAnalysisActiveWarnings() {
        return this.analysisActiveWarnings;
    }

    public Analysis getAnalysisNewWarnings() {
        return this.analysisNewWarnings;
    }

    public Metrics getMetrics() {
        return this.metrics;
    }

    public Procedures getProcedures() {
        return this.procedures;
    }

    public URI getBaseHubUri() {
        return this.baseHubUri;
    }

    public List<Pair<String, String>> getConditionNamesAndResults() {
        return this.conditionNamesAndResults;
    }

    public void setConditionNamesAndResults(List<Pair<String, String>> conditionNamesAndResults) {
        this.conditionNamesAndResults = conditionNamesAndResults;
    }

    public int getDtoVersion() {
        return this.dtoVersion;
    }

    protected Object readResolve() {
        if (this.dtoVersion == 0) {
            LOGGER.log(Level.WARNING, "Found unassigned DTO version on persisted build, setting it to {0}", 1);
            this.dtoVersion = 1;
        }
        if (this.analysisId == null) {
            LOGGER.log(Level.WARNING, "Found empty analysis id on persisted analysis");
        } else {
            LOGGER.log(Level.INFO, "Found analysis id {0} on persisted analysis", this.analysisId.toString());
        }
        if (this.analysisActiveWarnings == null) {
            LOGGER.log(Level.WARNING, "Found empty analysisActiveWarnings on persisted analysis");
        } else if (this.analysisId == null) {
            this.analysisId = Long.valueOf(this.analysisActiveWarnings.getAnalysisId());
            LOGGER.log(Level.INFO, "Migrating analysis id {0} from active warnings to analysisId", this.analysisId.toString());
        }
        if (this.analysisNewWarnings == null) {
            LOGGER.log(Level.WARNING, "Found empty analysisNewWarnings on persisted analysis");
        } else if (this.analysisId == null) {
            this.analysisId = Long.valueOf(this.analysisNewWarnings.getAnalysisId());
            LOGGER.log(Level.INFO, "Migrating analysis id {0} from new warnings to analysisId", this.analysisId.toString());
        }
        if (this.metrics == null) {
            LOGGER.log(Level.WARNING, "Found empty metrics on persisted analysis");
        }
        if (this.procedures == null) {
            LOGGER.log(Level.WARNING, "Found empty procedures on persisted analysis");
        }
        if (this.baseHubUri == null) {
            LOGGER.log(Level.WARNING, "Found empty baseHubUri on persisted analysis");
        }
        return this;
    }
}

