/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.codesonar.conditions;

import hudson.Extension;
import hudson.Launcher;
import hudson.model.Result;
import hudson.model.TaskListener;
import hudson.util.FormValidation;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import org.jenkinsci.Symbol;
import org.jenkinsci.plugins.codesonar.CodeSonarLogger;
import org.jenkinsci.plugins.codesonar.CodeSonarPluginException;
import org.jenkinsci.plugins.codesonar.conditions.Condition;
import org.jenkinsci.plugins.codesonar.conditions.ConditionDescriptor;
import org.jenkinsci.plugins.codesonar.models.CodeSonarAlertLevels;
import org.jenkinsci.plugins.codesonar.services.CodeSonarHubAnalysisDataLoader;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;

public class YellowAlertLimitCondition
extends Condition {
    private static final Logger LOGGER = Logger.getLogger(YellowAlertLimitCondition.class.getName());
    private static final String NAME = "Yellow alerts";
    private static final String RESULT_DESCRIPTION_MESSAGE_FORMAT = "threshold={0,number,0}, count: {1,number,0}";
    private int alertLimit = 1;
    private String warrantedResult = Result.UNSTABLE.toString();

    @DataBoundConstructor
    public YellowAlertLimitCondition(int alertLimit) {
        this.alertLimit = alertLimit;
    }

    public int getAlertLimit() {
        return this.alertLimit;
    }

    @DataBoundSetter
    public void setAlertLimit(int alertLimit) {
        this.alertLimit = alertLimit;
    }

    public String getWarrantedResult() {
        return this.warrantedResult;
    }

    @DataBoundSetter
    public void setWarrantedResult(String warrantedResult) {
        this.warrantedResult = warrantedResult;
    }

    @Override
    public Result validate(CodeSonarHubAnalysisDataLoader current, CodeSonarHubAnalysisDataLoader previous, Launcher launcher, TaskListener listener, CodeSonarLogger csLogger) throws CodeSonarPluginException {
        if (current == null) {
            this.registerResult(csLogger, "current build not found", new Object[0]);
            return Result.SUCCESS;
        }
        int yellowAlerts = current.getNumberOfAlerts(CodeSonarAlertLevels.YELLOW);
        this.registerResult(csLogger, RESULT_DESCRIPTION_MESSAGE_FORMAT, this.alertLimit, yellowAlerts);
        if (yellowAlerts > this.alertLimit) {
            return Result.fromString((String)this.warrantedResult);
        }
        return Result.SUCCESS;
    }

    @Symbol(value={"yellowAlerts"})
    @Extension
    public static final class DescriptorImpl
    extends ConditionDescriptor<YellowAlertLimitCondition> {
        public DescriptorImpl() {
            this.load();
        }

        @Nonnull
        public String getDisplayName() {
            return YellowAlertLimitCondition.NAME;
        }

        public FormValidation doCheckAlertLimit(@QueryParameter(value="alertLimit") int alertLimit) {
            if (alertLimit < 0) {
                return FormValidation.error((String)"Cannot be a negative number");
            }
            return FormValidation.ok();
        }
    }
}

