/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.codesonar.conditions;

import hudson.Extension;
import hudson.Launcher;
import hudson.model.Result;
import hudson.model.TaskListener;
import hudson.util.FormValidation;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.Symbol;
import org.jenkinsci.plugins.codesonar.CodeSonarLogger;
import org.jenkinsci.plugins.codesonar.CodeSonarPluginException;
import org.jenkinsci.plugins.codesonar.conditions.Condition;
import org.jenkinsci.plugins.codesonar.conditions.ConditionDescriptor;
import org.jenkinsci.plugins.codesonar.services.CodeSonarHubAnalysisDataLoader;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;

public class WarningCountIncreaseSpecifiedScoreAndHigherCondition
extends Condition {
    private static final Logger LOGGER = Logger.getLogger(WarningCountIncreaseSpecifiedScoreAndHigherCondition.class.getName());
    private static final String NAME = "Warning count increase: specified score and higher";
    private static final String RESULT_DESCRIPTION_MESSAGE_FORMAT = "score={0,number,0}, threshold={1,number,0.00}%, increase={2,number,0.00}% (count: current={3,number,0}, previous={4,number,0})";
    private int rankOfWarnings = 30;
    private String warningPercentage = String.valueOf(5.0f);
    private String warrantedResult = Result.UNSTABLE.toString();

    @DataBoundConstructor
    public WarningCountIncreaseSpecifiedScoreAndHigherCondition(int rankOfWarnings, String warningPercentage) {
        this.rankOfWarnings = rankOfWarnings;
        this.warningPercentage = warningPercentage;
    }

    public int getRankOfWarnings() {
        return this.rankOfWarnings;
    }

    public void setRankOfWarnings(int rankOfWarnings) {
        this.rankOfWarnings = rankOfWarnings;
    }

    public String getWarningPercentage() {
        return this.warningPercentage;
    }

    public void setWarningPercentage(String warningPercentage) {
        this.warningPercentage = warningPercentage;
    }

    public String getWarrantedResult() {
        return this.warrantedResult;
    }

    @DataBoundSetter
    public void setWarrantedResult(String warrantedResult) {
        this.warrantedResult = warrantedResult;
    }

    @Override
    public Result validate(CodeSonarHubAnalysisDataLoader current, CodeSonarHubAnalysisDataLoader previous, Launcher launcher, TaskListener listener, CodeSonarLogger csLogger) throws CodeSonarPluginException {
        double calculatedWarningPercentage;
        double thresholdPercentage = Double.parseDouble(this.warningPercentage);
        if (current == null) {
            this.registerResult(csLogger, "current build not found", new Object[0]);
            return Result.SUCCESS;
        }
        if (previous == null) {
            this.registerResult(csLogger, "previous successful build not found", new Object[0]);
            return Result.SUCCESS;
        }
        long warningsAboveThresholdForCurrent = current.getNumberOfWarningsWithScoreAboveThreshold(this.rankOfWarnings);
        long warningsAboveThresholdForPrevious = previous.getNumberOfWarningsWithScoreAboveThreshold(this.rankOfWarnings);
        if (warningsAboveThresholdForPrevious == 0L) {
            calculatedWarningPercentage = 100.0 * (double)warningsAboveThresholdForCurrent;
        } else {
            long diff = warningsAboveThresholdForCurrent - warningsAboveThresholdForPrevious;
            calculatedWarningPercentage = 100.0 * ((double)diff / (double)warningsAboveThresholdForPrevious);
        }
        this.registerResult(csLogger, RESULT_DESCRIPTION_MESSAGE_FORMAT, this.rankOfWarnings, thresholdPercentage, calculatedWarningPercentage, warningsAboveThresholdForCurrent, warningsAboveThresholdForPrevious);
        if (calculatedWarningPercentage > thresholdPercentage) {
            return Result.fromString((String)this.warrantedResult);
        }
        return Result.SUCCESS;
    }

    @Symbol(value={"warningCountIncreaseSpecifiedScoreAndHigher"})
    @Extension
    public static final class DescriptorImpl
    extends ConditionDescriptor<WarningCountIncreaseSpecifiedScoreAndHigherCondition> {
        public DescriptorImpl() {
            this.load();
        }

        @Nonnull
        public String getDisplayName() {
            return WarningCountIncreaseSpecifiedScoreAndHigherCondition.NAME;
        }

        public FormValidation doCheckWarningPercentage(@QueryParameter(value="warningPercentage") String warningPercentage) {
            if (StringUtils.isBlank((String)warningPercentage)) {
                return FormValidation.error((String)"Cannot be empty");
            }
            try {
                float v = Float.parseFloat(warningPercentage);
                if (v < 0.0f) {
                    return FormValidation.error((String)"The provided value must be zero or greater");
                }
            }
            catch (NumberFormatException numberFormatException) {
                return FormValidation.error((String)"Not a valid decimal number");
            }
            return FormValidation.ok();
        }
    }
}

