/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.codesonar.conditions;

import hudson.Extension;
import hudson.Launcher;
import hudson.model.Result;
import hudson.model.TaskListener;
import hudson.util.FormValidation;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import org.jenkinsci.Symbol;
import org.jenkinsci.plugins.codesonar.CodeSonarLogger;
import org.jenkinsci.plugins.codesonar.CodeSonarPluginException;
import org.jenkinsci.plugins.codesonar.conditions.Condition;
import org.jenkinsci.plugins.codesonar.conditions.ConditionDescriptor;
import org.jenkinsci.plugins.codesonar.services.CodeSonarHubAnalysisDataLoader;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;

public class WarningCountAbsoluteSpecifiedScoreAndHigherCondition
extends Condition {
    private static final Logger LOGGER = Logger.getLogger(WarningCountAbsoluteSpecifiedScoreAndHigherCondition.class.getName());
    private static final String NAME = "Warning count absolute: specified score and higher";
    private static final String RESULT_DESCRIPTION_MESSAGE_FORMAT = "rank={0,number,0}, threshold={1,number,0}, count={2,number,0}";
    private int rankOfWarnings = 30;
    private int warningCountThreshold = 20;
    private String warrantedResult = Result.UNSTABLE.toString();

    @DataBoundConstructor
    public WarningCountAbsoluteSpecifiedScoreAndHigherCondition(int rankOfWarnings, int warningCountThreshold) {
        this.rankOfWarnings = rankOfWarnings;
        this.warningCountThreshold = warningCountThreshold;
    }

    public int getRankOfWarnings() {
        return this.rankOfWarnings;
    }

    public void setRankOfWarnings(int rankOfWarnings) {
        this.rankOfWarnings = rankOfWarnings;
    }

    public int getWarningCountThreshold() {
        return this.warningCountThreshold;
    }

    public void setWarningCountThreshold(int warningCountThreshold) {
        this.warningCountThreshold = warningCountThreshold;
    }

    public String getWarrantedResult() {
        return this.warrantedResult;
    }

    @DataBoundSetter
    public void setWarrantedResult(String warrantedResult) {
        this.warrantedResult = warrantedResult;
    }

    @Override
    public Result validate(CodeSonarHubAnalysisDataLoader current, CodeSonarHubAnalysisDataLoader previous, Launcher launcher, TaskListener listener, CodeSonarLogger csLogger) throws CodeSonarPluginException {
        if (current == null) {
            this.registerResult(csLogger, "current build not found", new Object[0]);
            return Result.SUCCESS;
        }
        long warningsAboveThreshold = current.getNumberOfWarningsWithScoreAboveThreshold(this.rankOfWarnings);
        this.registerResult(csLogger, RESULT_DESCRIPTION_MESSAGE_FORMAT, this.rankOfWarnings, this.warningCountThreshold, warningsAboveThreshold);
        if (warningsAboveThreshold > (long)this.warningCountThreshold) {
            return Result.fromString((String)this.warrantedResult);
        }
        return Result.SUCCESS;
    }

    @Symbol(value={"warningCountAbsoluteSpecifiedScoreAndHigher"})
    @Extension
    public static final class DescriptorImpl
    extends ConditionDescriptor<WarningCountAbsoluteSpecifiedScoreAndHigherCondition> {
        public DescriptorImpl() {
            this.load();
        }

        @Nonnull
        public String getDisplayName() {
            return WarningCountAbsoluteSpecifiedScoreAndHigherCondition.NAME;
        }

        public FormValidation doCheckWarningCountThreshold(@QueryParameter(value="warningCountThreshold") int warningCountThreshold) {
            if (warningCountThreshold < 0) {
                return FormValidation.error((String)"The provided value must be zero or greater");
            }
            return FormValidation.ok();
        }
    }
}

