/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.codesonar.conditions;

import hudson.Extension;
import hudson.Launcher;
import hudson.model.Result;
import hudson.model.TaskListener;
import hudson.util.FormValidation;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import org.jenkinsci.Symbol;
import org.jenkinsci.plugins.codesonar.CodeSonarLogger;
import org.jenkinsci.plugins.codesonar.CodeSonarPluginException;
import org.jenkinsci.plugins.codesonar.conditions.Condition;
import org.jenkinsci.plugins.codesonar.conditions.ConditionDescriptor;
import org.jenkinsci.plugins.codesonar.models.CodeSonarAlertLevels;
import org.jenkinsci.plugins.codesonar.services.CodeSonarHubAnalysisDataLoader;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;

public class RedAlertLimitCondition
extends Condition {
    private static final Logger LOGGER = Logger.getLogger(RedAlertLimitCondition.class.getName());
    private static final String NAME = "Red alerts";
    private static final String RESULT_DESCRIPTION_MESSAGE_FORMAT = "threshold={0,number,0}, count={1,number,0}";
    private int alertLimit = 1;
    private String warrantedResult = Result.UNSTABLE.toString();

    @DataBoundConstructor
    public RedAlertLimitCondition(int alertLimit) {
        this.alertLimit = alertLimit;
    }

    public int getAlertLimit() {
        return this.alertLimit;
    }

    @DataBoundSetter
    public void setAlertLimit(int alertLimit) {
        this.alertLimit = alertLimit;
    }

    public String getWarrantedResult() {
        return this.warrantedResult;
    }

    @DataBoundSetter
    public void setWarrantedResult(String warrantedResult) {
        this.warrantedResult = warrantedResult;
    }

    @Override
    public Result validate(CodeSonarHubAnalysisDataLoader current, CodeSonarHubAnalysisDataLoader previous, Launcher launcher, TaskListener listener, CodeSonarLogger csLogger) throws CodeSonarPluginException {
        if (current == null) {
            this.registerResult(csLogger, "current build not found", new Object[0]);
            return Result.SUCCESS;
        }
        int redAlerts = current.getNumberOfAlerts(CodeSonarAlertLevels.RED);
        this.registerResult(csLogger, RESULT_DESCRIPTION_MESSAGE_FORMAT, this.alertLimit, redAlerts);
        if (redAlerts > this.alertLimit) {
            return Result.fromString((String)this.warrantedResult);
        }
        return Result.SUCCESS;
    }

    @Symbol(value={"redAlerts"})
    @Extension
    public static final class DescriptorImpl
    extends ConditionDescriptor<RedAlertLimitCondition> {
        public DescriptorImpl() {
            this.load();
        }

        @Nonnull
        public String getDisplayName() {
            return RedAlertLimitCondition.NAME;
        }

        public FormValidation doCheckAlertLimit(@QueryParameter(value="alertLimit") int alertLimit) {
            if (alertLimit < 0) {
                return FormValidation.error((String)"Cannot be a negative number");
            }
            return FormValidation.ok();
        }
    }
}

