/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.codesonar.conditions;

import hudson.Extension;
import hudson.Launcher;
import hudson.model.Result;
import hudson.model.TaskListener;
import hudson.util.FormValidation;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import org.jenkinsci.Symbol;
import org.jenkinsci.plugins.codesonar.CodeSonarLogger;
import org.jenkinsci.plugins.codesonar.CodeSonarPluginException;
import org.jenkinsci.plugins.codesonar.conditions.Condition;
import org.jenkinsci.plugins.codesonar.conditions.ConditionDescriptor;
import org.jenkinsci.plugins.codesonar.models.json.ProcedureJsonRow;
import org.jenkinsci.plugins.codesonar.services.CodeSonarHubAnalysisDataLoader;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;

public class ProcedureCyclomaticComplexityExceededCondition
extends Condition {
    private static final Logger LOGGER = Logger.getLogger(ProcedureCyclomaticComplexityExceededCondition.class.getName());
    private static final String NAME = "Cyclomatic complexity";
    private static final String RESULT_DESCRIPTION_MESSAGE_FORMAT = "threshold={0,number,0}, complexity={1,number,0} (procedure: ''{2}'')";
    private int maxCyclomaticComplexity = 30;
    private String warrantedResult = Result.UNSTABLE.toString();

    @DataBoundConstructor
    public ProcedureCyclomaticComplexityExceededCondition(int maxCyclomaticComplexity) {
        this.maxCyclomaticComplexity = maxCyclomaticComplexity;
    }

    public int getMaxCyclomaticComplexity() {
        return this.maxCyclomaticComplexity;
    }

    @DataBoundSetter
    public void setMaxCyclomaticComplexity(int maxCyclomaticComplexity) {
        this.maxCyclomaticComplexity = maxCyclomaticComplexity;
    }

    public String getWarrantedResult() {
        return this.warrantedResult;
    }

    @DataBoundSetter
    public void setWarrantedResult(String warrantedResult) {
        this.warrantedResult = warrantedResult;
    }

    @Override
    public Result validate(CodeSonarHubAnalysisDataLoader current, CodeSonarHubAnalysisDataLoader previous, Launcher launcher, TaskListener listener, CodeSonarLogger csLogger) throws CodeSonarPluginException {
        if (current == null) {
            this.registerResult(csLogger, "current build not found", new Object[0]);
            return Result.SUCCESS;
        }
        ProcedureJsonRow procedureRow = current.getProcedureWithMaxCyclomaticComplexity();
        this.registerResult(csLogger, RESULT_DESCRIPTION_MESSAGE_FORMAT, this.maxCyclomaticComplexity, procedureRow.getMetricCyclomaticComplexity(), procedureRow.getProcedure());
        if (procedureRow.getMetricCyclomaticComplexity() > this.maxCyclomaticComplexity) {
            return Result.fromString((String)this.warrantedResult);
        }
        return Result.SUCCESS;
    }

    @Symbol(value={"cyclomaticComplexity"})
    @Extension
    public static final class DescriptorImpl
    extends ConditionDescriptor<ProcedureCyclomaticComplexityExceededCondition> {
        public DescriptorImpl() {
            this.load();
        }

        @Nonnull
        public String getDisplayName() {
            return ProcedureCyclomaticComplexityExceededCondition.NAME;
        }

        public FormValidation doCheckMaxCyclomaticComplexity(@QueryParameter(value="maxCyclomaticComplexity") int maxCyclomaticComplexity) {
            if (maxCyclomaticComplexity < 0) {
                return FormValidation.error((String)"Cannot be a negative number");
            }
            return FormValidation.ok();
        }
    }
}

