/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.codesonar.conditions;

import hudson.Extension;
import hudson.Launcher;
import hudson.model.Result;
import hudson.model.TaskListener;
import hudson.util.FormValidation;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.Symbol;
import org.jenkinsci.plugins.codesonar.CodeSonarLogger;
import org.jenkinsci.plugins.codesonar.CodeSonarPluginException;
import org.jenkinsci.plugins.codesonar.conditions.Condition;
import org.jenkinsci.plugins.codesonar.conditions.ConditionDescriptor;
import org.jenkinsci.plugins.codesonar.services.CodeSonarHubAnalysisDataLoader;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;

public class NewWarningsIncreasedByPercentageCondition
extends Condition {
    private static final Logger LOGGER = Logger.getLogger(NewWarningsIncreasedByPercentageCondition.class.getName());
    private static final String NAME = "Warning count increase: new only";
    private static final String RESULT_DESCRIPTION_MESSAGE_FORMAT = "threshold={0,number,0.00}%, increase={1,number,0.00}% (count: new={2,number,0}, total={3,number,0})";
    private String percentage = "5.0f";
    private String warrantedResult = Result.UNSTABLE.toString();

    @DataBoundConstructor
    public NewWarningsIncreasedByPercentageCondition(String percentage) {
        this.percentage = percentage;
    }

    public String getPercentage() {
        return this.percentage;
    }

    @DataBoundSetter
    public void setPercentage(String percentage) {
        this.percentage = percentage;
    }

    public String getWarrantedResult() {
        return this.warrantedResult;
    }

    @DataBoundSetter
    public void setWarrantedResult(String warrantedResult) {
        this.warrantedResult = warrantedResult;
    }

    @Override
    public Result validate(CodeSonarHubAnalysisDataLoader current, CodeSonarHubAnalysisDataLoader previous, Launcher launcher, TaskListener listener, CodeSonarLogger csLogger) throws CodeSonarPluginException {
        float result;
        if (current == null) {
            this.registerResult(csLogger, "current build not found", new Object[0]);
            return Result.SUCCESS;
        }
        long numberOfActiveWarnings = current.getNumberOfActiveWarnings();
        long numberOfNewWarnings = current.getNumberOfNewWarnings();
        float activeWarningCount = numberOfActiveWarnings;
        float newWarningCount = numberOfNewWarnings;
        if (activeWarningCount == 0.0f) {
            result = newWarningCount > 0.0f ? 100.0f : 0.0f;
            LOGGER.log(Level.INFO, "no active warnings found, forcing new warning percentage to {0,number,0.00}%", Float.valueOf(result));
        } else {
            result = newWarningCount * 100.0f / activeWarningCount;
            LOGGER.log(Level.INFO, "new warning percentage = {0,number,0.00}%", Float.valueOf(result));
        }
        float thresholdPercentage = Float.parseFloat(this.percentage);
        LOGGER.log(Level.INFO, "threshold percentage = {0,number,0.00}%", Float.valueOf(thresholdPercentage));
        this.registerResult(csLogger, RESULT_DESCRIPTION_MESSAGE_FORMAT, Float.valueOf(thresholdPercentage), Float.valueOf(result), Float.valueOf(newWarningCount), Float.valueOf(activeWarningCount));
        if (result > thresholdPercentage) {
            return Result.fromString((String)this.warrantedResult);
        }
        return Result.SUCCESS;
    }

    @Symbol(value={"warningCountIncreaseNewOnly"})
    @Extension
    public static final class DescriptorImpl
    extends ConditionDescriptor<NewWarningsIncreasedByPercentageCondition> {
        public DescriptorImpl() {
            this.load();
        }

        @Nonnull
        public String getDisplayName() {
            return NewWarningsIncreasedByPercentageCondition.NAME;
        }

        public FormValidation doCheckPercentage(@QueryParameter(value="percentage") String percentage) {
            if (StringUtils.isBlank((String)percentage)) {
                return FormValidation.error((String)"Cannot be empty");
            }
            try {
                float v = Float.parseFloat(percentage);
                if (v < 0.0f) {
                    return FormValidation.error((String)"The provided value must be zero or greater");
                }
            }
            catch (NumberFormatException numberFormatException) {
                return FormValidation.error((String)"Not a valid decimal number");
            }
            return FormValidation.ok();
        }
    }
}

