/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.codesonar.conditions;

import hudson.DescriptorExtensionList;
import hudson.ExtensionPoint;
import hudson.Launcher;
import hudson.model.Describable;
import hudson.model.Descriptor;
import hudson.model.Result;
import hudson.model.TaskListener;
import java.text.MessageFormat;
import jenkins.model.Jenkins;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.plugins.codesonar.CodeSonarLogger;
import org.jenkinsci.plugins.codesonar.CodeSonarPluginException;
import org.jenkinsci.plugins.codesonar.conditions.ConditionDescriptor;
import org.jenkinsci.plugins.codesonar.services.CodeSonarHubAnalysisDataLoader;

public abstract class Condition
implements Describable<Condition>,
ExtensionPoint {
    protected static final String CURRENT_BUILD_DATA_NOT_AVAILABLE = "current build not found";
    protected static final String PREVIOUS_BUILD_DATA_NOT_AVAILABLE = "previous successful build not found";
    protected static final String DATA_LOADER_EMPTY_RESPONSE = "Data loader returned an empty response";
    private String resultDescription;

    public abstract Result validate(CodeSonarHubAnalysisDataLoader var1, CodeSonarHubAnalysisDataLoader var2, Launcher var3, TaskListener var4, CodeSonarLogger var5) throws CodeSonarPluginException;

    public Descriptor<Condition> getDescriptor() {
        Jenkins instance = Jenkins.getInstanceOrNull();
        if (instance != null) {
            return (ConditionDescriptor)instance.getDescriptorOrDie(this.getClass());
        }
        throw new NullPointerException("Jenkins is not started or is stopped");
    }

    public static DescriptorExtensionList<Condition, ConditionDescriptor<Condition>> getAll() {
        Jenkins instance = Jenkins.getInstanceOrNull();
        if (instance != null) {
            return instance.getDescriptorList(Condition.class);
        }
        throw new NullPointerException("Jenkins is not started or is stopped");
    }

    public String describeResult() {
        if (StringUtils.isBlank((String)this.resultDescription)) {
            return this.getDescriptor().getDisplayName();
        }
        return String.format("%s [%s]", this.getDescriptor().getDisplayName(), this.resultDescription);
    }

    protected void registerResult(CodeSonarLogger logger, String message, Object ... args) {
        this.resultDescription = args != null && args.length > 0 ? MessageFormat.format(message, args) : message;
        logger.writeInfo(this.resultDescription, new Object[0]);
    }
}

