/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.codesonar;

import com.cloudbees.plugins.credentials.CredentialsMatcher;
import com.cloudbees.plugins.credentials.CredentialsMatchers;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.common.CertificateCredentials;
import com.cloudbees.plugins.credentials.common.StandardCertificateCredentials;
import com.cloudbees.plugins.credentials.common.StandardCredentials;
import com.cloudbees.plugins.credentials.common.StandardListBoxModel;
import com.cloudbees.plugins.credentials.common.StandardUsernamePasswordCredentials;
import com.cloudbees.plugins.credentials.common.UsernamePasswordCredentials;
import hudson.DescriptorExtensionList;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.Util;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.Item;
import hudson.model.ItemGroup;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.remoting.VirtualChannel;
import hudson.security.ACL;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Publisher;
import hudson.tasks.Recorder;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import hudson.util.Secret;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import jenkins.tasks.SimpleBuildStep;
import org.acegisecurity.Authentication;
import org.apache.commons.collections.ListUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.NumberUtils;
import org.javatuples.Pair;
import org.jenkinsci.Symbol;
import org.jenkinsci.plugins.codesonar.CodeSonarBuildAction;
import org.jenkinsci.plugins.codesonar.CodeSonarLogger;
import org.jenkinsci.plugins.codesonar.CodeSonarPluginException;
import org.jenkinsci.plugins.codesonar.conditions.Condition;
import org.jenkinsci.plugins.codesonar.conditions.ConditionDescriptor;
import org.jenkinsci.plugins.codesonar.models.CodeSonarBuildActionDTO;
import org.jenkinsci.plugins.codesonar.models.CodeSonarHubInfo;
import org.jenkinsci.plugins.codesonar.services.AuthenticationService;
import org.jenkinsci.plugins.codesonar.services.CodeSonarHubAnalysisDataLoader;
import org.jenkinsci.plugins.codesonar.services.HttpService;
import org.jenkinsci.plugins.codesonar.services.HubInfoService;
import org.jenkinsci.plugins.plaincredentials.FileCredentials;
import org.jenkinsci.remoting.RoleChecker;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;

public class CodeSonarPublisher
extends Recorder
implements SimpleBuildStep {
    private static final Logger LOGGER = Logger.getLogger(CodeSonarPublisher.class.getName());
    private static final String CS_PROJECT_FILE_EXTENSION = ".prj";
    private static final String CS_PROJECT_DIR_EXTENSION = ".prj_files";
    private String visibilityFilter;
    private String newWarningsFilter;
    private String hubAddress;
    private String projectName;
    private String protocol = "http";
    private String aid;
    private int socketTimeoutMS = -1;
    private String projectFile;
    private String comparisonAnalysis;
    private HttpService httpService = null;
    private AuthenticationService authenticationService = null;
    private List<Condition> conditions;
    private String credentialId;
    private String serverCertificateCredentialId = "";

    @DataBoundConstructor
    public CodeSonarPublisher(List<Condition> conditions, String protocol, String hubAddress, String projectName, String credentialId, String visibilityFilter) {
        this.hubAddress = hubAddress;
        this.projectName = projectName;
        this.protocol = protocol;
        if (conditions == null) {
            conditions = ListUtils.EMPTY_LIST;
        }
        this.conditions = conditions;
        this.credentialId = credentialId;
        this.visibilityFilter = visibilityFilter;
    }

    private CodeSonarPluginException createError(String msg, Object ... args) {
        return new CodeSonarPluginException(msg, args);
    }

    private CodeSonarPluginException createError(String msg, Throwable cause) {
        return new CodeSonarPluginException(msg, cause, new Object[0]);
    }

    @DataBoundSetter
    public void setVisibilityFilter(String visibilityFilter) {
        this.visibilityFilter = visibilityFilter;
    }

    @DataBoundSetter
    public void setAid(String aid) {
        this.aid = aid;
    }

    public String getAid() {
        return this.aid;
    }

    @DataBoundSetter
    public void setSocketTimeoutMS(int socketTimeoutMS) {
        this.socketTimeoutMS = socketTimeoutMS;
    }

    public int getSocketTimeoutMS() {
        return this.socketTimeoutMS;
    }

    public String getServerCertificateCredentialId() {
        return this.serverCertificateCredentialId;
    }

    @DataBoundSetter
    public void setServerCertificateCredentialId(String serverCertificateCredentialId) {
        this.serverCertificateCredentialId = serverCertificateCredentialId;
    }

    public String getVisibilityFilter() {
        return this.visibilityFilter;
    }

    public String getVisibilityFilterOrDefault() {
        return StringUtils.isNotBlank((String)this.visibilityFilter) ? this.visibilityFilter : "active";
    }

    public String getProjectFile() {
        return this.projectFile;
    }

    @DataBoundSetter
    public void setProjectFile(String projectFile) {
        this.projectFile = projectFile;
    }

    public String getComparisonAnalysis() {
        return this.comparisonAnalysis;
    }

    @DataBoundSetter
    public void setComparisonAnalysis(String comparisonAnalysis) {
        this.comparisonAnalysis = comparisonAnalysis;
    }

    public String getNewWarningsFilter() {
        return this.newWarningsFilter;
    }

    public String getNewWarningsFilterOrDefault() {
        return StringUtils.isNotBlank((String)this.newWarningsFilter) ? this.newWarningsFilter : "new";
    }

    @DataBoundSetter
    public void setNewWarningsFilter(String newWarningsFilter) {
        this.newWarningsFilter = newWarningsFilter;
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.NONE;
    }

    public List<Condition> getConditions() {
        return this.conditions;
    }

    public void setConditions(List<Condition> conditions) {
        this.conditions = conditions;
    }

    public BuildStepDescriptor getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    public String getHubAddress() {
        return this.hubAddress;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    public void setHubAddress(String hubAddress) {
        this.hubAddress = hubAddress;
    }

    public String getProjectName() {
        return this.projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public String getCredentialId() {
        return this.credentialId;
    }

    public void setCredentialId(String credentialId) {
        this.credentialId = credentialId;
    }

    private HttpService getHttpService(@Nonnull Run<?, ?> run) throws CodeSonarPluginException {
        if (this.httpService == null) {
            this.httpService = this.createHttpService(run);
        }
        return this.httpService;
    }

    public void setHttpService(HttpService httpService) {
        this.httpService = httpService;
    }

    private AuthenticationService getAuthenticationService(@Nonnull Run<?, ?> run) throws CodeSonarPluginException {
        if (this.authenticationService == null) {
            this.authenticationService = new AuthenticationService(this.getHttpService(run));
        }
        return this.authenticationService;
    }

    public void setAuthenticationService(AuthenticationService authenticationService) {
        this.authenticationService = authenticationService;
    }

    private StandardCredentials lookupCredentials(String credentialId, Run<?, ?> run) {
        StandardCredentials hubUserCredentials = null;
        if (StringUtils.isNotBlank((String)credentialId)) {
            hubUserCredentials = (StandardCredentials)CredentialsMatchers.firstOrNull((Iterable)CredentialsProvider.lookupCredentials(StandardCredentials.class, (Item)run.getParent(), (Authentication)ACL.SYSTEM, Collections.emptyList()), (CredentialsMatcher)CredentialsMatchers.withId((String)credentialId));
        }
        return hubUserCredentials;
    }

    public void perform(@Nonnull Run<?, ?> run, @Nonnull FilePath workspace, @Nonnull Launcher launcher, @Nonnull TaskListener listener) throws InterruptedException, IOException {
        String expandedHubAddress = run.getEnvironment(listener).expand(Util.fixNull((String)this.hubAddress));
        String expandedProjectName = run.getEnvironment(listener).expand(Util.fixNull((String)this.projectName));
        LOGGER.log(Level.INFO, "projectName: {0} expandedProjectName {1}", new String[]{this.projectName, expandedProjectName});
        String expandedProjectFile = run.getEnvironment(listener).expand(Util.fixNull((String)this.projectFile));
        LOGGER.log(Level.INFO, "projectFile: {0} expandedProjectFile {1}", new String[]{this.projectFile, expandedProjectFile});
        if (expandedHubAddress.isEmpty()) {
            throw this.createError("Hub address not provided", new Object[0]);
        }
        if (expandedProjectName.isEmpty()) {
            throw this.createError("Project name not provided", new Object[0]);
        }
        CodeSonarLogger csLogger = new CodeSonarLogger(listener.getLogger());
        URI baseHubUri = URI.create(String.format("%s://%s", this.getProtocol(), expandedHubAddress));
        csLogger.writeInfo("Using hub URI: {0}", baseHubUri);
        HttpService httpService = this.getHttpService(run);
        HubInfoService hubInfoService = new HubInfoService(httpService);
        CodeSonarHubInfo hubInfo = hubInfoService.fetchHubInfo(baseHubUri);
        httpService.setHubInfo(hubInfo);
        LOGGER.log(Level.INFO, "hub version: {0}", hubInfo.getVersion());
        AuthenticationService authenticationService = this.getAuthenticationService(run);
        this.authenticate(authenticationService, baseHubUri, csLogger, run);
        String currentAnalysisIdString = null;
        if (StringUtils.isBlank((String)this.aid)) {
            LOGGER.log(Level.INFO, "Determining analysis id...");
            currentAnalysisIdString = (String)workspace.act((FilePath.FileCallable)new DetermineAid(expandedProjectFile));
            LOGGER.log(Level.INFO, "Found analysis id: {0}", currentAnalysisIdString);
        } else {
            currentAnalysisIdString = this.aid;
            LOGGER.log(Level.INFO, "Using override analysis id: \"" + this.aid + "\".");
        }
        Long currentAnalysisId = null;
        try {
            currentAnalysisId = Long.valueOf(currentAnalysisIdString);
        }
        catch (NumberFormatException e) {
            LOGGER.log(Level.WARNING, "Unable to parse analysis id \"" + currentAnalysisIdString + "\" as long integer.");
        }
        if (currentAnalysisId == null) {
            throw this.createError("No valid analysis id available", new Object[0]);
        }
        csLogger.writeInfo("Current analysis: analysisId {0} from hub \"{1}\"", String.valueOf(currentAnalysisId), baseHubUri);
        CodeSonarHubAnalysisDataLoader currentDataLoader = new CodeSonarHubAnalysisDataLoader(httpService, hubInfo, baseHubUri, currentAnalysisId, this.getVisibilityFilterOrDefault(), this.getNewWarningsFilterOrDefault());
        CodeSonarBuildActionDTO currentBuildActionDTO = new CodeSonarBuildActionDTO(currentAnalysisId, baseHubUri);
        CodeSonarBuildAction csba = new CodeSonarBuildAction(currentBuildActionDTO, run, expandedProjectName);
        ArrayList<Pair<String, String>> conditionNamesAndResults = new ArrayList<Pair<String, String>>();
        CodeSonarHubAnalysisDataLoader previousDataLoader = null;
        if (StringUtils.isBlank((String)this.comparisonAnalysis)) {
            previousDataLoader = this.findPreviousBuildAnalysisDataLoader(run, expandedProjectName, csLogger, baseHubUri, hubInfo);
        } else {
            Long comparisonAnalysisId = null;
            try {
                comparisonAnalysisId = Long.valueOf(this.comparisonAnalysis);
            }
            catch (NumberFormatException e) {
                throw this.createError("Unable to parse base analysis ID", e);
            }
            previousDataLoader = new CodeSonarHubAnalysisDataLoader(httpService, hubInfo, baseHubUri, comparisonAnalysisId, this.getVisibilityFilterOrDefault(), this.getNewWarningsFilterOrDefault());
            csLogger.writeInfo("Using analysis {0} on hub {1} for comparison", String.valueOf(comparisonAnalysisId), baseHubUri);
        }
        csLogger.writeInfo("Evaluating conditions...", new Object[0]);
        for (Condition condition : this.conditions) {
            Result validationResult = condition.validate(currentDataLoader, previousDataLoader, launcher, listener, csLogger);
            Pair pair = Pair.with((Object)condition.describeResult(), (Object)validationResult.toString());
            conditionNamesAndResults.add((Pair<String, String>)pair);
            run.setResult(validationResult);
            csLogger.writeInfo("\"{0}\" marked the build as {1}", condition.getDescriptor().getDisplayName(), validationResult.toString());
        }
        csLogger.writeInfo("Done evaluating conditions.", new Object[0]);
        csba.getBuildActionDTO().setConditionNamesAndResults(conditionNamesAndResults);
        run.addAction((Action)csba);
        authenticationService.signOut(baseHubUri);
        csLogger.writeInfo("Done performing codesonar actions", new Object[0]);
    }

    private CodeSonarHubAnalysisDataLoader findPreviousBuildAnalysisDataLoader(Run<?, ?> run, String expandedProjectName, CodeSonarLogger csLogger, URI baseHubUri, CodeSonarHubInfo hubInfo) {
        CodeSonarHubAnalysisDataLoader previousDataLoader = null;
        csLogger.writeInfo("Finding previous builds for comparison...", new Object[0]);
        Run previousRun = run.getPreviousSuccessfulBuild();
        while (previousRun != null && previousDataLoader == null) {
            String previousBuildName = previousRun.getDisplayName();
            csLogger.writeInfo("Checking previous successful build: \"{0}\"...", previousBuildName);
            List buildActions = previousRun.getActions(CodeSonarBuildAction.class);
            List projectBuildActions = buildActions.stream().filter(c -> c.getProjectName() != null && c.getProjectName().equals(expandedProjectName)).collect(Collectors.toList());
            if (projectBuildActions == null || projectBuildActions.isEmpty()) {
                csLogger.writeInfo("Ignoring build since it has no matching build data. build=\"{0}\", project=\"{1}\"", previousBuildName, expandedProjectName);
            } else if (projectBuildActions.size() > 1) {
                csLogger.writeInfo("Ignoring build since it has too many matching build actions. build=\"{0}\", project=\"{1}\", matches={2}", previousBuildName, expandedProjectName, projectBuildActions.size());
            } else {
                CodeSonarBuildAction previousBuildAction = (CodeSonarBuildAction)projectBuildActions.get(0);
                CodeSonarBuildActionDTO previousDTO = previousBuildAction.getBuildActionDTO();
                URI previousBuildBaseHubUri = previousDTO.getBaseHubUri();
                if (!baseHubUri.equals(previousBuildBaseHubUri)) {
                    csLogger.writeInfo("Ignoring build since hub URI does not match current build. build=\"{0}\", hub=\"{1}\"", previousBuildName, previousBuildBaseHubUri);
                } else {
                    Long previousAnalysisId = previousDTO.getAnalysisId();
                    previousDataLoader = new CodeSonarHubAnalysisDataLoader(this.httpService, hubInfo, previousBuildBaseHubUri, previousAnalysisId, this.getVisibilityFilterOrDefault(), this.getNewWarningsFilterOrDefault());
                    csLogger.writeInfo("Found previous build for comparison: build=\"{0}\", analysisId={1}, hub=\"{2}\"", previousBuildName, String.valueOf(previousAnalysisId), previousBuildBaseHubUri);
                }
            }
            if (previousDataLoader != null) continue;
            Run previousRun2 = previousRun.getPreviousSuccessfulBuild();
            if (previousRun2 == null) {
                previousRun = null;
                continue;
            }
            if (previousRun2.getId().equals(previousRun.getId())) {
                previousRun = null;
                continue;
            }
            previousRun = previousRun2;
        }
        if (previousDataLoader == null) {
            csLogger.writeInfo("Could not find a previous build with compatible analysis for comparison.", new Object[0]);
        }
        return previousDataLoader;
    }

    private void authenticate(AuthenticationService authenticationService, URI baseHubUri, CodeSonarLogger csLogger, Run<?, ?> run) throws CodeSonarPluginException {
        StandardCredentials hubUserCredentials = null;
        String hubUserCredentialId = this.getCredentialId();
        if (StringUtils.isNotBlank((String)hubUserCredentialId) && (hubUserCredentials = this.lookupCredentials(hubUserCredentialId, run)) == null) {
            throw this.createError("Credentials not found: \"{0}\"", hubUserCredentialId);
        }
        if (hubUserCredentials == null) {
            csLogger.writeInfo("Authenticating as Anonymous.", new Object[0]);
        } else if (hubUserCredentials instanceof StandardUsernamePasswordCredentials) {
            csLogger.writeInfo("Authenticating with username and password.", new Object[0]);
            UsernamePasswordCredentials userPassCredentials = (UsernamePasswordCredentials)hubUserCredentials;
            authenticationService.authenticate(baseHubUri, userPassCredentials.getUsername(), userPassCredentials.getPassword().getPlainText());
        } else if (hubUserCredentials instanceof StandardCertificateCredentials || hubUserCredentials instanceof FileCredentials) {
            csLogger.writeInfo("Authenticating with client certificate.", new Object[0]);
            if (!this.protocol.equals("https")) {
                throw this.createError("Certificate authentication requires HTTPS protocol.", new Object[0]);
            }
            authenticationService.authenticate(baseHubUri);
        } else {
            throw this.createError("Unrecognized credential type for credential \"{0}\": {1}", hubUserCredentialId, hubUserCredentials.getClass().getName());
        }
    }

    private HttpService createHttpService(@Nonnull Run<?, ?> run) throws CodeSonarPluginException {
        String serverCertificateCredentialId = this.getServerCertificateCredentialId();
        Collection<? extends Certificate> serverCertificates = null;
        if (StringUtils.isNotEmpty((String)serverCertificateCredentialId)) {
            StandardCredentials serverCertificateCredentials = this.lookupCredentials(serverCertificateCredentialId, run);
            if (serverCertificateCredentials == null) {
                throw this.createError("Credentials with id \"{0}\" not found", serverCertificateCredentialId);
            }
            if (serverCertificateCredentials instanceof FileCredentials) {
                LOGGER.log(Level.INFO, "Found FileCredentials provided as Hub HTTPS certificate");
                FileCredentials fileCredentials = (FileCredentials)serverCertificateCredentials;
                try {
                    CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
                    serverCertificates = certificateFactory.generateCertificates(fileCredentials.getContent());
                    LOGGER.log(Level.INFO, "X509Certificate initialized");
                }
                catch (IOException | CertificateException e) {
                    throw this.createError("Failed to create X509Certificate from Secret File Credential.", e);
                }
            } else {
                throw this.createError("Invalid credential type provided for hub HTTPS certificate: {0}", serverCertificateCredentials.getClass().getName());
            }
        }
        KeyStore clientCertificateKeyStore = null;
        Secret clientCertificatePassword = null;
        String hubUserCredentialId = this.getCredentialId();
        StandardCredentials hubUserCredentials = this.lookupCredentials(hubUserCredentialId, run);
        if (StringUtils.isNotBlank((String)hubUserCredentialId) && hubUserCredentials == null) {
            throw this.createError("Hub user credential ID not found: \"{0}\"", hubUserCredentialId);
        }
        if (hubUserCredentials != null) {
            if (hubUserCredentials instanceof StandardCertificateCredentials) {
                if (this.protocol.equals("http")) {
                    throw this.createError("Authentication using a certificate is only available when using HTTPS protocol.", new Object[0]);
                }
                LOGGER.log(Level.INFO, "Configuring HttpClient with certificate authentication using \"Certificate\" credentials parameter kind");
                StandardCertificateCredentials certificateCredentials = (StandardCertificateCredentials)hubUserCredentials;
                clientCertificateKeyStore = certificateCredentials.getKeyStore();
                clientCertificatePassword = certificateCredentials.getPassword();
            } else if (hubUserCredentials instanceof FileCredentials) {
                LOGGER.log(Level.INFO, "Configuring HttpClient with certificate authentication using \"Secret File\" credentials parameter kind");
                FileCredentials certificateFileCredentials = (FileCredentials)hubUserCredentials;
                try {
                    clientCertificatePassword = Secret.fromString((String)"");
                    KeyStore keystore = KeyStore.getInstance("PKCS12");
                    keystore.load(certificateFileCredentials.getContent(), clientCertificatePassword.getPlainText().toCharArray());
                    clientCertificateKeyStore = keystore;
                    LOGGER.log(Level.INFO, "Client PKCS12 keystore successfully imported");
                }
                catch (IOException | KeyStoreException | NoSuchAlgorithmException | CertificateException e) {
                    throw this.createError("Failed to create PKCS12 keystore from Secret File Credential.", e);
                }
            }
        }
        return new HttpService(serverCertificates, clientCertificateKeyStore, clientCertificatePassword, this.getSocketTimeoutMS());
    }

    @Symbol(value={"codesonar"})
    @Extension
    public static class DescriptorImpl
    extends BuildStepDescriptor<Publisher> {
        public DescriptorImpl() {
            super(CodeSonarPublisher.class);
            this.load();
        }

        public boolean isApplicable(Class<? extends AbstractProject> type) {
            return true;
        }

        @Nonnull
        public String getDisplayName() {
            return "CodeSonar";
        }

        public List<ConditionDescriptor<?>> getAllConditions() {
            DescriptorExtensionList<Condition, ConditionDescriptor<Condition>> all = Condition.getAll();
            return new ArrayList((Collection<ConditionDescriptor<?>>)all);
        }

        public FormValidation doCheckHubAddress(@QueryParameter(value="hubAddress") String hubAddress) {
            if (StringUtils.isBlank((String)hubAddress)) {
                return FormValidation.error((String)"Hub address cannot be empty.");
            }
            if (hubAddress.startsWith("http://") || hubAddress.startsWith("https://")) {
                return FormValidation.error((String)"Protocol should not be part of the hub address, protocol is selected in seperate field");
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckProjectName(@QueryParameter(value="projectName") String projectName) {
            if (StringUtils.isBlank((String)projectName)) {
                return FormValidation.error((String)"Project name cannot be empty.");
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckVisibilityFilter(@QueryParameter(value="visibilityFilter") String visibilityFilter) {
            return this.validateVisibilityFilter(visibilityFilter);
        }

        public FormValidation doCheckNewWarningsFilter(@QueryParameter(value="newWarningsFilter") String visibilityFilter) {
            return this.validateVisibilityFilter(visibilityFilter);
        }

        private FormValidation validateVisibilityFilter(String visibilityFilter) {
            if (StringUtils.isBlank((String)visibilityFilter)) {
                return FormValidation.ok();
            }
            if (NumberUtils.isNumber((String)visibilityFilter)) {
                try {
                    if (Integer.parseInt(visibilityFilter) < 0) {
                        return FormValidation.error((String)"The visibility filter must be a positive integer");
                    }
                }
                catch (NumberFormatException e) {
                    return FormValidation.error((String)"Invalid numeric value for visibility filter", (Object[])new Object[]{visibilityFilter});
                }
            }
            return FormValidation.ok();
        }

        public ListBoxModel doFillCredentialIdItems(@AncestorInPath ItemGroup<?> context) {
            List credentials = CredentialsProvider.lookupCredentials(StandardCredentials.class, context, (Authentication)ACL.SYSTEM, Collections.emptyList());
            return new StandardListBoxModel().includeEmptyValue().withMatching(CredentialsMatchers.anyOf((CredentialsMatcher[])new CredentialsMatcher[]{CredentialsMatchers.instanceOf(StandardUsernamePasswordCredentials.class), CredentialsMatchers.instanceOf(CertificateCredentials.class)}), (Iterable)credentials);
        }

        public ListBoxModel doFillServerCertificateCredentialIdItems(@AncestorInPath ItemGroup<?> context) {
            List credentials = CredentialsProvider.lookupCredentials(StandardCredentials.class, context, (Authentication)ACL.SYSTEM, Collections.emptyList());
            return new StandardListBoxModel().includeEmptyValue().withMatching(CredentialsMatchers.anyOf((CredentialsMatcher[])new CredentialsMatcher[]{CredentialsMatchers.instanceOf(FileCredentials.class)}), (Iterable)credentials);
        }

        public ListBoxModel doFillProtocolItems() {
            ListBoxModel items = new ListBoxModel();
            items.add("http", "http");
            items.add("https", "https");
            return items;
        }
    }

    public static final class DetermineAid
    implements FilePath.FileCallable<String> {
        private static final String FILE_AID_TXT = "aid.txt";
        private String projectFile;

        public DetermineAid(String projectFile) {
            this.projectFile = projectFile;
        }

        private IOException createError(String msg, Object ... args) {
            IOException e = new IOException(MessageFormat.format(msg, args));
            LOGGER.log(Level.SEVERE, msg, e);
            return e;
        }

        private String getProjectFileBaseName(String fileName) {
            String baseFileName = fileName;
            if (StringUtils.endsWith((String)baseFileName, (String)CodeSonarPublisher.CS_PROJECT_FILE_EXTENSION)) {
                baseFileName = baseFileName.substring(0, baseFileName.lastIndexOf(CodeSonarPublisher.CS_PROJECT_FILE_EXTENSION));
            } else if (StringUtils.endsWith((String)baseFileName, (String)CodeSonarPublisher.CS_PROJECT_DIR_EXTENSION)) {
                baseFileName = baseFileName.substring(0, baseFileName.lastIndexOf(CodeSonarPublisher.CS_PROJECT_DIR_EXTENSION));
            }
            return baseFileName;
        }

        private Path getPrjFilesDirectory(Path projectFilePath) throws IOException {
            Path originalFileName = projectFilePath.getFileName();
            if (originalFileName == null) {
                throw this.createError("Specified CodeSonar Project File \"{0}\" does not represent a file or a directory neither", projectFilePath.toString());
            }
            String projectFileBaseName = this.getProjectFileBaseName(originalFileName.toString());
            Path resultingPath = Paths.get(projectFileBaseName + CodeSonarPublisher.CS_PROJECT_DIR_EXTENSION, new String[0]);
            Path parentPath = projectFilePath.getParent();
            if (parentPath != null) {
                resultingPath = parentPath.resolve(resultingPath);
            }
            return resultingPath;
        }

        private Path resolveRelativePath(File jenkinsPipelineCWD, Path path) {
            if (!path.isAbsolute()) {
                path = jenkinsPipelineCWD.toPath().resolve(path).normalize();
            }
            return path;
        }

        private String readAidFileContent(File aidFile) throws IOException, InterruptedException {
            FilePath fp = new FilePath(aidFile);
            LOGGER.log(Level.INFO, "Found aid.txt: " + String.valueOf(aidFile));
            String aid = fp.readToString();
            if (StringUtils.isBlank((String)aid)) {
                throw this.createError("File aid.txt is empty", new Object[0]);
            }
            return aid;
        }

        public String invoke(File jenkinsPipelineCWD, VirtualChannel vc) throws IOException, InterruptedException {
            if (StringUtils.isNotBlank((String)this.projectFile)) {
                Path projectFilePath = null;
                try {
                    projectFilePath = Paths.get(this.projectFile, new String[0]);
                }
                catch (InvalidPathException e) {
                    throw this.createError("Specified CodeSonar Project File \"{0}\" does not represent a file path", this.projectFile);
                }
                Path prjFilesDirectoryPath = this.getPrjFilesDirectory(projectFilePath);
                Path prjFilesDirectoryAbsolutePath = this.resolveRelativePath(jenkinsPipelineCWD, prjFilesDirectoryPath);
                if (Files.isDirectory(prjFilesDirectoryAbsolutePath, new LinkOption[0])) {
                    LOGGER.log(Level.INFO, "Finding aid.txt into {0}....", prjFilesDirectoryAbsolutePath.toString());
                    File aidFile = new File(prjFilesDirectoryAbsolutePath.toFile(), FILE_AID_TXT);
                    return this.readAidFileContent(aidFile);
                }
                throw this.createError(".prj_files directory \"{0}\" seems not to exist", prjFilesDirectoryAbsolutePath.toString());
            }
            if (jenkinsPipelineCWD != null) {
                LOGGER.log(Level.INFO, "Finding aid.txt into {0}....", jenkinsPipelineCWD.getAbsoluteFile());
                File[] prjFilesDirectories = jenkinsPipelineCWD.listFiles(new FileFilter(){

                    @Override
                    public boolean accept(File pathname) {
                        return pathname.isDirectory() && pathname.getName().endsWith(CodeSonarPublisher.CS_PROJECT_DIR_EXTENSION);
                    }
                });
                if (prjFilesDirectories != null && prjFilesDirectories.length > 0) {
                    File prjFilesDir = prjFilesDirectories[0];
                    if (prjFilesDirectories.length > 1) {
                        LOGGER.log(Level.WARNING, "More than one .prj_files directory found, going to take the first one: " + String.valueOf(prjFilesDir));
                    }
                    File aidFile = new File(prjFilesDir, FILE_AID_TXT);
                    return this.readAidFileContent(aidFile);
                }
                LOGGER.log(Level.SEVERE, "No prj_files directory found!");
            } else {
                LOGGER.log(Level.WARNING, "Could not determine Jenkins build working directory.");
            }
            throw this.createError("Could not find a .prj_files folder for project", new Object[0]);
        }

        public void checkRoles(RoleChecker rc) throws SecurityException {
        }
    }
}

