/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.codesonar;

import hudson.model.Action;
import hudson.model.Run;
import hudson.util.ChartUtil;
import hudson.util.DataSetBuilder;
import java.io.IOException;
import java.net.URI;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.javatuples.Pair;
import org.jenkinsci.plugins.codesonar.CodeSonarGraph;
import org.jenkinsci.plugins.codesonar.models.CodeSonarBuildActionDTO;
import org.jenkinsci.plugins.codesonar.models.analysis.Analysis;
import org.jenkinsci.plugins.codesonar.models.metrics.Metric;
import org.jenkinsci.plugins.codesonar.models.metrics.Metrics;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;

public class CodeSonarBuildAction
implements Action {
    private static final Logger LOGGER = Logger.getLogger(CodeSonarBuildAction.class.getName());
    private final CodeSonarBuildActionDTO buildActionDTO;
    private final Run<?, ?> run;
    private final String projectName;
    private String analysisUrl;

    public CodeSonarBuildAction(CodeSonarBuildActionDTO buildActionDTO, Run<?, ?> run, String projectName) {
        this.buildActionDTO = buildActionDTO;
        this.run = run;
        this.projectName = projectName;
    }

    public String getProjectName() {
        return this.projectName;
    }

    public String getAnalysisUrl() {
        return this.analysisUrl;
    }

    public String getIconFileName() {
        return "/plugin/codesonar/icons/codesonar-logo.png";
    }

    public String getDisplayName() {
        return "CodeSonar (" + this.projectName + ")";
    }

    public String getUrlName() {
        String analysisUrlString = "";
        URI baseHubUri = this.buildActionDTO.getBaseHubUri();
        if (baseHubUri == null) {
            LOGGER.log(Level.WARNING, "\"baseHubUri\" not found in persisted build");
        }
        Long analysisId = this.buildActionDTO.getAnalysisId();
        String analysisIdString = null;
        if (analysisId != null) {
            analysisIdString = String.valueOf(analysisId);
        } else {
            Analysis analysisActiveWarnings = this.buildActionDTO.getAnalysisActiveWarnings();
            if (analysisActiveWarnings == null) {
                LOGGER.log(Level.WARNING, "Neither \"analysisId\" nor \"analysisActiveWarnings\" data found in persisted build");
            } else {
                analysisIdString = analysisActiveWarnings.getAnalysisId();
            }
        }
        if (baseHubUri == null || analysisIdString == null) {
            LOGGER.log(Level.WARNING, "Could not create analysis URL for build summary page.");
        } else {
            analysisUrlString = baseHubUri.resolve(String.format("/analysis/%s.html", analysisIdString)).toString();
        }
        return analysisUrlString;
    }

    public CodeSonarBuildActionDTO getBuildActionDTO() {
        return this.buildActionDTO;
    }

    public List<Pair<String, String>> getConditionNamesAndResults() {
        return this.buildActionDTO.getConditionNamesAndResults();
    }

    public void doReportGraphs(StaplerRequest req, StaplerResponse rsp) throws IOException {
        String graphName = req.getParameter("name");
        CodeSonarGraph graph = new CodeSonarGraph();
        DataSetBuilder dsb = new DataSetBuilder();
        ChartUtil.NumberOnlyBuildLabel label = null;
        if (graphName.equals("totalWarnings")) {
            String title = "Total number of warnings";
            for (CodeSonarBuildAction codeSonarBuildAction = this; codeSonarBuildAction != null; codeSonarBuildAction = codeSonarBuildAction.getPreviousAction()) {
                CodeSonarBuildActionDTO prevBuildActionDTO = codeSonarBuildAction.getBuildActionDTO();
                if (prevBuildActionDTO == null) continue;
                int totalNubmerOfWarnings = 0;
                Analysis analysisActiveWarnings = prevBuildActionDTO.getAnalysisActiveWarnings();
                if (analysisActiveWarnings != null) {
                    totalNubmerOfWarnings = analysisActiveWarnings.getWarnings().size();
                }
                label = new ChartUtil.NumberOnlyBuildLabel(codeSonarBuildAction.run);
                dsb.add((Number)totalNubmerOfWarnings, (Comparable)((Object)title), (Comparable)label);
            }
            graph.drawGraph(req, rsp, (DataSetBuilder<String, ChartUtil.NumberOnlyBuildLabel>)dsb, title);
        } else if (graphName.equals("loc")) {
            String title = "Lines Of Code";
            for (CodeSonarBuildAction codeSonarBuildAction = this; codeSonarBuildAction != null; codeSonarBuildAction = codeSonarBuildAction.getPreviousAction()) {
                Metrics metrics;
                CodeSonarBuildActionDTO prevBuildActionDTO = codeSonarBuildAction.getBuildActionDTO();
                if (prevBuildActionDTO == null || (metrics = prevBuildActionDTO.getMetrics()) == null) continue;
                Metric metric = metrics.getMetricByName("LCodeOnly");
                int value = Integer.parseInt(metric.getValue());
                label = new ChartUtil.NumberOnlyBuildLabel(codeSonarBuildAction.run);
                dsb.add((Number)value, (Comparable)((Object)title), (Comparable)label);
            }
            graph.drawGraph(req, rsp, (DataSetBuilder<String, ChartUtil.NumberOnlyBuildLabel>)dsb, title);
        }
    }

    public CodeSonarBuildAction getPreviousAction() {
        return this.getPreviousAction(this.run);
    }

    private CodeSonarBuildAction getPreviousAction(Run<?, ?> base) {
        CodeSonarBuildAction action = null;
        Run start = base;
        do {
            if ((start = start.getPreviousNotFailedBuild()) != null) continue;
            return null;
        } while ((action = (CodeSonarBuildAction)start.getAction(CodeSonarBuildAction.class)) == null);
        return action;
    }
}

