/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.hudson.plugins.folder.computed;

import com.cloudbees.hudson.plugins.folder.AbstractFolderDescriptor;
import com.cloudbees.hudson.plugins.folder.computed.ChildObserver;
import com.cloudbees.hudson.plugins.folder.computed.ComputedFolder;
import com.cloudbees.hudson.plugins.folder.computed.FolderComputation;
import com.cloudbees.hudson.plugins.folder.computed.ThrottleComputationQueueTaskDispatcher;
import hudson.model.Action;
import hudson.model.FreeStyleProject;
import hudson.model.ItemGroup;
import hudson.model.Queue;
import hudson.model.Result;
import hudson.model.TaskListener;
import hudson.model.TopLevelItem;
import hudson.model.queue.QueueTaskFuture;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Date;
import java.util.Random;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.jvnet.hudson.test.JenkinsRule;
import org.jvnet.hudson.test.TestExtension;

public class ThrottleComputationQueueTaskDispatcherTest {
    private static final Logger LOGGER = Logger.getLogger(ThrottleComputationQueueTaskDispatcherTest.class.getName());
    @ClassRule
    public static JenkinsRule r = new JenkinsRule();

    @Test
    public void acceptOne() throws Exception {
        SlowComputedFolder d = (SlowComputedFolder)ThrottleComputationQueueTaskDispatcherTest.r.jenkins.createProject(SlowComputedFolder.class, "acceptOne");
        d.recompute(Result.SUCCESS);
    }

    @Test
    public void acceptLimit() throws Exception {
        SlowComputedFolder[] d = new SlowComputedFolder[ThrottleComputationQueueTaskDispatcher.LIMIT];
        Queue.Item[] q = new Queue.Item[ThrottleComputationQueueTaskDispatcher.LIMIT];
        QueueTaskFuture[] f = new QueueTaskFuture[ThrottleComputationQueueTaskDispatcher.LIMIT];
        CountDownLatch finished = new CountDownLatch(1);
        CountDownLatch[] started = new CountDownLatch[ThrottleComputationQueueTaskDispatcher.LIMIT];
        for (int i = 0; i < d.length; ++i) {
            d[i] = (SlowComputedFolder)ThrottleComputationQueueTaskDispatcherTest.r.jenkins.createProject(SlowComputedFolder.class, "acceptLimit-" + i);
            d[i].started = started[i] = new CountDownLatch(1);
            d[i].finish = finished;
            q[i] = d[i].scheduleBuild2(0, new Action[0]);
            f[i] = q[i].getFuture();
        }
        Random entropy = new Random();
        long startNanoTime = System.nanoTime();
        Future maint = Queue.getInstance().scheduleMaintenance();
        long waitForConditionNanos = TimeUnit.SECONDS.toNanos(10L);
        while (System.nanoTime() - startNanoTime < waitForConditionNanos) {
            int startedCount = 0;
            int notStartedIndex = -1;
            for (int i = 0; i < started.length; ++i) {
                if (started[i].getCount() == 0L) {
                    ++startedCount;
                    continue;
                }
                if (notStartedIndex != -1 && !entropy.nextBoolean()) continue;
                notStartedIndex = i;
            }
            if (startedCount >= ThrottleComputationQueueTaskDispatcher.LIMIT) {
                MatcherAssert.assertThat((Object)startedCount, (Matcher)Matchers.is((Object)ThrottleComputationQueueTaskDispatcher.LIMIT));
                MatcherAssert.assertThat((Object)notStartedIndex, (Matcher)Matchers.is((Object)-1));
                break;
            }
            if (maint.isDone()) {
                maint = Queue.getInstance().scheduleMaintenance();
            }
            if (notStartedIndex != -1) {
                started[notStartedIndex].await(10L, TimeUnit.MILLISECONDS);
                continue;
            }
            maint.get(10L, TimeUnit.MILLISECONDS);
        }
        finished.countDown();
        for (int i = 0; i < f.length; ++i) {
            f[i].get();
            FolderComputation computation = d[i].getComputation();
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            computation.writeWholeLogTo((OutputStream)baos);
            String log = baos.toString();
            Assert.assertEquals((String)log, (Object)Result.SUCCESS, (Object)computation.getResult());
        }
    }

    @Test
    public void blockOneAboveLimit() throws Exception {
        SlowComputedFolder[] d = new SlowComputedFolder[ThrottleComputationQueueTaskDispatcher.LIMIT + 1];
        Queue.Item[] q = new Queue.Item[ThrottleComputationQueueTaskDispatcher.LIMIT + 1];
        QueueTaskFuture[] f = new QueueTaskFuture[ThrottleComputationQueueTaskDispatcher.LIMIT + 1];
        CountDownLatch finished = new CountDownLatch(1);
        CountDownLatch[] started = new CountDownLatch[ThrottleComputationQueueTaskDispatcher.LIMIT + 1];
        for (int i = 0; i < d.length; ++i) {
            d[i] = (SlowComputedFolder)ThrottleComputationQueueTaskDispatcherTest.r.jenkins.createProject(SlowComputedFolder.class, "blockOneAboveLimit-" + i);
            d[i].started = started[i] = new CountDownLatch(1);
            d[i].finish = finished;
            q[i] = d[i].scheduleBuild2(0, new Action[0]);
            f[i] = q[i].getFuture();
        }
        Random entropy = new Random();
        long startNanoTime = System.nanoTime();
        long maintNanoTime = System.nanoTime();
        Future maint = Queue.getInstance().scheduleMaintenance();
        long waitForConditionNanos = TimeUnit.SECONDS.toNanos(10L);
        while (System.nanoTime() - startNanoTime < waitForConditionNanos) {
            int startedCount = 0;
            int notStartedIndex = -1;
            for (int i = 0; i < started.length; ++i) {
                if (started[i].getCount() == 0L) {
                    ++startedCount;
                    continue;
                }
                if (notStartedIndex != -1 && !entropy.nextBoolean()) continue;
                notStartedIndex = i;
            }
            if (startedCount >= ThrottleComputationQueueTaskDispatcher.LIMIT) {
                MatcherAssert.assertThat((Object)startedCount, (Matcher)Matchers.is((Object)ThrottleComputationQueueTaskDispatcher.LIMIT));
                LOGGER.log(Level.INFO, "All {0} started", startedCount);
                MatcherAssert.assertThat((Object)notStartedIndex, (Matcher)Matchers.not((Matcher)Matchers.is((Object)-1)));
                MatcherAssert.assertThat((Object)q[notStartedIndex].getCauseOfBlockage(), (Matcher)Matchers.notNullValue());
                break;
            }
            if (maint.isDone() && maintNanoTime - System.nanoTime() > TimeUnit.MILLISECONDS.toNanos(500L)) {
                maint = Queue.getInstance().scheduleMaintenance();
            }
            if (notStartedIndex != -1) {
                started[notStartedIndex].await(10L, TimeUnit.MILLISECONDS);
                continue;
            }
            maint.get(10L, TimeUnit.MILLISECONDS);
        }
        finished.countDown();
        for (int i = 0; i < f.length; ++i) {
            f[i].get();
            FolderComputation computation = d[i].getComputation();
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            computation.writeWholeLogTo((OutputStream)baos);
            String log = baos.toString();
            Assert.assertEquals((String)log, (Object)Result.SUCCESS, (Object)computation.getResult());
        }
    }

    @Test
    public void blockManyAboveLimit() throws Exception {
        int i;
        int notStartedIndex;
        int startedCount;
        SlowComputedFolder[] d = new SlowComputedFolder[ThrottleComputationQueueTaskDispatcher.LIMIT * 2 - 1];
        Queue.Item[] q = new Queue.Item[ThrottleComputationQueueTaskDispatcher.LIMIT * 2 - 1];
        QueueTaskFuture[] f = new QueueTaskFuture[ThrottleComputationQueueTaskDispatcher.LIMIT * 2 - 1];
        CountDownLatch[] finished = new CountDownLatch[]{new CountDownLatch(1), new CountDownLatch(1)};
        CountDownLatch[] started = new CountDownLatch[ThrottleComputationQueueTaskDispatcher.LIMIT * 2 - 1];
        for (int i2 = 0; i2 < d.length; ++i2) {
            d[i2] = (SlowComputedFolder)ThrottleComputationQueueTaskDispatcherTest.r.jenkins.createProject(SlowComputedFolder.class, "blockManyAboveLimit-" + i2);
            d[i2].started = started[i2] = new CountDownLatch(1);
            d[i2].finish = finished[i2 / ThrottleComputationQueueTaskDispatcher.LIMIT];
            q[i2] = d[i2].scheduleBuild2(0, new Action[0]);
            f[i2] = q[i2].getFuture();
        }
        Random entropy = new Random();
        int expectedStartCount = ThrottleComputationQueueTaskDispatcher.LIMIT;
        long startNanoTime = System.nanoTime();
        long maintNanoTime = System.nanoTime();
        Future maint = Queue.getInstance().scheduleMaintenance();
        long waitForConditionNanos = TimeUnit.SECONDS.toNanos(10L);
        while (System.nanoTime() - startNanoTime < waitForConditionNanos) {
            startedCount = 0;
            notStartedIndex = -1;
            for (i = 0; i < started.length; ++i) {
                if (started[i].getCount() == 0L) {
                    ++startedCount;
                    continue;
                }
                if (notStartedIndex != -1 && !entropy.nextBoolean()) continue;
                notStartedIndex = i;
            }
            if (startedCount >= expectedStartCount) {
                MatcherAssert.assertThat((Object)startedCount, (Matcher)Matchers.is((Object)expectedStartCount));
                LOGGER.log(Level.INFO, "All {0} for tranch 1 started", startedCount);
                MatcherAssert.assertThat((Object)notStartedIndex, (Matcher)Matchers.not((Matcher)Matchers.is((Object)-1)));
                MatcherAssert.assertThat((Object)q[notStartedIndex].getCauseOfBlockage(), (Matcher)Matchers.notNullValue());
                break;
            }
            if (maint.isDone() && maintNanoTime - System.nanoTime() > TimeUnit.MILLISECONDS.toNanos(500L)) {
                maintNanoTime = System.nanoTime();
                maint = Queue.getInstance().scheduleMaintenance();
            }
            if (notStartedIndex != -1) {
                started[notStartedIndex].await(10L, TimeUnit.MILLISECONDS);
                continue;
            }
            maint.get(10L, TimeUnit.MILLISECONDS);
        }
        finished[0].countDown();
        expectedStartCount = ThrottleComputationQueueTaskDispatcher.LIMIT * 2 - 1;
        startNanoTime = System.nanoTime();
        maintNanoTime = System.nanoTime();
        maint = Queue.getInstance().scheduleMaintenance();
        waitForConditionNanos = TimeUnit.SECONDS.toNanos(10L);
        while (System.nanoTime() - startNanoTime < waitForConditionNanos) {
            startedCount = 0;
            notStartedIndex = -1;
            for (i = 0; i < started.length; ++i) {
                if (started[i].getCount() == 0L) {
                    ++startedCount;
                    continue;
                }
                if (notStartedIndex != -1 && !entropy.nextBoolean()) continue;
                notStartedIndex = i;
            }
            if (startedCount >= expectedStartCount) {
                MatcherAssert.assertThat((Object)startedCount, (Matcher)Matchers.is((Object)expectedStartCount));
                LOGGER.log(Level.INFO, "All {0} for tranches 1 and 2 started", startedCount);
                MatcherAssert.assertThat((Object)notStartedIndex, (Matcher)Matchers.is((Object)-1));
                break;
            }
            if (maint.isDone() && maintNanoTime - System.nanoTime() > TimeUnit.MILLISECONDS.toNanos(500L)) {
                maint = Queue.getInstance().scheduleMaintenance();
            }
            if (notStartedIndex != -1) {
                started[notStartedIndex].await(10L, TimeUnit.MILLISECONDS);
                continue;
            }
            maint.get(10L, TimeUnit.MILLISECONDS);
        }
        finished[1].countDown();
        for (int i3 = 0; i3 < f.length; ++i3) {
            f[i3].get();
            FolderComputation computation = d[i3].getComputation();
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            computation.writeWholeLogTo((OutputStream)baos);
            String log = baos.toString();
            Assert.assertEquals((String)log, (Object)Result.SUCCESS, (Object)computation.getResult());
        }
    }

    static String doRecompute(ComputedFolder<?> d, Result result) throws Exception {
        if (d.isDisabled()) {
            Assert.assertEquals((String)("Folder " + d.getFullName() + " is disabled"), (Object)result, (Object)Result.NOT_BUILT);
            return "DISABLED";
        }
        d.scheduleBuild2(0, new Action[0]).getFuture().get();
        FolderComputation computation = d.getComputation();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        computation.writeWholeLogTo((OutputStream)baos);
        String log = baos.toString();
        Assert.assertEquals((String)log, (Object)result, (Object)computation.getResult());
        return log;
    }

    public static class SlowComputedFolder
    extends ComputedFolder<FreeStyleProject> {
        private transient CountDownLatch started;
        private transient CountDownLatch finish;

        public SlowComputedFolder(ItemGroup parent, String name) {
            super(parent, name);
        }

        protected void computeChildren(ChildObserver<FreeStyleProject> observer, TaskListener listener) throws IOException, InterruptedException {
            LOGGER.log(Level.INFO, "Starting {0}", this.getFullName());
            try {
                if (this.started != null) {
                    this.started.countDown();
                }
                listener.getLogger().printf("[%tc] Started...%n", new Date());
                if (this.finish != null && !this.finish.await(60L, TimeUnit.SECONDS)) {
                    throw new IOException("Timeout");
                }
                listener.getLogger().printf("[%tc] Finished!%n", new Date());
            }
            finally {
                LOGGER.log(Level.INFO, "Finished {0}", this.getFullName());
            }
        }

        String recompute(Result result) throws Exception {
            return ThrottleComputationQueueTaskDispatcherTest.doRecompute(this, result);
        }

        @TestExtension
        public static class DescriptorImpl
        extends AbstractFolderDescriptor {
            public TopLevelItem newInstance(ItemGroup parent, String name) {
                return new SlowComputedFolder(parent, name);
            }
        }
    }
}

