/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.claim;

import hudson.model.Run;
import hudson.model.User;
import hudson.plugins.claim.AbstractClaimBuildAction;
import hudson.plugins.claim.ClaimEmailer;
import hudson.plugins.claim.ClaimTestDataPublisher;
import hudson.plugins.claim.Messages;
import hudson.tasks.junit.TestResultAction;
import hudson.tasks.test.TestResult;
import jakarta.mail.MessagingException;
import java.io.IOException;
import java.util.Date;
import java.util.Optional;
import jenkins.model.Jenkins;

public final class ClaimTestAction
extends AbstractClaimBuildAction<Run> {
    private String testObjectId;
    private ClaimTestDataPublisher.Data data;

    ClaimTestAction(ClaimTestDataPublisher.Data data, String testObjectId) {
        this.data = data;
        this.testObjectId = testObjectId;
    }

    public String getDisplayName() {
        return Messages.ClaimTestAction_DisplayName();
    }

    public boolean isColumnDisplayed() {
        return !this.isUserAnonymous() && this.data.isDisplayClaimActionsInTestResultsTable();
    }

    @Override
    protected void applyClaim(User claimedByUser, String providedReason, User assignedByUser, Date date, boolean isSticky, boolean isPropagated) {
        this.data.addClaim(this.testObjectId, this);
        super.applyClaim(claimedByUser, providedReason, assignedByUser, date, isSticky, isPropagated);
    }

    @Override
    protected Optional<AbstractClaimBuildAction> getNextAction() {
        TestResult testResult;
        TestResultAction action;
        Run nextRun = this.getOwner().getNextBuild();
        if (nextRun != null && (action = (TestResultAction)nextRun.getAction(TestResultAction.class)) != null && (testResult = action.getResult().findCorrespondingResult(this.testObjectId)) != null) {
            ClaimTestAction claimAction = (ClaimTestAction)((Object)testResult.getTestAction(ClaimTestAction.class));
            return Optional.ofNullable(claimAction);
        }
        return Optional.empty();
    }

    @Override
    public String getNoun() {
        return Messages.ClaimTestAction_Noun();
    }

    @Override
    String getUrl() {
        return this.data.getUrl() + "testReport/" + this.testObjectId;
    }

    @Override
    protected Run getOwner() {
        return this.data.getBuild();
    }

    @Override
    protected void sendInitialClaimEmail(User claimedByUser, String providedReason, User assignedByUser) throws MessagingException, IOException {
        ClaimEmailer.sendInitialTestClaimEmailIfConfigured(claimedByUser, assignedByUser, this.getOwner().toString(), providedReason, this.getUrl());
    }

    private String getJenkinsBaseUrl() {
        Jenkins instance = Jenkins.getInstance();
        if (instance != null) {
            return instance.getRootUrl();
        }
        return "";
    }

    public String getAbsoluteUrl() {
        String baseUrl = this.getJenkinsBaseUrl();
        String jobUrl = this.data.getUrl() + "testReport/" + (this.testObjectId.startsWith("junit/") ? this.testObjectId.substring(6) : this.testObjectId);
        return baseUrl + jobUrl + "/";
    }
}

