/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.build_timeout;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.DescriptorExtensionList;
import hudson.Extension;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Build;
import hudson.model.BuildListener;
import hudson.model.Descriptor;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.plugins.build_timeout.BuildTimeOutOperation;
import hudson.plugins.build_timeout.BuildTimeOutOperationDescriptor;
import hudson.plugins.build_timeout.BuildTimeOutStrategy;
import hudson.plugins.build_timeout.BuildTimeOutStrategyDescriptor;
import hudson.plugins.build_timeout.BuildTimeOutUtility;
import hudson.plugins.build_timeout.Messages;
import hudson.plugins.build_timeout.operations.AbortOperation;
import hudson.tasks.BuildStep;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Builder;
import hudson.triggers.SafeTimerTask;
import hudson.triggers.Trigger;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import jenkins.model.Jenkins;
import net.sf.json.JSONObject;
import org.jenkinsci.plugins.tokenmacro.MacroEvaluationException;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.StaplerRequest2;

public class BuildStepWithTimeout
extends Builder
implements BuildStep {
    private final BuildTimeOutStrategy strategy;
    private final BuildStep buildStep;
    private final List<BuildTimeOutOperation> operationList;

    @DataBoundConstructor
    public BuildStepWithTimeout(BuildStep buildStep, BuildTimeOutStrategy strategy, List<BuildTimeOutOperation> operationList) {
        this.strategy = strategy;
        this.buildStep = buildStep;
        this.operationList = operationList != null && !operationList.isEmpty() ? operationList : Collections.emptyList();
    }

    public List<BuildTimeOutOperation> getOperationList() {
        return this.operationList;
    }

    public BuildStep getBuildStep() {
        return this.buildStep;
    }

    private long getTimeout(Run run, TaskListener listener) throws IOException, InterruptedException {
        try {
            return this.strategy.getTimeOut((AbstractBuild)run, (BuildListener)listener);
        }
        catch (MacroEvaluationException e) {
            e.printStackTrace(listener.getLogger());
            listener.error("Can't evaluate timeout - timeout would be disabled");
            return Long.MAX_VALUE;
        }
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        return this.perform((Build)build, launcher, listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressFBWarnings(value={"NP_NULL_ON_SOME_PATH"}, justification="No adequate replacement for Trigger.timer found")
    public boolean perform(final Build<?, ?> build, Launcher launcher, final BuildListener listener) throws InterruptedException, IOException {
        Timer timer = Trigger.timer;
        final long delay = this.getTimeout((Run)build, (TaskListener)listener);
        SafeTimerTask task = new SafeTimerTask(this){
            final /* synthetic */ BuildStepWithTimeout this$0;
            {
                this.this$0 = this$0;
            }

            public void doRun() {
                if (this.this$0.operationList.isEmpty()) {
                    new AbortOperation().perform((AbstractBuild<?, ?>)build, listener, delay);
                }
                for (BuildTimeOutOperation op : this.this$0.operationList) {
                    op.perform((AbstractBuild<?, ?>)build, listener, delay);
                }
            }
        };
        try {
            timer.schedule((TimerTask)task, delay);
            boolean bl = this.buildStep.perform(build, launcher, listener);
            return bl;
        }
        finally {
            task.cancel();
        }
    }

    public BuildTimeOutStrategy getStrategy() {
        return this.strategy;
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return this.buildStep.getRequiredMonitorService();
    }

    @Extension
    public static class DescriptorImpl
    extends BuildStepDescriptor<Builder> {
        public BuildStepWithTimeout newInstance(StaplerRequest2 req, JSONObject formData) throws Descriptor.FormException {
            BuildStep buildstep = BuildTimeOutUtility.bindJSONWithDescriptor(req, formData, "buildStep", BuildStep.class);
            BuildTimeOutStrategy strategy = BuildTimeOutUtility.bindJSONWithDescriptor(req, formData, "strategy", BuildTimeOutStrategy.class);
            List operationList = DescriptorImpl.newInstancesFromHeteroList((StaplerRequest2)req, (JSONObject)formData, (String)"operationList", this.getOperations());
            return new BuildStepWithTimeout(buildstep, strategy, operationList);
        }

        public String getDisplayName() {
            return Messages.BuildStepWithTimeout_DisplayName();
        }

        public boolean isApplicable(Class<? extends AbstractProject> jobType) {
            return true;
        }

        public List<Descriptor<?>> getBuildStepWithTimeoutRunners() {
            ArrayList buildsteps = new ArrayList((Collection<Descriptor<?>>)Builder.all());
            buildsteps.remove((Object)this);
            return buildsteps;
        }

        public List<BuildTimeOutStrategyDescriptor> getStrategies() {
            DescriptorExtensionList descriptors = Jenkins.getActiveInstance().getDescriptorList(BuildTimeOutStrategy.class);
            ArrayList<BuildTimeOutStrategyDescriptor> supportedStrategies = new ArrayList<BuildTimeOutStrategyDescriptor>(descriptors.size());
            for (BuildTimeOutStrategyDescriptor descriptor : descriptors) {
                if (!descriptor.isApplicableAsBuildStep()) continue;
                supportedStrategies.add(descriptor);
            }
            return supportedStrategies;
        }

        public List<BuildTimeOutOperationDescriptor> getOperations(AbstractProject<?, ?> project) {
            return BuildTimeOutOperationDescriptor.all(project.getClass());
        }

        public List<BuildTimeOutOperationDescriptor> getOperations() {
            return BuildTimeOutOperationDescriptor.all();
        }
    }
}

