/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.build_timeout.impl;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.model.AbstractBuild;
import hudson.model.BuildListener;
import hudson.plugins.build_timeout.BuildTimeOutStrategy;
import hudson.plugins.build_timeout.BuildTimeOutStrategyDescriptor;
import hudson.plugins.build_timeout.BuildTimeoutWrapper;
import hudson.plugins.build_timeout.impl.Messages;
import java.io.IOException;
import java.util.StringJoiner;
import org.jenkinsci.plugins.tokenmacro.MacroEvaluationException;
import org.kohsuke.stapler.DataBoundConstructor;

public class NoActivityTimeOutStrategy
extends BuildTimeOutStrategy {
    @Deprecated
    private transient long timeout;
    private final String timeoutSecondsString;

    @Deprecated
    public long getTimeoutSeconds() {
        try {
            return Long.parseLong(this.timeoutSecondsString);
        }
        catch (NumberFormatException e) {
            return 0L;
        }
    }

    public String getTimeoutSecondsString() {
        return this.timeoutSecondsString;
    }

    private Object readResolve() {
        if (this.timeoutSecondsString == null) {
            return new NoActivityTimeOutStrategy(this.timeout / 1000L);
        }
        return this;
    }

    @DataBoundConstructor
    public NoActivityTimeOutStrategy(String timeoutSecondsString) {
        this.timeoutSecondsString = timeoutSecondsString;
    }

    @Deprecated
    public NoActivityTimeOutStrategy(long timeoutSeconds) {
        this(Long.toString(timeoutSeconds));
    }

    @Override
    public long getTimeOut(@NonNull AbstractBuild<?, ?> build, @NonNull BuildListener listener) throws InterruptedException, MacroEvaluationException, IOException {
        return Long.parseLong(this.expandAll(build, listener, this.getTimeoutSecondsString())) * 1000L;
    }

    @Override
    public void onWrite(AbstractBuild<?, ?> build, byte[] b, int length) {
        BuildTimeoutWrapper.EnvironmentImpl env = (BuildTimeoutWrapper.EnvironmentImpl)build.getEnvironments().get(BuildTimeoutWrapper.EnvironmentImpl.class);
        if (env != null) {
            env.rescheduleIfScheduled();
        }
    }

    public String toString() {
        return new StringJoiner(", ", NoActivityTimeOutStrategy.class.getSimpleName() + "[", "]").add("(deprecated)timeout=" + this.timeout).add("timeoutSecondsString='" + this.timeoutSecondsString + "'").toString();
    }

    @Extension
    public static class DescriptorImpl
    extends BuildTimeOutStrategyDescriptor {
        public String getDisplayName() {
            return Messages.NoActivityTimeOutStrategy_DisplayName();
        }
    }
}

