/*
 * Decompiled with CFR 0.152.
 */
package au.com.centrumsystems.hudson.plugin.buildpipeline.trigger;

import au.com.centrumsystems.hudson.plugin.util.ProjectUtil;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.DependencyGraph;
import hudson.model.Result;
import hudson.model.TaskListener;
import java.util.List;
import java.util.logging.Logger;

public class DownstreamDependency
extends DependencyGraph.Dependency {
    private static final Logger LOGGER = Logger.getLogger(DownstreamDependency.class.getName());

    public DownstreamDependency(AbstractProject<?, ?> upstream, AbstractProject<?, ?> downstream) {
        super(upstream, downstream);
    }

    public boolean shouldTriggerBuild(AbstractBuild build, TaskListener listener, List<Action> actions) {
        LOGGER.fine("Checking if build should be triggered.");
        if (ProjectUtil.isManualTrigger(build.getProject(), this.getDownstreamProject())) {
            LOGGER.fine("(shouldn't trigger: manual)");
            return false;
        }
        Result result = build.getResult();
        if (result == null) {
            throw new IllegalStateException("Build with a null result in DownstreamDependency#shouldTriggerBuilder");
        }
        if (result.isWorseThan(Result.SUCCESS)) {
            LOGGER.fine("(shouldn't trigger: unsuccessful build)");
            return false;
        }
        LOGGER.fine("(should trigger)");
        return true;
    }
}

