/*
 * Decompiled with CFR 0.152.
 */
package au.com.centrumsystems.hudson.plugin.buildpipeline.trigger;

import au.com.centrumsystems.hudson.plugin.buildpipeline.FormValidations;
import au.com.centrumsystems.hudson.plugin.buildpipeline.Strings;
import au.com.centrumsystems.hudson.plugin.buildpipeline.trigger.DownstreamDependency;
import hudson.Extension;
import hudson.Launcher;
import hudson.PluginWrapper;
import hudson.Util;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.BuildListener;
import hudson.model.DependecyDeclarer;
import hudson.model.DependencyGraph;
import hudson.model.Descriptor;
import hudson.model.Hudson;
import hudson.model.Item;
import hudson.model.ItemGroup;
import hudson.model.Items;
import hudson.model.Project;
import hudson.model.listeners.ItemListener;
import hudson.plugins.parameterizedtrigger.AbstractBuildParameters;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Notifier;
import hudson.tasks.Publisher;
import hudson.util.FormValidation;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;

public class BuildPipelineTrigger
extends Notifier
implements DependecyDeclarer {
    private static final Logger LOGGER = Logger.getLogger(BuildPipelineTrigger.class.getName());
    private final List<AbstractBuildParameters> configs;
    private String downstreamProjectNames;

    public String getDownstreamProjectNames() {
        return this.downstreamProjectNames;
    }

    public void setDownstreamProjectNames(String downstreamProjectNames) {
        this.downstreamProjectNames = downstreamProjectNames;
    }

    public List<AbstractBuildParameters> getConfigs() {
        return this.configs;
    }

    @DataBoundConstructor
    public BuildPipelineTrigger(String downstreamProjectNames, List<AbstractBuildParameters> configs) {
        if (downstreamProjectNames == null) {
            throw new IllegalArgumentException();
        }
        this.downstreamProjectNames = downstreamProjectNames;
        this.configs = new ArrayList<AbstractBuildParameters>(Util.fixNull(configs));
    }

    public void buildDependencyGraph(AbstractProject owner, DependencyGraph graph) {
        if (this.downstreamProjectNames != null && this.downstreamProjectNames.length() > 0) {
            for (Object o : Items.fromNameList((ItemGroup)owner.getParent(), (String)this.downstreamProjectNames, AbstractProject.class)) {
                AbstractProject downstream = (AbstractProject)o;
                if (owner != downstream) {
                    graph.addDependency((DependencyGraph.Dependency)this.createDownstreamDependency(owner, downstream));
                    continue;
                }
                this.removeDownstreamTrigger(this, owner, downstream.getName());
            }
        }
    }

    private DownstreamDependency createDownstreamDependency(AbstractProject<?, ?> owner, AbstractProject<?, ?> downstream) {
        return new DownstreamDependency(owner, downstream);
    }

    public boolean needsToRunAfterFinalized() {
        return true;
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.NONE;
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        return true;
    }

    public boolean onDownstreamProjectRenamed(String oldName, String newName) {
        LOGGER.fine(String.format("Renaming project %s -> %s", oldName, newName));
        boolean changed = false;
        String[] existingDownstreamProjects = new String[5];
        if (this.getDownstreamProjectNames() != null) {
            existingDownstreamProjects = this.getDownstreamProjectNames().split(",");
            for (int i = 0; i < existingDownstreamProjects.length; ++i) {
                if (!existingDownstreamProjects[i].trim().equals(oldName)) continue;
                existingDownstreamProjects[i] = newName;
                changed = true;
            }
        }
        if (changed) {
            StringBuilder newDownstreamProjects = new StringBuilder();
            for (int i = 0; i < existingDownstreamProjects.length; ++i) {
                if (existingDownstreamProjects[i] == null) continue;
                if (newDownstreamProjects.length() > 0) {
                    newDownstreamProjects.append(',');
                }
                newDownstreamProjects.append(existingDownstreamProjects[i].trim());
            }
            this.setDownstreamProjectNames(newDownstreamProjects.toString());
        }
        return changed;
    }

    public boolean onDownstreamProjectDeleted(String oldName) {
        LOGGER.fine("Downstram project deleted: " + oldName);
        return this.onDownstreamProjectRenamed(oldName, null);
    }

    public void removeDownstreamTrigger(BuildPipelineTrigger bpTrigger, AbstractProject<?, ?> ownerProject, String downstreamProjectName) {
        if (bpTrigger != null) {
            boolean changed = false;
            if (bpTrigger.onDownstreamProjectDeleted(downstreamProjectName)) {
                changed = true;
            }
            if (changed) {
                try {
                    if (bpTrigger.getDownstreamProjectNames().length() == 0) {
                        ownerProject.getPublishersList().remove((Object)bpTrigger);
                    }
                    ownerProject.save();
                }
                catch (IOException e) {
                    Logger.getLogger(BuildPipelineTrigger.class.getName()).log(Level.SEVERE, Strings.getString("BuildPipelineTrigger.FailedPersistDuringRemoval") + downstreamProjectName, e);
                }
            }
        }
    }

    @Extension
    public static class DescriptorImpl
    extends BuildStepDescriptor<Publisher> {
        public boolean canAddParameters() {
            PluginWrapper plugin = Hudson.getInstance().getPluginManager().getPlugin("parameterized-trigger");
            return plugin != null && plugin.isActive();
        }

        public boolean isApplicable(Class<? extends AbstractProject> jobType) {
            return true;
        }

        public String getDisplayName() {
            return Strings.getString("BuildPipelineTrigger.DisplayText");
        }

        public String getHelpFile() {
            String filePath = "/descriptor/au.com.centrumsystems.hudson.plugin.buildpipeline.trigger.BuildPipelineTrigger/help";
            String fileName = "buildPipeline.html";
            return String.format("%s/%s", "/descriptor/au.com.centrumsystems.hudson.plugin.buildpipeline.trigger.BuildPipelineTrigger/help", "buildPipeline.html");
        }

        public FormValidation doCheckDownstreamProjectNames(@AncestorInPath AbstractProject project, @QueryParameter(value="downstreamProjectNames") String value) {
            StringTokenizer tokens = new StringTokenizer(Util.fixNull((String)value), ",");
            boolean some = false;
            while (tokens.hasMoreTokens()) {
                String projectName = tokens.nextToken().trim();
                if ("".equals(projectName)) continue;
                some = true;
                Item item = Jenkins.getInstance().getItemByFullName(projectName);
                if (item == null) {
                    String nearestProjectName = AbstractProject.findNearest((String)projectName, (ItemGroup)project.getParent()).getRelativeNameFrom((Item)project);
                    return FormValidations.noSuchProject(projectName, nearestProjectName);
                }
                if (item instanceof AbstractProject) continue;
                return FormValidations.notBuildable(projectName);
            }
            if (!some) {
                return FormValidations.noProjectSpecified();
            }
            return FormValidation.ok();
        }

        public List<Descriptor<AbstractBuildParameters>> getBuilderConfigDescriptors() {
            return Hudson.getInstance().getDescriptorList(AbstractBuildParameters.class);
        }

        @Extension
        public static final class ItemListenerImpl
        extends ItemListener {
            public void onRenamed(Item item, String oldName, String newName) {
                for (Project p : Jenkins.getInstance().getAllItems(Project.class)) {
                    BuildPipelineTrigger bpTrigger = (BuildPipelineTrigger)p.getPublishersList().get(BuildPipelineTrigger.class);
                    if (bpTrigger == null) continue;
                    boolean changed = false;
                    changed = bpTrigger.onDownstreamProjectRenamed(oldName, newName);
                    if (!changed) continue;
                    try {
                        p.save();
                    }
                    catch (IOException e) {
                        Logger.getLogger(ItemListenerImpl.class.getName()).log(Level.SEVERE, String.format(Strings.getString("BuildPipelineTrigger.FailedPersistDuringRename_FMT"), oldName, newName), e);
                    }
                }
            }

            public void onDeleted(Item item) {
                for (Project p : Jenkins.getInstance().getAllItems(Project.class)) {
                    String oldName = item.getName();
                    BuildPipelineTrigger bpTrigger = (BuildPipelineTrigger)p.getPublishersList().get(BuildPipelineTrigger.class);
                    if (bpTrigger == null) continue;
                    bpTrigger.removeDownstreamTrigger(bpTrigger, (AbstractProject<?, ?>)p, oldName);
                }
            }
        }
    }
}

