/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.androidsigning;

import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import hudson.AbortException;
import hudson.EnvVars;
import hudson.FilePath;
import hudson.Launcher;
import hudson.util.ArgumentListBuilder;
import hudson.util.VersionNumber;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.plugins.androidsigning.GetPathSeparator;

class ZipalignTool {
    static final String ENV_ANDROID_HOME = "ANDROID_HOME";
    static final String ENV_ZIPALIGN_PATH = "ANDROID_ZIPALIGN";
    static final String ENV_PATH = "PATH";
    private final Launcher launcher;
    private final EnvVars buildEnv;
    private final FilePath workspace;
    private final PrintStream logger;
    private final String overrideAndroidHome;
    private final String overrideZipalignPath;
    private final ByteArrayOutputStream outStream;
    private FilePath zipalign;

    private FilePath findFromEnv(EnvVars env, FilePath workspace, PrintStream logger) throws AbortException {
        String zipalignPath = (String)env.get((Object)ENV_ZIPALIGN_PATH);
        if (!StringUtils.isEmpty((String)zipalignPath)) {
            zipalignPath = env.expand(zipalignPath);
            logger.printf("[SignApksBuilder] found zipalign path in env %s=%s%n", ENV_ZIPALIGN_PATH, zipalignPath);
            FilePath zipalign = new FilePath(workspace.getChannel(), zipalignPath);
            return this.zipalignOrZipalignExe(zipalign, logger);
        }
        String androidHome = (String)env.get((Object)ENV_ANDROID_HOME);
        if (!StringUtils.isEmpty((String)androidHome)) {
            androidHome = env.expand(androidHome);
            logger.printf("[SignApksBuilder] searching environment variable %s=%s for zipalign...%n", ENV_ANDROID_HOME, androidHome);
            return this.findInAndroidHome(androidHome, workspace, logger);
        }
        String envPath = (String)env.get((Object)ENV_PATH);
        if (!StringUtils.isEmpty((String)envPath)) {
            envPath = env.expand(envPath);
            logger.printf("[SignApksBuilder] searching environment %s=%s for zipalign...%n", ENV_PATH, envPath);
            return this.findInPathEnvVar(envPath, workspace, logger);
        }
        throw new AbortException("failed to find zipalign: no environment variable ANDROID_ZIPALIGN or ANDROID_HOME or PATH");
    }

    private FilePath findInAndroidHome(String androidHome, FilePath workspace, PrintStream logger) throws AbortException {
        List<FilePath> versionDirs;
        FilePath buildTools = workspace.child(androidHome).child("build-tools");
        try {
            versionDirs = this.listDirectoriesWithLauncher(buildTools, logger);
        }
        catch (Exception e) {
            e.printStackTrace(logger);
            throw new AbortException(String.format("failed to find zipalign: error listing build-tools versions in %s: %s", buildTools.getRemote(), e.getLocalizedMessage()));
        }
        if (versionDirs == null || versionDirs.isEmpty()) {
            throw new AbortException("failed to find zipalign: no build-tools directory in Android home path " + androidHome);
        }
        TreeMap<VersionNumber, FilePath> versions = new TreeMap<VersionNumber, FilePath>();
        for (FilePath versionDir : versionDirs) {
            String versionName = versionDir.getName();
            VersionNumber version = new VersionNumber(versionName);
            versions.put(version, versionDir);
        }
        if (versions.isEmpty()) {
            throw new AbortException("failed to find zipalign: no build-tools versions in Android home path " + String.valueOf(buildTools));
        }
        VersionNumber latest = (VersionNumber)versions.lastKey();
        buildTools = (FilePath)versions.get(latest);
        FilePath zipalign = this.zipalignOrZipalignExe(buildTools, logger);
        if (zipalign != null) {
            logger.printf("[SignApksBuilder] found zipalign in Android SDK's latest build tools: %s%n", zipalign.getRemote());
            return zipalign;
        }
        throw new AbortException("failed to find zipalign: no zipalign found in latest Android build tools: " + String.valueOf(buildTools));
    }

    private FilePath findInPathEnvVar(String envPath, FilePath workspace, PrintStream logger) throws AbortException {
        String[] dirs;
        String separator = null;
        try {
            separator = ZipalignTool.pathSeparatorForWorkspace(workspace);
        }
        catch (Exception e) {
            logger.println("[SignApksBuilder] error determining path separator:");
            e.printStackTrace(logger);
            return null;
        }
        for (String dir : dirs = envPath.split(separator)) {
            FilePath dirPath = workspace.child(dir);
            logger.printf("[SignApksBuilder] checking %s dir %s for zipalign...%n", ENV_PATH, dirPath.getRemote());
            FilePath zipalign = this.zipalignOrZipalignExe(dirPath, logger);
            if (zipalign != null) {
                return zipalign;
            }
            try {
                dirPath = this.androidHomeAncestorOfPath(dirPath, logger);
            }
            catch (Exception e) {
                logger.println("error searching PATH environment variable: " + e.getMessage());
                e.printStackTrace(logger);
            }
            if (dirPath == null) continue;
            logger.printf("[SignApksBuilder] found potential Android home in %s dir %s%n", ENV_PATH, dir);
            try {
                return this.findInAndroidHome(dirPath.getRemote(), workspace, logger);
            }
            catch (AbortException e) {
                logger.printf("error searching Android home found in PATH: " + e.getMessage(), new Object[0]);
            }
        }
        return null;
    }

    private static String pathSeparatorForWorkspace(FilePath workspace) throws IOException, InterruptedException {
        return (String)workspace.act((FilePath.FileCallable)new GetPathSeparator());
    }

    private FilePath androidHomeAncestorOfPath(FilePath path, PrintStream logger) throws Exception {
        if ("bin".equals(path.getName())) {
            FilePath sdkmanager = path.child("sdkmanager");
            if (this.commandOrWinCommandAtPath(sdkmanager, logger) != null && (path = path.getParent()) != null && "tools".equals(path.getName())) {
                return path.getParent();
            }
        } else if ("tools".equals(path.getName())) {
            FilePath androidTool = path.child("android");
            if (this.commandOrWinCommandAtPath(androidTool, logger) != null) {
                return path.getParent();
            }
        } else {
            FilePath androidTool = path.child("tools").child("android");
            if (this.commandOrWinCommandAtPath(androidTool, logger) != null) {
                return path;
            }
        }
        return null;
    }

    private FilePath zipalignOrZipalignExe(FilePath zipalignOrDir, PrintStream logger) {
        FilePath parent = zipalignOrDir.getParent();
        try {
            if (this.isDirectoryWithLauncher(zipalignOrDir, logger)) {
                parent = zipalignOrDir;
                zipalignOrDir = zipalignOrDir.child("zipalign");
            }
        }
        catch (Exception e) {
            logger.println("[SignApksBuilder] error checking for zipalign at path " + String.valueOf(zipalignOrDir));
            e.printStackTrace(logger);
        }
        zipalignOrDir = this.commandOrWinCommandAtPath(zipalignOrDir, logger);
        if (zipalignOrDir != null) {
            return zipalignOrDir;
        }
        logger.println("[SignApksBuilder] no zipalign or zipalign.exe found in path " + String.valueOf(parent));
        return null;
    }

    private List<FilePath> listDirectoriesWithLauncher(FilePath parentPath, PrintStream logger) throws IOException, InterruptedException {
        ArgumentListBuilder cmds = new ArgumentListBuilder();
        Launcher decorated = this.launcher.decorateByEnv(this.buildEnv);
        if (this.launcher.isUnix()) {
            cmds.add(new String[]{"find", parentPath.getRemote(), "-mindepth", "1", "-type", "d"});
        } else {
            cmds.add(new String[]{"dir", "/c", "/s", "/ad", "/b", parentPath.getRemote()});
            cmds = cmds.toWindowsCommand();
        }
        int exitCode = decorated.launch().cmds(cmds).pwd(this.workspace).stdout((OutputStream)this.outStream).stderr((OutputStream)logger).quiet(true).join();
        if (exitCode != 0) {
            return new ArrayList<FilePath>();
        }
        String result = this.outStream.toString(Charset.defaultCharset()).trim();
        logger.println("[SignApksBuilder] Directories " + this.outStream.toString(Charset.defaultCharset()));
        if (result.isEmpty()) {
            return new ArrayList<FilePath>();
        }
        return Arrays.stream(result.split("\\R")).filter(p -> !p.trim().isEmpty()).map(p -> new FilePath(parentPath, p)).collect(Collectors.toList());
    }

    private boolean isDirectoryWithLauncher(FilePath filePath, PrintStream logger) throws IOException, InterruptedException {
        ArgumentListBuilder cmds = new ArgumentListBuilder();
        Launcher decorated = this.launcher.decorateByEnv(this.buildEnv);
        if (this.launcher.isUnix()) {
            cmds.add(new String[]{"test", "-d", filePath.getRemote()});
        } else {
            cmds.add(new String[]{"dir", "/c", "/ad", "/b", filePath.getRemote()});
            cmds = cmds.toWindowsCommand();
        }
        int exitCode = decorated.launch().cmds(cmds).pwd(this.workspace).stdout((OutputStream)this.outStream).stderr((OutputStream)logger).quiet(true).join();
        if (exitCode == 0) {
            logger.printf("[SignApksBuilder] is Directory %s%n", this.outStream.toString(Charset.defaultCharset()));
        }
        return exitCode == 0;
    }

    private boolean fileExistsWithLauncher(FilePath filePath, PrintStream logger) throws IOException, InterruptedException {
        ArgumentListBuilder cmds = new ArgumentListBuilder();
        Launcher decorated = this.launcher.decorateByEnv(this.buildEnv);
        if (this.launcher.isUnix()) {
            cmds.add(new String[]{"test", "-f", filePath.getRemote()});
        } else {
            cmds.add(new String[]{"dir", "/a-d", "/b", filePath.getRemote()});
            cmds = cmds.toWindowsCommand();
        }
        int exitCode = decorated.launch().cmds(cmds).pwd(this.workspace).stdout((OutputStream)this.outStream).stderr((OutputStream)logger).quiet(true).join();
        String result = this.outStream.toString(Charset.defaultCharset());
        if (exitCode == 0) {
            logger.printf("[SignApksBuilder] is File %s%n", result);
        }
        return exitCode == 0;
    }

    private FilePath commandOrWinCommandAtPath(FilePath path, PrintStream logger) {
        try {
            if (this.isDirectoryWithLauncher(path, logger)) {
                return null;
            }
            if (this.fileExistsWithLauncher(path, logger)) {
                return path;
            }
            FilePath parent = path.getParent();
            if (parent == null) {
                return null;
            }
            if (!this.isDirectoryWithLauncher(parent, logger)) {
                return null;
            }
            String name = path.getName();
            String winCommand = name + ".exe";
            if (this.fileExistsWithLauncher(path = parent.child(winCommand), logger)) {
                return path;
            }
            winCommand = name + ".bat";
            path = parent.child(winCommand);
            if (this.fileExistsWithLauncher(path, logger)) {
                return path;
            }
        }
        catch (Exception e) {
            logger.println("[SignApksBuilder] error checking path " + String.valueOf(path));
            e.printStackTrace(logger);
        }
        return null;
    }

    ZipalignTool(@NonNull Launcher launcher, @NonNull ByteArrayOutputStream outStream, @NonNull EnvVars buildEnv, @NonNull FilePath workspace, @NonNull PrintStream logger, @Nullable String overrideAndroidHome, @Nullable String overrideZipalignPath) {
        this.launcher = launcher;
        this.buildEnv = buildEnv;
        this.workspace = workspace;
        this.logger = logger;
        this.outStream = outStream;
        this.overrideAndroidHome = overrideAndroidHome;
        this.overrideZipalignPath = overrideZipalignPath;
    }

    ArgumentListBuilder commandFor(String unsignedApk, String outputApk) throws AbortException {
        if (this.zipalign == null) {
            if (!StringUtils.isEmpty((String)this.overrideZipalignPath)) {
                this.logger.printf("[SignApksBuilder] zipalign path explicitly set to %s%n", this.overrideZipalignPath);
                this.zipalign = this.zipalignOrZipalignExe(this.workspace.child(this.buildEnv.expand(this.overrideZipalignPath)), this.logger);
            } else if (!StringUtils.isEmpty((String)this.overrideAndroidHome)) {
                this.logger.printf("[SignApksBuilder] zipalign %s explicitly set to %s%n", ENV_ANDROID_HOME, this.overrideAndroidHome);
                String expandedAndroidHome = this.buildEnv.expand(this.overrideAndroidHome);
                this.zipalign = this.findInAndroidHome(expandedAndroidHome, this.workspace, this.logger);
            } else {
                this.zipalign = this.findFromEnv(this.buildEnv, this.workspace, this.logger);
            }
            if (this.zipalign == null) {
                throw new AbortException("failed to find zipalign path in parameters or environment");
            }
        }
        return new ArgumentListBuilder().add(this.zipalign.getRemote()).add("-P").add("16").add("-f").add("4").add(unsignedApk).add(outputApk);
    }
}

