/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.ParameterizedRemoteTrigger.utils;

import hudson.FilePath;
import hudson.model.TaskListener;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;
import org.jenkinsci.plugins.ParameterizedRemoteTrigger.BasicBuildContext;
import org.jenkinsci.plugins.tokenmacro.MacroEvaluationException;
import org.jenkinsci.plugins.tokenmacro.TokenMacro;

public class TokenMacroUtils {
    public static String applyTokenMacroReplacements(String input, BasicBuildContext context) throws IOException {
        try {
            if (TokenMacroUtils.isUseTokenMacro(context)) {
                return TokenMacro.expandAll(context.run, (FilePath)context.workspace, (TaskListener)context.listener, (String)input);
            }
        }
        catch (MacroEvaluationException e) {
            throw new IOException(e);
        }
        catch (InterruptedException e) {
            throw new IOException(e);
        }
        return input;
    }

    public static Map<String, String> applyTokenMacroReplacements(Map<String, String> input, BasicBuildContext context) throws IOException {
        LinkedHashMap<String, String> output = new LinkedHashMap<String, String>();
        for (Map.Entry<String, String> entry : input.entrySet()) {
            output.put(entry.getKey(), TokenMacroUtils.applyTokenMacroReplacements(entry.getValue(), context));
        }
        return output;
    }

    public static boolean isUseTokenMacro(BasicBuildContext context) {
        return context != null && context.run != null && context.workspace != null && context.listener != null;
    }
}

