/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.ParameterizedRemoteTrigger.utils;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.AbortException;
import hudson.ProxyConfiguration;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.text.SimpleDateFormat;
import java.time.Duration;
import java.time.Instant;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.TrustManager;
import net.sf.json.JSONException;
import net.sf.json.JSONObject;
import net.sf.json.JSONSerializer;
import net.sf.json.util.JSONUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.plugins.ParameterizedRemoteTrigger.BuildContext;
import org.jenkinsci.plugins.ParameterizedRemoteTrigger.ConnectionResponse;
import org.jenkinsci.plugins.ParameterizedRemoteTrigger.JenkinsCrumb;
import org.jenkinsci.plugins.ParameterizedRemoteTrigger.RemoteJenkinsServer;
import org.jenkinsci.plugins.ParameterizedRemoteTrigger.auth2.Auth2;
import org.jenkinsci.plugins.ParameterizedRemoteTrigger.auth2.NullAuth;
import org.jenkinsci.plugins.ParameterizedRemoteTrigger.exceptions.ExceedRetryLimitException;
import org.jenkinsci.plugins.ParameterizedRemoteTrigger.exceptions.ForbiddenException;
import org.jenkinsci.plugins.ParameterizedRemoteTrigger.exceptions.UnauthorizedException;
import org.jenkinsci.plugins.ParameterizedRemoteTrigger.exceptions.UrlNotFoundException;
import org.jenkinsci.plugins.ParameterizedRemoteTrigger.utils.DropCachePeriodicWork;
import org.jenkinsci.plugins.ParameterizedRemoteTrigger.utils.FormValidationUtils;
import org.jenkinsci.plugins.ParameterizedRemoteTrigger.utils.NaiveTrustManager;
import org.jenkinsci.plugins.ParameterizedRemoteTrigger.utils.OtelUtils;
import org.jenkinsci.plugins.ParameterizedRemoteTrigger.utils.StringTools;

public class HttpHelper {
    private static final String paramerizedBuildUrl = "/buildWithParameters";
    private static final String normalBuildUrl = "/build";
    private static final String buildTokenRootUrl = "/buildByToken";
    public static final String HTTP_GET = "GET";
    public static final String HTTP_POST = "POST";
    private static Logger logger = Logger.getLogger(HttpHelper.class.getName());

    private static String addToQueryString(String queryString, String item) {
        if (StringUtils.isBlank((String)queryString)) {
            return item;
        }
        return queryString + "&" + item;
    }

    public static String buildUrlQueryString(@NonNull Map<String, String> parameters) {
        return parameters.entrySet().stream().map(entry -> String.format("%s=%s", HttpHelper.encodeValue((String)entry.getKey()), HttpHelper.encodeValue((String)entry.getValue()))).collect(Collectors.joining("&"));
    }

    private static String getBuildTypeUrl(boolean isRemoteJobParameterized, @NonNull Map<String, String> params) {
        boolean isParameterized;
        boolean bl = isParameterized = isRemoteJobParameterized || params.size() > 0;
        if (isParameterized) {
            return paramerizedBuildUrl;
        }
        return normalBuildUrl;
    }

    protected static String generateJobUrl(RemoteJenkinsServer remoteServer, String jobNameOrUrl) throws AbortException {
        String remoteJobUrl;
        if (StringUtils.isEmpty((String)jobNameOrUrl)) {
            throw new IllegalArgumentException("Invalid job name/url: " + jobNameOrUrl);
        }
        String _jobNameOrUrl = jobNameOrUrl.trim();
        if (FormValidationUtils.isURL(_jobNameOrUrl)) {
            remoteJobUrl = _jobNameOrUrl;
        } else {
            String[] split;
            remoteJobUrl = remoteServer.getAddress();
            if (remoteJobUrl == null) {
                throw new AbortException("The remote server address can not be empty, or it must be overridden on the job configuration.");
            }
            while (remoteJobUrl.endsWith("/")) {
                remoteJobUrl = remoteJobUrl.substring(0, remoteJobUrl.length() - 1);
            }
            for (String segment : split = _jobNameOrUrl.trim().split("/")) {
                remoteJobUrl = String.format("%s/job/%s", remoteJobUrl, HttpHelper.encodeValue(segment));
            }
        }
        return remoteJobUrl;
    }

    public static String encodeValue(String dirtyValue) {
        String cleanValue = "";
        try {
            cleanValue = URLEncoder.encode(dirtyValue, "UTF-8").replace("+", "%20");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return cleanValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String readInputStream(HttpURLConnection connection) throws IOException {
        String string;
        BufferedReader rd = null;
        try {
            String line;
            InputStream is;
            try {
                is = connection.getInputStream();
            }
            catch (FileNotFoundException e) {
                is = connection.getErrorStream();
            }
            rd = new BufferedReader(new InputStreamReader(is, StandardCharsets.UTF_8));
            StringBuilder response = new StringBuilder();
            while ((line = rd.readLine()) != null) {
                if (response.length() > 0) {
                    response.append(StringTools.NL);
                }
                response.append(line);
            }
            string = response.toString();
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(rd);
            throw throwable;
        }
        IOUtils.closeQuietly((Reader)rd);
        return string;
    }

    @NonNull
    private static JenkinsCrumb getCrumb(BuildContext context, Auth2 overrideAuth, boolean isCacheEnabled) throws IOException {
        String address = context.effectiveRemoteServer.getAddress();
        if (address == null) {
            throw new AbortException("The remote server address can not be empty, or it must be overridden on the job configuration.");
        }
        String globalHost = "";
        try {
            String xpathValue = URLEncoder.encode("concat(//crumbRequestField,\":\",//crumb)", "UTF-8");
            URL crumbProviderUrl = new URL(address.concat("/crumbIssuer/api/xml?xpath=").concat(xpathValue));
            globalHost = crumbProviderUrl.getHost();
            JenkinsCrumb jenkinsCrumb = DropCachePeriodicWork.safeGetCrumb(globalHost, isCacheEnabled);
            if (jenkinsCrumb != null) {
                context.logger.println("reuse cached crumb: " + globalHost);
                return jenkinsCrumb;
            }
            HttpURLConnection connection = (HttpURLConnection)HttpHelper.getAuthorizedConnection(context, crumbProviderUrl, overrideAuth);
            int responseCode = connection.getResponseCode();
            if (responseCode == 401) {
                throw new UnauthorizedException(crumbProviderUrl);
            }
            if (responseCode == 403) {
                throw new ForbiddenException(crumbProviderUrl);
            }
            if (responseCode == 404) {
                context.logger.println("CSRF protection is disabled on the remote server.");
                return DropCachePeriodicWork.safePutCrumb(globalHost, new JenkinsCrumb(), isCacheEnabled);
            }
            if (responseCode == 200) {
                context.logger.println("CSRF protection is enabled on the remote server.");
                String response = HttpHelper.readInputStream(connection);
                String[] split = response.split(":");
                JenkinsCrumb crumb = new JenkinsCrumb(split[0], split[1]);
                return DropCachePeriodicWork.safePutCrumb(globalHost, crumb, isCacheEnabled);
            }
            throw new RuntimeException(String.format("Unexpected response. Response code: %s. Response message: %s", responseCode, connection.getResponseMessage()));
        }
        catch (FileNotFoundException e) {
            context.logger.println("CSRF protection is disabled on the remote server.");
            return DropCachePeriodicWork.safePutCrumb(globalHost, new JenkinsCrumb(), isCacheEnabled);
        }
    }

    private static void addCrumbToConnection(HttpURLConnection connection, BuildContext context, Auth2 overrideAuth, boolean isCacheEnabled) throws IOException {
        JenkinsCrumb crumb;
        String method = connection.getRequestMethod();
        if (method != null && method.equalsIgnoreCase(HTTP_POST) && (crumb = HttpHelper.getCrumb(context, overrideAuth, isCacheEnabled)).isEnabledOnRemote()) {
            connection.setRequestProperty(crumb.getHeaderId(), crumb.getCrumbValue());
        }
    }

    private static URLConnection getAuthorizedConnection(BuildContext context, URL url, Auth2 overrideAuth) throws IOException {
        URLConnection connection = context.effectiveRemoteServer.isUseProxy() ? ProxyConfiguration.open((URL)url) : url.openConnection();
        Auth2 serverAuth = context.effectiveRemoteServer.getAuth2();
        if (overrideAuth != null && !(overrideAuth instanceof NullAuth)) {
            overrideAuth.setAuthorizationHeader(connection, context);
        } else if (serverAuth != null) {
            serverAuth.setAuthorizationHeader(connection, context);
        }
        if (connection instanceof HttpsURLConnection) {
            HttpsURLConnection conn = (HttpsURLConnection)connection;
            if (context.effectiveRemoteServer.getTrustAllCertificates()) {
                try {
                    SSLContext ctx = SSLContext.getInstance("TLS");
                    ctx.init(new KeyManager[0], new TrustManager[]{new NaiveTrustManager()}, new SecureRandom());
                    conn.setSSLSocketFactory(ctx.getSocketFactory());
                    HostnameVerifier allHostsValid = (hostname, session) -> true;
                    conn.setHostnameVerifier(allHostsValid);
                }
                catch (KeyManagementException | NoSuchAlgorithmException e) {
                    context.logger.println("Unable to trust all certificates.");
                }
            }
            return conn;
        }
        return connection;
    }

    private static String getUrlWithoutParameters(String url) {
        String result = url;
        try {
            URI uri = new URI(url);
            result = new URI(uri.getScheme(), uri.getAuthority(), uri.getPath(), null, uri.getFragment()).toString();
        }
        catch (URISyntaxException e) {
            logger.log(Level.WARNING, e.getMessage(), e);
        }
        return result;
    }

    public static String buildTriggerUrl(String jobNameOrUrl, String securityToken, boolean isRemoteJobParameterized, BuildContext context) throws IOException {
        Object triggerUrlString;
        String query = "";
        if (context.effectiveRemoteServer.getHasBuildTokenRootSupport()) {
            if (context.effectiveRemoteServer.getAddress() == null) {
                throw new AbortException("The remote server address can not be empty, or it must be overridden on the job configuration.");
            }
            triggerUrlString = context.effectiveRemoteServer.getAddress();
            triggerUrlString = (String)triggerUrlString + buildTokenRootUrl;
            triggerUrlString = (String)triggerUrlString + HttpHelper.getBuildTypeUrl(isRemoteJobParameterized, Collections.emptyMap());
            query = HttpHelper.addToQueryString(query, "job=" + HttpHelper.encodeValue(jobNameOrUrl));
        } else {
            triggerUrlString = HttpHelper.generateJobUrl(context.effectiveRemoteServer, jobNameOrUrl);
            triggerUrlString = (String)triggerUrlString + HttpHelper.getBuildTypeUrl(isRemoteJobParameterized, Collections.emptyMap());
        }
        if (!securityToken.equals("")) {
            query = HttpHelper.addToQueryString(query, "token=" + HttpHelper.encodeValue(securityToken));
        }
        query = HttpHelper.addToQueryString(query, "delay=0");
        triggerUrlString = (String)triggerUrlString + "?" + query;
        return triggerUrlString;
    }

    private static ConnectionResponse sendHTTPCall(String urlString, String requestType, BuildContext context, Map<String, String> postParams, int readTimeout, int numberOfAttempts, int pollInterval, int retryLimit, Auth2 overrideAuth, StringBuilder rawRespRef, boolean isCrubmCacheEnabled) throws IOException, InterruptedException {
        JSONObject responseObject = null;
        Map<String, List<String>> responseHeader = null;
        int responseCode = 0;
        byte[] postDataBytes = new byte[]{};
        String parmsString = "";
        if (HTTP_POST.equalsIgnoreCase(requestType) && postParams != null && postParams.size() > 0) {
            parmsString = HttpHelper.buildUrlQueryString(postParams);
            postDataBytes = parmsString.getBytes(StandardCharsets.UTF_8);
        }
        URL url = new URL(urlString);
        HttpURLConnection conn = (HttpURLConnection)HttpHelper.getAuthorizedConnection(context, url, overrideAuth);
        try {
            conn.setDoInput(true);
            conn.setRequestProperty("Accept", "application/json");
            conn.setRequestProperty("Accept-Language", "UTF-8");
            if (requestType.equals(HTTP_POST) && OtelUtils.isOpenTelemetryAvailable()) {
                String traceParentHeader = OtelUtils.getTraceParent();
                if (StringUtils.isNotBlank((String)OtelUtils.getTraceParent())) {
                    conn.setRequestProperty("traceparent", traceParentHeader);
                }
            }
            conn.setRequestMethod(requestType);
            conn.setReadTimeout(readTimeout);
            HttpHelper.addCrumbToConnection(conn, context, overrideAuth, isCrubmCacheEnabled);
            conn.setConnectTimeout(5000);
            if (HTTP_POST.equalsIgnoreCase(requestType)) {
                conn.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
                conn.setRequestProperty("Content-Length", String.valueOf(postDataBytes.length));
                conn.setDoOutput(true);
                conn.getOutputStream().write(postDataBytes);
            }
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
            logger.finer(String.format("%s begin: %s", urlString, sdf.format(new Date())));
            Instant before = Instant.now();
            conn.connect();
            Instant after = Instant.now();
            logger.finer(String.format("%s end: elapsed [%s] ms", urlString, Duration.between(before, after).toMillis()));
            responseHeader = conn.getHeaderFields();
            if (HTTP_POST.equalsIgnoreCase(requestType)) {
                retryLimit = -1;
            }
            if ((responseCode = conn.getResponseCode()) == 401) {
                throw new UnauthorizedException(url);
            }
            if (responseCode == 403) {
                throw new ForbiddenException(url);
            }
            if (responseCode == 404) {
                throw new UrlNotFoundException(url);
            }
            String response = StringUtils.trimToNull((String)HttpHelper.readInputStream(conn));
            if (rawRespRef != null) {
                rawRespRef.append(response);
            }
            if (responseCode >= 400 || !JSONUtils.mayBeJSON((String)response)) {
                ConnectionResponse connectionResponse = new ConnectionResponse(responseHeader, response, responseCode);
                return connectionResponse;
            }
            try {
                responseObject = (JSONObject)JSONSerializer.toJSON((Object)response);
            }
            catch (JSONException e) {
                ConnectionResponse connectionResponse = new ConnectionResponse(responseHeader, response, responseCode);
                if (conn != null) {
                    conn.disconnect();
                }
                return connectionResponse;
            }
        }
        catch (SSLHandshakeException handshakeException) {
            context.logger.println("An SSLHandshakeException occured. The certificate might not be trusted!\nSet 'Trust all certificates' and try again, if you want to accept untrusted certificates.\n");
            throw handshakeException;
        }
        catch (IOException e) {
            List hints = responseHeader != null ? (List)responseHeader.get(null) : null;
            String hintsString = hints != null && hints.size() > 0 ? " - " + hints.toString() : "";
            logger.log(Level.WARNING, e.getMessage() + hintsString, e);
            if (numberOfAttempts <= retryLimit) {
                context.logger.println(String.format("Connection to remote server failed [%s], waiting to retry - %s seconds until next attempt. URL: %s, parameters: %s", responseCode == 0 ? e.getMessage() : Integer.valueOf(responseCode), pollInterval, HttpHelper.getUrlWithoutParameters(urlString), parmsString));
                Thread.sleep(pollInterval * 1000);
                context.logger.println("Retry attempt #" + numberOfAttempts + " out of " + retryLimit);
                ConnectionResponse connectionResponse = HttpHelper.sendHTTPCall(urlString, requestType, context, postParams, readTimeout, ++numberOfAttempts, pollInterval, retryLimit, overrideAuth, rawRespRef, isCrubmCacheEnabled);
                return connectionResponse;
            }
            context.logger.println(String.format("Connection to remote server failed [%s], number of retries exceeded. URL: %s, parameters: %s", responseCode == 0 ? e.getMessage() : Integer.valueOf(responseCode), HttpHelper.getUrlWithoutParameters(urlString), parmsString));
            throw new ExceedRetryLimitException();
        }
        finally {
            if (conn != null) {
                conn.disconnect();
            }
        }
        return new ConnectionResponse(responseHeader, responseObject, responseCode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ConnectionResponse tryCall(String urlString, String method, BuildContext context, Map<String, String> params, int readTimeout, int pollInterval, int retryLimit, Auth2 overrideAuth, StringBuilder rawRespRef, Semaphore lock, boolean isCrubmCacheEnabled) throws IOException, InterruptedException {
        if (lock == null) {
            context.logger.println("calling remote without locking...");
            return HttpHelper.sendHTTPCall(urlString, method, context, null, readTimeout, 1, pollInterval, retryLimit, overrideAuth, rawRespRef, isCrubmCacheEnabled);
        }
        Boolean isAcquired = null;
        try {
            ConnectionResponse cr;
            try {
                isAcquired = lock.tryAcquire(pollInterval, TimeUnit.SECONDS);
                logger.log(Level.FINE, String.format("calling %s in semaphore...", urlString));
            }
            catch (InterruptedException e) {
                logger.log(Level.WARNING, "fail to acquire lock because of interrupt, skip locking...", e);
            }
            if (isAcquired != null && !isAcquired.booleanValue()) {
                logger.warning("fail to acquire lock because of timeout, skip locking...");
            }
            ConnectionResponse connectionResponse = cr = HttpHelper.sendHTTPCall(urlString, method, context, params, readTimeout, 1, pollInterval, retryLimit, overrideAuth, rawRespRef, isCrubmCacheEnabled);
            return connectionResponse;
        }
        finally {
            if (isAcquired != null && isAcquired.booleanValue()) {
                lock.release();
            }
        }
    }

    public static ConnectionResponse tryPost(String urlString, BuildContext context, Map<String, String> params, int readTimeout, int pollInterval, int retryLimit, Auth2 overrideAuth, Semaphore lock, boolean isCrubmCacheEnabled) throws IOException, InterruptedException {
        return HttpHelper.tryCall(urlString, HTTP_POST, context, params, readTimeout, pollInterval, retryLimit, overrideAuth, null, lock, isCrubmCacheEnabled);
    }

    public static ConnectionResponse tryGet(String urlString, BuildContext context, int readTimeout, int pollInterval, int retryLimit, Auth2 overrideAuth, Semaphore lock) throws IOException, InterruptedException {
        return HttpHelper.tryCall(urlString, HTTP_GET, context, null, readTimeout, pollInterval, retryLimit, overrideAuth, null, lock, false);
    }

    public static String tryGetRawResp(String urlString, BuildContext context, int readTimeout, int pollInterval, int retryLimit, Auth2 overrideAuth, Semaphore lock) throws IOException, InterruptedException {
        StringBuilder resp = new StringBuilder();
        HttpHelper.tryCall(urlString, HTTP_GET, context, null, readTimeout, pollInterval, retryLimit, overrideAuth, resp, lock, false);
        return resp.toString();
    }

    public static ConnectionResponse post(String urlString, BuildContext context, Map<String, String> params, int readTimeout, int pollInterval, int retryLimit, Auth2 overrideAuth, boolean isCrubmCacheEnabled) throws IOException, InterruptedException {
        return HttpHelper.tryPost(urlString, context, params, readTimeout, pollInterval, retryLimit, overrideAuth, null, isCrubmCacheEnabled);
    }

    public static ConnectionResponse get(String urlString, BuildContext context, int readTimeout, int pollInterval, int retryLimit, Auth2 overrideAuth) throws IOException, InterruptedException {
        return HttpHelper.tryGet(urlString, context, readTimeout, pollInterval, retryLimit, overrideAuth, null);
    }

    public static String getRawResp(String urlString, String requestType, BuildContext context, Collection<String> postParams, int readTimeout, int numberOfAttempts, int pollInterval, int retryLimit, Auth2 overrideAuth) throws IOException, InterruptedException {
        return HttpHelper.tryGetRawResp(urlString, context, readTimeout, pollInterval, retryLimit, overrideAuth, null);
    }
}

