/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.ParameterizedRemoteTrigger.utils;

import hudson.util.FormValidation;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;

@Restricted(value={NoExternalUse.class})
public class FormValidationUtils {
    public static RemoteURLCombinationsResult checkRemoteURLCombinations(String remoteJenkinsUrl, String remoteJenkinsName, String jobNameOrUrl) {
        boolean job_setAndNoUrl;
        boolean job_setAndValidUrl;
        remoteJenkinsUrl = StringUtils.trimToNull((String)remoteJenkinsUrl);
        remoteJenkinsName = StringUtils.trimToNull((String)remoteJenkinsName);
        jobNameOrUrl = StringUtils.trimToNull((String)jobNameOrUrl);
        boolean remoteUrl_setAndValidUrl = StringUtils.isEmpty((String)remoteJenkinsUrl) ? false : FormValidationUtils.isURL(remoteJenkinsUrl);
        boolean remoteName_setAndValid = !StringUtils.isEmpty((String)remoteJenkinsName);
        boolean bl = job_setAndValidUrl = StringUtils.isEmpty((String)jobNameOrUrl) ? false : FormValidationUtils.isURL(jobNameOrUrl);
        boolean bl2 = StringUtils.isEmpty((String)jobNameOrUrl) ? false : (job_setAndNoUrl = !FormValidationUtils.isURL(jobNameOrUrl));
        boolean job_containsVariable = StringUtils.isEmpty((String)jobNameOrUrl) ? false : jobNameOrUrl.indexOf("$") >= 0;
        String TEXT_WARNING_JOB_VARIABLE = "You are using a variable in the 'Remote Job Name or URL' ('job') field. You have to make sure the value at runtime results in the full job URL";
        String TEXT_ERROR_NO_URL_AT_ALL = "You have to configure either 'Select a remote host' ('remoteJenkinsName'), 'Override remote host URL' ('remoteJenkinsUrl') or specify a full job URL 'Remote Job Name or URL' ('job')";
        if (StringUtils.isEmpty((String)jobNameOrUrl)) {
            return new RemoteURLCombinationsResult(FormValidation.error((String)"'Remote Job Name or URL' ('job') not specified"), AffectedField.JOB_NAME_OR_URL);
        }
        if (!StringUtils.isEmpty((String)remoteJenkinsUrl) && !FormValidationUtils.isURL(remoteJenkinsUrl)) {
            return new RemoteURLCombinationsResult(FormValidation.error((String)"Invalid URL in 'Override remote host URL' ('remoteJenkinsUrl')"), AffectedField.REMOTE_JENKINS_URL);
        }
        if (!(remoteUrl_setAndValidUrl || remoteName_setAndValid || job_setAndValidUrl)) {
            if (job_containsVariable) {
                return new RemoteURLCombinationsResult(FormValidation.warning((String)"You are using a variable in the 'Remote Job Name or URL' ('job') field. You have to make sure the value at runtime results in the full job URL"), AffectedField.JOB_NAME_OR_URL);
            }
            return new RemoteURLCombinationsResult(FormValidation.error((String)"You have to configure either 'Select a remote host' ('remoteJenkinsName'), 'Override remote host URL' ('remoteJenkinsUrl') or specify a full job URL 'Remote Job Name or URL' ('job')"), AffectedField.JOB_NAME_OR_URL, AffectedField.REMOTE_JENKINS_NAME, AffectedField.REMOTE_JENKINS_URL);
        }
        if (job_setAndValidUrl) {
            return RemoteURLCombinationsResult.OK();
        }
        if (remoteUrl_setAndValidUrl && job_setAndNoUrl) {
            if (job_containsVariable) {
                return new RemoteURLCombinationsResult(FormValidation.warning((String)"You are using a variable in the 'Remote Job Name or URL' ('job') field. You have to make sure the value at runtime results in the full job URL"), AffectedField.JOB_NAME_OR_URL);
            }
            return RemoteURLCombinationsResult.OK();
        }
        if (remoteName_setAndValid && job_setAndNoUrl) {
            if (job_containsVariable) {
                return new RemoteURLCombinationsResult(FormValidation.warning((String)"You are using a variable in the 'Remote Job Name or URL' ('job') field. You have to make sure the value at runtime results in the full job URL"), AffectedField.JOB_NAME_OR_URL);
            }
            return RemoteURLCombinationsResult.OK();
        }
        return new RemoteURLCombinationsResult(FormValidation.error((String)"You have to configure either 'Select a remote host' ('remoteJenkinsName'), 'Override remote host URL' ('remoteJenkinsUrl') or specify a full job URL 'Remote Job Name or URL' ('job')"), AffectedField.JOB_NAME_OR_URL, AffectedField.REMOTE_JENKINS_NAME, AffectedField.REMOTE_JENKINS_URL);
    }

    public static boolean isURL(String string) {
        if (StringUtils.isEmpty((String)StringUtils.trimToNull((String)string))) {
            return false;
        }
        String stringLower = string.toLowerCase();
        if (stringLower.startsWith("http://") || stringLower.startsWith("https://")) {
            if (stringLower.indexOf("://") >= stringLower.length() - 3) {
                return false;
            }
            if (stringLower.indexOf("$") >= 0) {
                return false;
            }
            try {
                new URL(string);
                return true;
            }
            catch (MalformedURLException e) {
                return false;
            }
        }
        return false;
    }

    public static class RemoteURLCombinationsResult {
        public final FormValidation formValidation;
        public final AffectedField[] affectedFields;

        public RemoteURLCombinationsResult(FormValidation formValidation, AffectedField ... affectedFields) {
            this.formValidation = formValidation;
            this.affectedFields = affectedFields;
        }

        public boolean isAffected(AffectedField field) {
            return Arrays.asList(this.affectedFields).contains((Object)field);
        }

        public static RemoteURLCombinationsResult OK() {
            return new RemoteURLCombinationsResult(FormValidation.ok(), AffectedField.values());
        }
    }

    public static enum AffectedField {
        JOB_NAME_OR_URL,
        REMOTE_JENKINS_URL,
        REMOTE_JENKINS_NAME;

    }
}

