/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.ParameterizedRemoteTrigger.remoteJob;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import hudson.AbortException;
import hudson.model.Result;
import java.io.Serializable;
import java.net.URL;
import org.jenkinsci.plugins.ParameterizedRemoteTrigger.remoteJob.RemoteBuildStatus;

public class RemoteBuildInfo
implements Serializable {
    private static final long serialVersionUID = -5177308623227407314L;
    @CheckForNull
    private String queueId;
    @NonNull
    private int buildNumber;
    @CheckForNull
    private URL buildURL;
    @NonNull
    private RemoteBuildStatus status = RemoteBuildStatus.NOT_TRIGGERED;
    @NonNull
    private Result result = Result.NOT_BUILT;

    @CheckForNull
    public String getQueueId() {
        return this.queueId;
    }

    @NonNull
    public int getBuildNumber() {
        return this.buildNumber;
    }

    @CheckForNull
    public URL getBuildURL() {
        return this.buildURL;
    }

    @NonNull
    public RemoteBuildStatus getStatus() {
        return this.status;
    }

    @NonNull
    public Result getResult() {
        return this.result;
    }

    public void setQueueId(String queueId) {
        this.queueId = queueId;
        this.status = RemoteBuildStatus.QUEUED;
    }

    public void setBuildData(@NonNull int buildNumber, @Nullable URL buildURL) throws AbortException {
        if (buildURL == null) {
            throw new AbortException(String.format("Unexpected remote build status: %s", this.toString()));
        }
        this.buildNumber = buildNumber;
        this.buildURL = buildURL;
        this.status = RemoteBuildStatus.RUNNING;
    }

    public void setBuildStatus(RemoteBuildStatus status) {
        if (status == RemoteBuildStatus.FINISHED) {
            throw new IllegalArgumentException("It is not possible to set the status to finished without setting the build result. Please use BuildInfo(Result result) or BuildInfo(String result) in order to set the status to finished.");
        }
        this.status = status;
        this.result = Result.NOT_BUILT;
    }

    public void setBuildResult(Result result) {
        this.status = RemoteBuildStatus.FINISHED;
        this.result = result;
    }

    public void setBuildResult(String result) {
        this.status = RemoteBuildStatus.FINISHED;
        this.result = Result.fromString((String)result);
    }

    @NonNull
    public String toString() {
        if (this.status == RemoteBuildStatus.FINISHED) {
            return String.format("status=%s, result=%s", this.status.toString(), this.result.toString());
        }
        return String.format("status=%s", this.status.toString());
    }

    public boolean isNotTriggered() {
        return this.status == RemoteBuildStatus.NOT_TRIGGERED;
    }

    public boolean isQueued() {
        return this.status == RemoteBuildStatus.QUEUED;
    }

    public boolean isRunning() {
        return this.status == RemoteBuildStatus.RUNNING;
    }

    public boolean isFinished() {
        return this.status == RemoteBuildStatus.FINISHED;
    }
}

