/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.ParameterizedRemoteTrigger.remoteJob;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.net.MalformedURLException;
import java.net.URL;
import net.sf.json.JSONException;
import net.sf.json.JSONObject;
import org.jenkinsci.plugins.ParameterizedRemoteTrigger.BuildContext;
import org.jenkinsci.plugins.ParameterizedRemoteTrigger.remoteJob.QueueItemStatus;

public class QueueItemData {
    @NonNull
    private QueueItemStatus status = QueueItemStatus.WAITING;
    @Nullable
    private String why;
    @NonNull
    private int buildNumber;
    @Nullable
    private URL buildURL;

    public boolean isWaiting() {
        return this.status == QueueItemStatus.WAITING;
    }

    public boolean isBlocked() {
        return this.status == QueueItemStatus.BLOCKED;
    }

    public boolean isBuildable() {
        return this.status == QueueItemStatus.BUILDABLE;
    }

    public boolean isPending() {
        return this.status == QueueItemStatus.PENDING;
    }

    public boolean isLeft() {
        return this.status == QueueItemStatus.LEFT;
    }

    public boolean isExecuted() {
        return this.status == QueueItemStatus.EXECUTED;
    }

    public boolean isCancelled() {
        return this.status == QueueItemStatus.CANCELLED;
    }

    @NonNull
    public QueueItemStatus getStatus() {
        return this.status;
    }

    @CheckForNull
    public String getWhy() {
        return this.why;
    }

    @NonNull
    public int getBuildNumber() {
        return this.buildNumber;
    }

    @CheckForNull
    public URL getBuildURL() {
        return this.buildURL;
    }

    public void update(@NonNull BuildContext context, @NonNull JSONObject queueResponse) throws MalformedURLException {
        if (queueResponse.getBoolean("blocked")) {
            this.status = QueueItemStatus.BLOCKED;
        }
        if (queueResponse.getBoolean("buildable")) {
            this.status = QueueItemStatus.BUILDABLE;
        }
        if (this.getOptionalBoolean(queueResponse, "pending")) {
            this.status = QueueItemStatus.PENDING;
        }
        if (this.getOptionalBoolean(queueResponse, "cancelled")) {
            this.status = QueueItemStatus.CANCELLED;
        }
        if (this.isBlocked() || this.isBuildable() || this.isPending()) {
            this.why = queueResponse.getString("why");
        } else if (!this.isCancelled()) {
            this.status = QueueItemStatus.LEFT;
        }
        if (this.isLeft()) {
            block15: {
                try {
                    JSONObject remoteJobInfo = queueResponse.getJSONObject("executable");
                    if (remoteJobInfo.isNullObject()) break block15;
                    try {
                        this.buildNumber = remoteJobInfo.getInt("number");
                    }
                    catch (JSONException e) {
                        context.logger.println(String.format("[WARNING] The attribute \"number\" was not found. Unexpected response: %s", queueResponse.toString()));
                    }
                    try {
                        this.buildURL = new URL(remoteJobInfo.getString("url"));
                    }
                    catch (JSONException e) {
                        context.logger.println(String.format("[WARNING] The attribute \"url\" was not found. Unexpected response: %s", queueResponse.toString()));
                    }
                }
                catch (JSONException e) {
                    context.logger.println(String.format("[WARNING] The attribute \"executable\" was not found. Unexpected response: %s", queueResponse.toString()));
                }
            }
            if (this.buildNumber != 0 && this.buildURL != null) {
                this.status = QueueItemStatus.EXECUTED;
            }
        }
    }

    private boolean getOptionalBoolean(@NonNull JSONObject queueResponse, @NonNull String attribute) {
        if (queueResponse.containsKey((Object)attribute)) {
            return queueResponse.getBoolean(attribute);
        }
        return false;
    }
}

