/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.ParameterizedRemoteTrigger.remoteJob;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.AbortException;
import java.util.List;
import java.util.Map;

public class QueueItem {
    private static final String key = "Location";
    @NonNull
    private final String location;
    @NonNull
    private final String id;

    public QueueItem(@NonNull Map<String, List<String>> header) throws AbortException {
        if (!header.containsKey(key)) {
            throw new AbortException(String.format("Error triggering the remote job. The header of the response has an unexpected format: %n%s", header));
        }
        this.location = header.get(key).get(0);
        try {
            String loc = this.location.substring(0, this.location.lastIndexOf(47));
            this.id = loc.substring(loc.lastIndexOf(47) + 1);
        }
        catch (Exception ex) {
            throw new AbortException(String.format("Error triggering the remote job. The header of the response contains an unexpected location: %s", this.location));
        }
    }

    @NonNull
    public String getLocation() {
        return this.location;
    }

    @NonNull
    public String getId() {
        return this.id;
    }
}

