/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.ParameterizedRemoteTrigger.pipeline;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import hudson.model.Result;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.util.Optional;
import net.sf.json.JSONException;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.plugins.ParameterizedRemoteTrigger.BuildContext;
import org.jenkinsci.plugins.ParameterizedRemoteTrigger.RemoteBuildConfiguration;
import org.jenkinsci.plugins.ParameterizedRemoteTrigger.RemoteJenkinsServer;
import org.jenkinsci.plugins.ParameterizedRemoteTrigger.pipeline.PrintStreamWrapper;
import org.jenkinsci.plugins.ParameterizedRemoteTrigger.remoteJob.RemoteBuildInfo;
import org.jenkinsci.plugins.ParameterizedRemoteTrigger.remoteJob.RemoteBuildStatus;
import org.jenkinsci.plugins.scriptsecurity.sandbox.whitelists.Whitelisted;

public class Handle
implements Serializable {
    private static final long serialVersionUID = 4418782245518194292L;
    @NonNull
    private final RemoteBuildConfiguration remoteBuildConfiguration;
    @NonNull
    private RemoteBuildInfo buildInfo;
    @Nullable
    private String jobName;
    @Nullable
    private String jobFullName;
    @Nullable
    private String jobDisplayName;
    @Nullable
    private String jobFullDisplayName;
    @Nullable
    private String jobUrl;
    @NonNull
    private final String currentItem;
    @NonNull
    private final RemoteJenkinsServer effectiveRemoteServer;
    @NonNull
    private String lastLog;

    public Handle(@NonNull RemoteBuildConfiguration remoteBuildConfiguration, @NonNull RemoteBuildInfo buildInfo, @NonNull String currentItem, @NonNull RemoteJenkinsServer effectiveRemoteServer, @NonNull JSONObject remoteJobMetadata) {
        this.remoteBuildConfiguration = remoteBuildConfiguration;
        this.buildInfo = buildInfo;
        this.jobName = this.getParameterFromJobMetadata(remoteJobMetadata, "name");
        this.jobFullName = this.getParameterFromJobMetadata(remoteJobMetadata, "fullName");
        this.jobDisplayName = this.getParameterFromJobMetadata(remoteJobMetadata, "displayName");
        this.jobFullDisplayName = this.getParameterFromJobMetadata(remoteJobMetadata, "fullDisplayName");
        this.jobUrl = this.getParameterFromJobMetadata(remoteJobMetadata, "url");
        this.currentItem = currentItem;
        this.effectiveRemoteServer = effectiveRemoteServer;
        this.lastLog = "";
        if (StringUtils.trimToNull((String)currentItem) == null) {
            throw new IllegalArgumentException("currentItem null");
        }
    }

    @Whitelisted
    public boolean isQueued() throws IOException, InterruptedException {
        return this.buildInfo.isQueued();
    }

    @Whitelisted
    public boolean isFinished() throws IOException, InterruptedException {
        return this.buildInfo.isFinished();
    }

    public String getConfiguredJobNameOrUrl() {
        return this.remoteBuildConfiguration.getJob();
    }

    @CheckForNull
    public String getJobName() {
        return this.jobName;
    }

    @CheckForNull
    public String getJobFullName() {
        return this.jobFullName;
    }

    @CheckForNull
    public String getJobDisplayName() {
        return this.jobDisplayName;
    }

    @CheckForNull
    public String getJobFullDisplayName() {
        return this.jobFullDisplayName;
    }

    @CheckForNull
    public String getJobUrl() {
        return this.jobUrl;
    }

    @CheckForNull
    public String getQueueId() {
        return this.buildInfo.getQueueId();
    }

    @Whitelisted
    @CheckForNull
    public URL getBuildUrl() {
        return this.buildInfo.getBuildURL() == null ? null : this.buildInfo.getBuildURL();
    }

    @Whitelisted
    @NonNull
    public int getBuildNumber() {
        return this.buildInfo.getBuildNumber();
    }

    @Whitelisted
    @NonNull
    public RemoteBuildInfo getBuildInfo() {
        return this.buildInfo;
    }

    @Whitelisted
    @NonNull
    public RemoteBuildStatus getBuildStatus() {
        return this.buildInfo.getStatus();
    }

    @Whitelisted
    @NonNull
    public RemoteBuildStatus updateBuildStatus() throws IOException, InterruptedException {
        return this.updateBuildStatus(false);
    }

    @Whitelisted
    @NonNull
    public RemoteBuildStatus updateBuildStatusBlocking() throws IOException, InterruptedException {
        return this.updateBuildStatus(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    private RemoteBuildStatus updateBuildStatus(boolean blockUntilFinished) throws IOException, InterruptedException {
        if (this.buildInfo.isFinished()) {
            return this.buildInfo.getStatus();
        }
        PrintStreamWrapper log = new PrintStreamWrapper();
        try {
            while (!this.buildInfo.isFinished()) {
                BuildContext context = new BuildContext(log.getPrintStream(), this.effectiveRemoteServer, this.currentItem);
                this.buildInfo = this.remoteBuildConfiguration.updateBuildInfo(this.buildInfo, context);
                if (blockUntilFinished) continue;
                break;
            }
            RemoteBuildStatus remoteBuildStatus = this.buildInfo.getStatus();
            return remoteBuildStatus;
        }
        finally {
            this.lastLog = log.getContent();
        }
    }

    public void setBuildInfo(RemoteBuildInfo buildInfo) {
        this.buildInfo = buildInfo;
    }

    @Whitelisted
    @NonNull
    public Result getBuildResult() {
        return this.buildInfo.getResult();
    }

    @Whitelisted
    @NonNull
    public String lastLog() {
        String log = this.lastLog.trim();
        this.lastLog = "";
        return log;
    }

    @Whitelisted
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(String.format("Handle [job=%s, remoteServerURL=%s, queueId=%s", this.remoteBuildConfiguration.getJob(), this.effectiveRemoteServer.getAddress(), this.buildInfo.getQueueId()));
        sb.append(String.format(", %s", this.buildInfo.toString()));
        if (this.buildInfo != null) {
            sb.append(String.format(", buildNumber=%s, buildUrl=%s", this.buildInfo.getBuildNumber(), this.buildInfo.getBuildURL()));
        }
        sb.append("]");
        return sb.toString();
    }

    @Whitelisted
    public static String help() {
        StringBuilder sb = new StringBuilder();
        sb.append("This object provides the following methods:\n");
        for (Method method : Handle.class.getDeclaredMethods()) {
            Class<?>[] params;
            if (method.getAnnotation(Whitelisted.class) == null || !Modifier.isPublic(method.getModifiers())) continue;
            sb.append("- ").append(method.getReturnType().getSimpleName()).append(" ");
            sb.append(method.getName()).append("(");
            for (Class<?> param : params = method.getParameterTypes()) {
                if (params.length > 1 && !param.equals(params[0])) {
                    sb.append(", ");
                }
                sb.append(param.getSimpleName());
            }
            sb.append(")\n");
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Whitelisted
    public Object readJsonFileFromBuildArchive(String filename) throws IOException, InterruptedException {
        if (StringUtils.isEmpty((String)filename)) {
            return null;
        }
        URL remoteBuildUrl = this.getBuildUrl();
        URL fileUrl = new URL(remoteBuildUrl, "artifact/" + filename);
        PrintStreamWrapper log = new PrintStreamWrapper();
        try {
            BuildContext context = new BuildContext(log.getPrintStream(), this.effectiveRemoteServer, this.currentItem);
            JSONObject jSONObject = this.remoteBuildConfiguration.doGet(fileUrl.toString(), context, this.getBuildStatus()).getBody();
            return jSONObject;
        }
        finally {
            this.lastLog = log.getContent();
        }
    }

    @CheckForNull
    private String getParameterFromJobMetadata(JSONObject remoteJobMetadata, String string) {
        try {
            return Optional.ofNullable(remoteJobMetadata).map(meta -> meta.getString("name")).map(StringUtils::trimToNull).orElse(null);
        }
        catch (JSONException e) {
            return null;
        }
    }
}

