/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.ParameterizedRemoteTrigger.parameters2;

import com.google.common.base.Strings;
import hudson.AbortException;
import hudson.DescriptorExtensionList;
import hudson.model.AbstractDescribableImpl;
import hudson.model.Descriptor;
import java.io.Serializable;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import jenkins.model.Jenkins;
import org.jenkinsci.plugins.ParameterizedRemoteTrigger.BuildContext;
import org.jenkinsci.plugins.ParameterizedRemoteTrigger.parameters2.FileParameters;
import org.jenkinsci.plugins.ParameterizedRemoteTrigger.parameters2.MapParameters;
import org.jenkinsci.plugins.ParameterizedRemoteTrigger.parameters2.StringParameters;

public abstract class JobParameters
extends AbstractDescribableImpl<JobParameters>
implements Serializable,
Cloneable {
    private static final DescriptorExtensionList<JobParameters, ParametersDescriptor> ALL = DescriptorExtensionList.createDescriptorList((Jenkins)Jenkins.getInstance(), JobParameters.class);

    public static DescriptorExtensionList<JobParameters, ParametersDescriptor> all() {
        return ALL;
    }

    public static JobParameters migrateOldParameters(String parameters, String parameterFile) {
        if (!Strings.isNullOrEmpty((String)parameterFile)) {
            return new FileParameters(parameterFile);
        }
        if (!Strings.isNullOrEmpty((String)parameters)) {
            return new StringParameters(parameters);
        }
        return new MapParameters();
    }

    public static Map<String, String> parseStringParameters(String parametersAsString) {
        return Arrays.stream(parametersAsString.split("\\n")).filter(JobParameters.not(JobParameters::isBlankLine)).filter(JobParameters.not(JobParameters::isCommentedLine)).filter(JobParameters::containsEqualSign).map(JobParameters::splitParameterLine).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    private static <T> Predicate<T> not(Predicate<T> t) {
        return t.negate();
    }

    private static boolean isBlankLine(String line) {
        return line.trim().isEmpty();
    }

    private static boolean isCommentedLine(String line) {
        return line.trim().startsWith("#");
    }

    private static boolean containsEqualSign(String line) {
        return line.contains("=");
    }

    private static Map.Entry<String, String> splitParameterLine(String line) {
        int firstIndexOfEqualSign = line.indexOf("=");
        return new AbstractMap.SimpleEntry<String, String>(line.substring(0, firstIndexOfEqualSign), line.substring(firstIndexOfEqualSign + 1));
    }

    public abstract Map<String, String> getParametersMap(BuildContext var1) throws AbortException;

    public JobParameters clone() throws CloneNotSupportedException {
        return (JobParameters)super.clone();
    }

    public static abstract class ParametersDescriptor
    extends Descriptor<JobParameters> {
    }
}

