/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.ParameterizedRemoteTrigger.auth2;

import hudson.Extension;
import hudson.model.Item;
import hudson.util.Secret;
import java.io.IOException;
import java.net.URLConnection;
import org.jenkinsci.Symbol;
import org.jenkinsci.plugins.ParameterizedRemoteTrigger.BuildContext;
import org.jenkinsci.plugins.ParameterizedRemoteTrigger.auth2.Auth2;
import org.jenkinsci.plugins.ParameterizedRemoteTrigger.utils.Base64Utils;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;

public class TokenAuth
extends Auth2 {
    private static final long serialVersionUID = 7912089565969112023L;
    @Extension
    public static final Auth2.Auth2Descriptor DESCRIPTOR = new TokenAuthDescriptor();
    private String userName = null;
    private Secret apiToken = null;

    @DataBoundConstructor
    public TokenAuth() {
    }

    @DataBoundSetter
    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getUserName() {
        return this.userName;
    }

    @DataBoundSetter
    public void setApiToken(Secret apiToken) {
        this.apiToken = apiToken;
    }

    public Secret getApiToken() {
        return this.apiToken;
    }

    @Override
    public void setAuthorizationHeader(URLConnection connection, BuildContext context) throws IOException {
        String authHeaderValue = Base64Utils.generateAuthorizationHeaderValue("Basic", this.getUserName(), this.getApiToken().getPlainText(), context, true);
        connection.setRequestProperty("Authorization", authHeaderValue);
    }

    @Override
    public String toString() {
        return "'" + this.getDescriptor().getDisplayName() + "' as user '" + this.getUserName() + "'";
    }

    @Override
    public String toString(Item item) {
        return this.toString();
    }

    public Auth2.Auth2Descriptor getDescriptor() {
        return DESCRIPTOR;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.apiToken == null ? 0 : this.apiToken.hashCode());
        result = 31 * result + (this.userName == null ? 0 : this.userName.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!this.getClass().isInstance(obj)) {
            return false;
        }
        TokenAuth other = (TokenAuth)obj;
        if (this.apiToken == null ? other.apiToken != null : !this.apiToken.equals((Object)other.apiToken)) {
            return false;
        }
        return !(this.userName == null ? other.userName != null : !this.userName.equals(other.userName));
    }

    @Symbol(value={"TokenAuth"})
    public static class TokenAuthDescriptor
    extends Auth2.Auth2Descriptor {
        public String getDisplayName() {
            return "Token Authentication";
        }
    }
}

