/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.ParameterizedRemoteTrigger.auth2;

import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.common.StandardUsernameCredentials;
import com.cloudbees.plugins.credentials.common.StandardUsernameListBoxModel;
import com.cloudbees.plugins.credentials.common.UsernamePasswordCredentials;
import hudson.Extension;
import hudson.model.Item;
import hudson.security.ACL;
import hudson.util.ListBoxModel;
import java.io.IOException;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import jenkins.model.Jenkins;
import org.acegisecurity.Authentication;
import org.jenkinsci.Symbol;
import org.jenkinsci.plugins.ParameterizedRemoteTrigger.BuildContext;
import org.jenkinsci.plugins.ParameterizedRemoteTrigger.auth2.Auth2;
import org.jenkinsci.plugins.ParameterizedRemoteTrigger.exceptions.CredentialsNotFoundException;
import org.jenkinsci.plugins.ParameterizedRemoteTrigger.utils.Base64Utils;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.Stapler;

public class CredentialsAuth
extends Auth2 {
    private static final long serialVersionUID = -2650007108928532552L;
    @Extension
    public static final Auth2.Auth2Descriptor DESCRIPTOR = new CredentialsAuthDescriptor();
    private String credentials = null;

    @DataBoundConstructor
    public CredentialsAuth() {
    }

    @DataBoundSetter
    public void setCredentials(String credentials) {
        this.credentials = credentials;
    }

    public String getCredentials() {
        return this.credentials;
    }

    public String getUserName(Item item) throws CredentialsNotFoundException {
        UsernamePasswordCredentials creds = this._getCredentials(item);
        return creds.getUsername();
    }

    public String getPassword(Item item) throws CredentialsNotFoundException {
        UsernamePasswordCredentials creds = this._getCredentials(item);
        return creds.getPassword().getPlainText();
    }

    @Override
    public String toString() {
        return this.toString(null);
    }

    @Override
    public String toString(Item item) {
        try {
            String userName = this.getUserName(item);
            return String.format("'%s' as user '%s' (Credentials ID '%s')", this.getDescriptor().getDisplayName(), userName, this.credentials);
        }
        catch (CredentialsNotFoundException e) {
            return String.format("'%s'. WARNING! No credentials found with ID '%s'!", this.getDescriptor().getDisplayName(), this.credentials);
        }
    }

    private UsernamePasswordCredentials _getCredentials(Item item) throws CredentialsNotFoundException {
        List listOfCredentials = CredentialsProvider.lookupCredentials(StandardUsernameCredentials.class, (Item)item, (Authentication)ACL.SYSTEM, Collections.emptyList());
        return (UsernamePasswordCredentials)this._findCredential(this.credentials, listOfCredentials);
    }

    private StandardUsernameCredentials _findCredential(String credentialId, List<StandardUsernameCredentials> listOfCredentials) throws CredentialsNotFoundException {
        for (StandardUsernameCredentials cred : listOfCredentials) {
            if (!credentialId.equals(cred.getId())) continue;
            return cred;
        }
        throw new CredentialsNotFoundException(credentialId);
    }

    @Override
    public void setAuthorizationHeader(URLConnection connection, BuildContext context) throws IOException {
        Jenkins jenkins = Jenkins.getInstance();
        if (jenkins != null) {
            Item item = jenkins.getItem(context.currentItem, (Item)jenkins.getItem("/"));
            String authHeaderValue = Base64Utils.generateAuthorizationHeaderValue("Basic", this.getUserName(item), this.getPassword(item), context, false);
            connection.setRequestProperty("Authorization", authHeaderValue);
        }
    }

    public Auth2.Auth2Descriptor getDescriptor() {
        return DESCRIPTOR;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.credentials == null ? 0 : this.credentials.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!this.getClass().isInstance(obj)) {
            return false;
        }
        CredentialsAuth other = (CredentialsAuth)obj;
        return !(this.credentials == null ? other.credentials != null : !this.credentials.equals(other.credentials));
    }

    @Symbol(value={"CredentialsAuth"})
    public static class CredentialsAuthDescriptor
    extends Auth2.Auth2Descriptor {
        public String getDisplayName() {
            return "Credentials Authentication";
        }

        public static ListBoxModel doFillCredentialsItems() {
            StandardUsernameListBoxModel model = new StandardUsernameListBoxModel();
            Item item = (Item)Stapler.getCurrentRequest().findAncestorObject(Item.class);
            List listOfAllCredentails = CredentialsProvider.lookupCredentials(StandardUsernameCredentials.class, (Item)item, (Authentication)ACL.SYSTEM, Collections.emptyList());
            ArrayList<StandardUsernameCredentials> listOfSandardUsernameCredentials = new ArrayList<StandardUsernameCredentials>();
            for (StandardUsernameCredentials c : listOfAllCredentails) {
                if (!(c instanceof UsernamePasswordCredentials)) continue;
                listOfSandardUsernameCredentials.add(c);
            }
            model.withAll(listOfSandardUsernameCredentials);
            return model;
        }
    }
}

