/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.ParameterizedRemoteTrigger;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import hudson.AbortException;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.BuildListener;
import hudson.model.Descriptor;
import hudson.model.Item;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Builder;
import hudson.util.CopyOnWriteList;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import java.io.IOException;
import java.io.PrintStream;
import java.io.Serializable;
import java.net.CookieHandler;
import java.net.CookieManager;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Semaphore;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.tasks.SimpleBuildStep;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.jenkinsci.plugins.ParameterizedRemoteTrigger.Auth;
import org.jenkinsci.plugins.ParameterizedRemoteTrigger.BasicBuildContext;
import org.jenkinsci.plugins.ParameterizedRemoteTrigger.BuildContext;
import org.jenkinsci.plugins.ParameterizedRemoteTrigger.ConnectionResponse;
import org.jenkinsci.plugins.ParameterizedRemoteTrigger.RemoteJenkinsServer;
import org.jenkinsci.plugins.ParameterizedRemoteTrigger.auth2.Auth2;
import org.jenkinsci.plugins.ParameterizedRemoteTrigger.auth2.NullAuth;
import org.jenkinsci.plugins.ParameterizedRemoteTrigger.parameters2.JobParameters;
import org.jenkinsci.plugins.ParameterizedRemoteTrigger.parameters2.MapParameters;
import org.jenkinsci.plugins.ParameterizedRemoteTrigger.pipeline.Handle;
import org.jenkinsci.plugins.ParameterizedRemoteTrigger.remoteJob.QueueItem;
import org.jenkinsci.plugins.ParameterizedRemoteTrigger.remoteJob.QueueItemData;
import org.jenkinsci.plugins.ParameterizedRemoteTrigger.remoteJob.RemoteBuildInfo;
import org.jenkinsci.plugins.ParameterizedRemoteTrigger.remoteJob.RemoteBuildInfoExporterAction;
import org.jenkinsci.plugins.ParameterizedRemoteTrigger.remoteJob.RemoteBuildStatus;
import org.jenkinsci.plugins.ParameterizedRemoteTrigger.utils.DropCachePeriodicWork;
import org.jenkinsci.plugins.ParameterizedRemoteTrigger.utils.FormValidationUtils;
import org.jenkinsci.plugins.ParameterizedRemoteTrigger.utils.HttpHelper;
import org.jenkinsci.plugins.ParameterizedRemoteTrigger.utils.OtelUtils;
import org.jenkinsci.plugins.ParameterizedRemoteTrigger.utils.RestUtils;
import org.jenkinsci.plugins.ParameterizedRemoteTrigger.utils.StringTools;
import org.jenkinsci.plugins.ParameterizedRemoteTrigger.utils.TokenMacroUtils;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;

public class RemoteBuildConfiguration
extends Builder
implements SimpleBuildStep,
Serializable {
    private static final long serialVersionUID = -4059001060991775146L;
    private static final Auth2 DEFAULT_AUTH = NullAuth.INSTANCE;
    private static final JobParameters DEFAULT_PARAMETERS = new MapParameters();
    private static final int DEFAULT_HTTP_GET_READ_TIMEOUT = 10000;
    private static final int DEFAULT_HTTP_POST_READ_TIMEOUT = 30000;
    private static final int QUEUED_ITEMS_POLLINTERVALL = 30;
    private static final int DEFAULT_POLLINTERVALL = 10;
    private static final int connectionRetryLimit = 5;
    private transient List<Auth> auth;
    private String remoteJenkinsName;
    private String remoteJenkinsUrl;
    private Auth2 auth2;
    private JobParameters parameters2;
    private boolean shouldNotFailBuild;
    private boolean trustAllCertificates;
    private boolean overrideTrustAllCertificates;
    private boolean preventRemoteBuildQueue;
    private int httpPostReadTimeout = 30000;
    private int httpGetReadTimeout = 10000;
    private int pollInterval = 10;
    private boolean blockBuildUntilComplete;
    private String job;
    private String token;
    private String parameters;
    private boolean enhancedLogging;
    private String parameterFile;
    private int maxConn = 1;
    private boolean useCrumbCache;
    private boolean useJobInfoCache;
    private boolean abortTriggeredJob;
    private boolean disabled;
    private transient Map<String, Semaphore> hostLocks = new HashMap<String, Semaphore>();
    private Map<String, Integer> hostPermits = new HashMap<String, Integer>();
    private static Logger logger = Logger.getLogger(RemoteBuildConfiguration.class.getName());

    @DataBoundConstructor
    public RemoteBuildConfiguration() {
        CookieManager cookieManager = new CookieManager();
        CookieHandler.setDefault(cookieManager);
    }

    protected Object readResolve() {
        if (this.auth2 == null) {
            this.auth2 = this.auth == null || this.auth.size() <= 0 ? DEFAULT_AUTH : Auth.authToAuth2(this.auth);
        }
        this.auth = null;
        if (this.parameters2 == null) {
            this.parameters2 = JobParameters.migrateOldParameters(this.parameters, this.parameterFile);
        }
        this.parameters = null;
        this.parameterFile = null;
        if (this.hostLocks == null) {
            this.hostLocks = new HashMap<String, Semaphore>();
        }
        if (this.hostPermits == null) {
            this.hostPermits = new HashMap<String, Integer>();
        }
        return this;
    }

    @DataBoundSetter
    public void setTrustAllCertificates(boolean trustAllCertificates) {
        this.trustAllCertificates = trustAllCertificates;
    }

    @DataBoundSetter
    public void setOverrideTrustAllCertificates(boolean overrideTrustAllCertificates) {
        this.overrideTrustAllCertificates = overrideTrustAllCertificates;
    }

    @DataBoundSetter
    public void setAbortTriggeredJob(boolean abortTriggeredJob) {
        this.abortTriggeredJob = abortTriggeredJob;
    }

    @DataBoundSetter
    public void setMaxConn(int maxConn) {
        this.maxConn = maxConn > 5 ? 5 : Math.max(maxConn, 1);
    }

    @DataBoundSetter
    public void setRemoteJenkinsName(String remoteJenkinsName) {
        this.remoteJenkinsName = StringUtils.trimToNull((String)remoteJenkinsName);
    }

    @DataBoundSetter
    public void setRemoteJenkinsUrl(String remoteJenkinsUrl) {
        this.remoteJenkinsUrl = StringUtils.trimToNull((String)remoteJenkinsUrl);
    }

    @DataBoundSetter
    public void setAuth2(Auth2 auth) {
        this.auth2 = auth;
        this.auth = null;
    }

    @DataBoundSetter
    public void setParameters2(JobParameters parameters2) {
        this.parameters2 = parameters2;
        this.parameters = null;
        this.parameterFile = null;
    }

    @DataBoundSetter
    public void setShouldNotFailBuild(boolean shouldNotFailBuild) {
        this.shouldNotFailBuild = shouldNotFailBuild;
    }

    @DataBoundSetter
    public void setPreventRemoteBuildQueue(boolean preventRemoteBuildQueue) {
        this.preventRemoteBuildQueue = preventRemoteBuildQueue;
    }

    @DataBoundSetter
    public void setHttpGetReadTimeout(int readTimeout) {
        this.httpGetReadTimeout = readTimeout < 1000 ? 10000 : readTimeout;
    }

    @DataBoundSetter
    public void setHttpPostReadTimeout(int readTimeout) {
        this.httpPostReadTimeout = readTimeout < 1000 ? 30000 : readTimeout;
    }

    @DataBoundSetter
    public void setPollInterval(int pollInterval) {
        this.pollInterval = pollInterval <= 0 ? 10 : pollInterval;
    }

    @DataBoundSetter
    public void setBlockBuildUntilComplete(boolean blockBuildUntilComplete) {
        this.blockBuildUntilComplete = blockBuildUntilComplete;
    }

    @DataBoundSetter
    public void setJob(String job) {
        this.job = StringUtils.trimToNull((String)job);
    }

    @DataBoundSetter
    public void setToken(String token) {
        this.token = token == null ? "" : token.trim();
    }

    @DataBoundSetter
    public void setParameters(String parameters) {
        this.parameters = parameters == null ? "" : parameters;
    }

    @DataBoundSetter
    public void setEnhancedLogging(boolean enhancedLogging) {
        this.enhancedLogging = enhancedLogging;
    }

    @DataBoundSetter
    public void setDisabled(boolean disabled) {
        this.disabled = disabled;
    }

    @DataBoundSetter
    public void setUseJobInfoCache(boolean useJobInfoCache) {
        this.useJobInfoCache = useJobInfoCache;
    }

    @DataBoundSetter
    public void setUseCrumbCache(boolean useCrumbCache) {
        this.useCrumbCache = useCrumbCache;
    }

    public Map<String, String> getParameterMap(BuildContext context) throws AbortException {
        return this.getParameters2().getParametersMap(context);
    }

    @NonNull
    public RemoteJenkinsServer evaluateEffectiveRemoteHost(BasicBuildContext context) throws IOException {
        RemoteJenkinsServer globallyConfiguredServer;
        RemoteJenkinsServer server = globallyConfiguredServer = this.findRemoteHost(this.remoteJenkinsName);
        String expandedJob = this.getJobExpanded(context);
        boolean isJobEmpty = StringUtils.isEmpty((String)StringUtils.trimToNull((String)expandedJob));
        boolean isJobUrl = FormValidationUtils.isURL(expandedJob);
        boolean isRemoteUrlEmpty = StringUtils.isEmpty((String)StringUtils.trimToNull((String)this.remoteJenkinsUrl));
        boolean isRemoteUrlSet = FormValidationUtils.isURL(this.remoteJenkinsUrl);
        boolean isRemoteNameEmpty = StringUtils.isEmpty((String)StringUtils.trimToNull((String)this.remoteJenkinsName));
        if (isJobEmpty) {
            throw new AbortException("Parameter 'Remote Job Name or URL' ('job' variable in Pipeline) not specified.");
        }
        if (!isRemoteUrlEmpty && !isRemoteUrlSet) {
            throw new AbortException(String.format("The 'Override remote host URL' parameter value (remoteJenkinsUrl: '%s') is no valid URL", this.remoteJenkinsUrl));
        }
        if (isJobUrl) {
            if (server == null) {
                server = new RemoteJenkinsServer();
            }
            server.setAddress(this.getRootUrlFromJobUrl(expandedJob));
        } else if (isRemoteUrlSet) {
            if (server == null) {
                server = new RemoteJenkinsServer();
            }
            server.setAddress(this.remoteJenkinsUrl);
        }
        if (server == null) {
            if (!isJobUrl) {
                if (!isRemoteUrlSet && isRemoteNameEmpty) {
                    throw new AbortException("Configuration of the remote Jenkins host is missing.");
                }
                if (!isRemoteUrlSet && !isRemoteNameEmpty && globallyConfiguredServer == null) {
                    throw new AbortException(String.format("Could get remote host with ID '%s' configured in Jenkins global configuration. Please check your global configuration.", this.remoteJenkinsName));
                }
            }
            throw new AbortException(String.format("Could not identify remote host - neither via 'Remote Job Name or URL' (job:'%s'), globally configured remote host (remoteJenkinsName:'%s') nor 'Override remote host URL' (remoteJenkinsUrl:'%s').", expandedJob, this.remoteJenkinsName, this.remoteJenkinsUrl));
        }
        String addr = server.getAddress();
        if (addr != null) {
            URL url = new URL(addr);
            Semaphore s = this.hostLocks.get(url.getHost());
            Integer lastPermit = this.hostPermits.get(url.getHost());
            int maxConn = this.getMaxConn();
            if (s == null || lastPermit == null || maxConn != lastPermit) {
                s = new Semaphore(maxConn);
                this.hostLocks.put(url.getHost(), s);
                this.hostPermits.put(url.getHost(), maxConn);
            }
        }
        if (this.overrideTrustAllCertificates) {
            server.setTrustAllCertificates(this.trustAllCertificates);
        }
        return server;
    }

    public Semaphore getLock(String addr) {
        Semaphore s = null;
        try {
            URL url = new URL(addr);
            s = this.hostLocks.get(url.getHost());
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Failed to setup resource lock", e);
        }
        return s;
    }

    @Nullable
    @CheckForNull
    public RemoteJenkinsServer findRemoteHost(String displayName) {
        if (StringUtils.isEmpty((String)displayName)) {
            return null;
        }
        RemoteJenkinsServer server = null;
        for (RemoteJenkinsServer host : this.getDescriptor().remoteSites) {
            if (!displayName.equals(host.getDisplayName())) continue;
            try {
                server = host.clone();
                break;
            }
            catch (CloneNotSupportedException e) {
                throw new RuntimeException(e);
            }
        }
        return server;
    }

    protected static String removeTrailingSlashes(String string) {
        if (StringUtils.isEmpty((String)string)) {
            return string;
        }
        string = string.trim();
        while (string.endsWith("/")) {
            string = string.substring(0, string.length() - 1);
        }
        return string;
    }

    protected static String removeQueryParameters(String string) {
        if (StringUtils.isEmpty((String)string)) {
            return string;
        }
        int idx = (string = string.trim()).indexOf("?");
        if (idx > 0) {
            string = string.substring(0, idx);
        }
        return string;
    }

    protected static String removeHashParameters(String string) {
        if (StringUtils.isEmpty((String)string)) {
            return string;
        }
        int idx = (string = string.trim()).indexOf("#");
        if (idx > 0) {
            string = string.substring(0, idx);
        }
        return string;
    }

    private String getRootUrlFromJobUrl(String jobUrl) throws MalformedURLException {
        if (StringUtils.isEmpty((String)jobUrl)) {
            return null;
        }
        if (FormValidationUtils.isURL(jobUrl)) {
            int index = jobUrl.contains("/view/") ? Math.min(jobUrl.indexOf("/view/"), jobUrl.indexOf("/job/")) : jobUrl.indexOf("/job/");
            if (index < 0) {
                throw new MalformedURLException("Expected '/job/' element in job URL but was: " + jobUrl);
            }
            return jobUrl.substring(0, index);
        }
        return null;
    }

    protected void failBuild(Exception e, PrintStream logger) throws IOException {
        StringBuilder msg = new StringBuilder();
        if (e instanceof InterruptedException) {
            Thread current = Thread.currentThread();
            msg.append(String.format("[Thread: %s/%s]: ", current.getId(), current.getName()));
        }
        msg.append(String.format("Remote build failed with '%s' for the following reason: '%s'.%s", e.getClass().getSimpleName(), e.getMessage(), this.getShouldNotFailBuild() ? " But the build will continue." : ""));
        if (this.enhancedLogging) {
            msg.append(StringTools.NL).append(ExceptionUtils.getFullStackTrace((Throwable)e));
        }
        if (logger != null) {
            logger.println("ERROR: " + msg.toString());
        }
        if (!this.getShouldNotFailBuild()) {
            throw new AbortException(e.getClass().getSimpleName() + ": " + e.getMessage());
        }
    }

    public void abortRemoteTask(RemoteJenkinsServer remoteServer, Handle handle, BuildContext context) throws IOException, InterruptedException {
        if (this.isAbortTriggeredJob() && context != null && handle != null && !handle.isFinished()) {
            try {
                if (handle.isQueued()) {
                    RestUtils.cancelQueueItem(remoteServer.getAddress(), handle, context, this);
                } else {
                    RestUtils.stopRemoteJob(handle, context, this);
                }
            }
            catch (IOException ex) {
                context.logger.println("Fail to abort remote job: " + ex.getMessage());
                logger.log(Level.WARNING, "Fail to abort remote job", ex);
            }
        }
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException, IllegalArgumentException {
        FilePath workspace = build.getWorkspace();
        if (workspace == null) {
            throw new IllegalArgumentException("The workspace can not be null");
        }
        if (!this.isStepDisabled(listener.getLogger())) {
            this.perform((Run<?, ?>)build, workspace, launcher, (TaskListener)listener);
        }
        return true;
    }

    public boolean isStepDisabled(PrintStream printStream) {
        if (this.isDisabled()) {
            printStream.println("remote trigger step was disabled. skipping...");
            return true;
        }
        return false;
    }

    public void perform(Run<?, ?> build, FilePath workspace, Launcher launcher, TaskListener listener) throws InterruptedException, IOException {
        Handle handle = null;
        BuildContext context = null;
        RemoteJenkinsServer effectiveRemoteServer = null;
        try (AutoCloseable ignored = OtelUtils.isOpenTelemetryAvailable() ? OtelUtils.activeSpanIfAvailable(build) : OtelUtils.noop();){
            effectiveRemoteServer = this.evaluateEffectiveRemoteHost(new BasicBuildContext(build, workspace, listener));
            context = new BuildContext(build, workspace, listener, listener.getLogger(), effectiveRemoteServer);
            handle = this.performTriggerAndGetQueueId(context);
            this.performWaitForBuild(context, handle);
        }
        catch (InterruptedException e) {
            this.abortRemoteTask(effectiveRemoteServer, handle, context);
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public Handle performTriggerAndGetQueueId(@NonNull BuildContext context) throws IOException, InterruptedException {
        Map<String, String> parameters = this.getParameterMap(context);
        String jobNameOrUrl = this.getJob();
        String securityToken = this.getToken();
        try {
            parameters = TokenMacroUtils.applyTokenMacroReplacements(parameters, (BasicBuildContext)context);
            jobNameOrUrl = TokenMacroUtils.applyTokenMacroReplacements(jobNameOrUrl, (BasicBuildContext)context);
            securityToken = TokenMacroUtils.applyTokenMacroReplacements(securityToken, (BasicBuildContext)context);
        }
        catch (IOException e) {
            this.failBuild(e, context.logger);
        }
        this.logConfiguration(context, parameters);
        JSONObject remoteJobMetadata = this.getRemoteJobMetadata(jobNameOrUrl, context);
        boolean isRemoteParameterized = this.isRemoteJobParameterized(remoteJobMetadata);
        String triggerUrlString = HttpHelper.buildTriggerUrl(jobNameOrUrl, securityToken, isRemoteParameterized, context);
        String jobUrlString = RemoteBuildConfiguration.generateJobUrl(context.effectiveRemoteServer, jobNameOrUrl);
        context.logger.println(String.format("Triggering %s remote job '%s'", isRemoteParameterized ? "parameterized" : "non-parameterized", jobUrlString));
        this.logAuthInformation(context);
        RemoteBuildInfo buildInfo = new RemoteBuildInfo();
        context.logger.println("Triggering remote job now.");
        try {
            ConnectionResponse responseRemoteJob = HttpHelper.tryPost(triggerUrlString, context, parameters, this.getHttpPostReadTimeout(), this.getPollInterval(buildInfo.getStatus()), this.getConnectionRetryLimit(), this.getAuth2(), this.getLock(triggerUrlString), this.isUseCrumbCache());
            QueueItem queueItem = new QueueItem(responseRemoteJob.getHeader());
            buildInfo.setQueueId(queueItem.getId());
            buildInfo = this.updateBuildInfo(buildInfo, context);
        }
        catch (IOException | InterruptedException e) {
            this.failBuild(e, context.logger);
        }
        return new Handle(this, buildInfo, context.currentItem, context.effectiveRemoteServer, remoteJobMetadata);
    }

    public void performWaitForBuild(BuildContext context, Handle handle) throws IOException, InterruptedException {
        String jobName = handle.getJobName();
        RemoteBuildInfo buildInfo = handle.getBuildInfo();
        String queueId = buildInfo.getQueueId();
        if (queueId == null) {
            throw new AbortException(String.format("Unexpected status: %s. The queue id was not found.", buildInfo.toString()));
        }
        context.logger.println("  Remote job queue number: " + buildInfo.getQueueId());
        if (buildInfo.isQueued()) {
            context.logger.println("Waiting for remote build to be executed...");
        }
        while (buildInfo.isQueued()) {
            context.logger.println("Waiting for " + this.getPollInterval(buildInfo.getStatus()) + " seconds until next poll.");
            Thread.sleep(this.getPollInterval(buildInfo.getStatus()) * 1000);
            buildInfo = this.updateBuildInfo(buildInfo, context);
            handle.setBuildInfo(buildInfo);
        }
        URL jobURL = buildInfo.getBuildURL();
        int jobNumber = buildInfo.getBuildNumber();
        if (jobURL == null || jobNumber == 0) {
            throw new AbortException(String.format("Unexpected status: %s", buildInfo.toString()));
        }
        context.logger.println("Remote build started!");
        context.logger.println("  Remote build URL: " + jobURL);
        context.logger.println("  Remote build number: " + jobNumber);
        if (context.run != null) {
            RemoteBuildInfoExporterAction.addBuildInfoExporterAction(context.run, jobName, jobNumber, jobURL, buildInfo);
        }
        if (this.getBlockBuildUntilComplete()) {
            context.logger.println("Blocking local job until remote job completes.");
            buildInfo = this.updateBuildInfo(buildInfo, context);
            handle.setBuildInfo(buildInfo);
            if (buildInfo.isRunning()) {
                context.logger.println("Waiting for remote build to finish ...");
            }
            String consoleOffset = "0";
            if (this.getEnhancedLogging()) {
                context.logger.println("--------------------------------------------------------------------------------");
                context.logger.println();
                context.logger.println("Console output of remote job:");
                consoleOffset = this.printOffsetConsoleOutput(context, consoleOffset, buildInfo);
            }
            while (buildInfo.isRunning()) {
                if (this.getEnhancedLogging()) {
                    consoleOffset = this.printOffsetConsoleOutput(context, consoleOffset, buildInfo);
                } else {
                    context.logger.println("  Waiting for " + this.getPollInterval(buildInfo.getStatus()) + " seconds until next poll.");
                }
                Thread.sleep(this.getPollInterval(buildInfo.getStatus()) * 1000);
                buildInfo = this.updateBuildInfo(buildInfo, context);
                handle.setBuildInfo(buildInfo);
            }
            if (this.getEnhancedLogging()) {
                consoleOffset = this.printOffsetConsoleOutput(context, consoleOffset, buildInfo);
                context.logger.println("--------------------------------------------------------------------------------");
            }
            context.logger.println("Remote build finished with status " + buildInfo.getResult().toString() + ".");
            if (context.run != null) {
                RemoteBuildInfoExporterAction.addBuildInfoExporterAction(context.run, jobName, jobNumber, jobURL, buildInfo);
            }
            if (buildInfo.getResult() != Result.SUCCESS && buildInfo.getResult() != Result.UNSTABLE) {
                this.failBuild(new Exception("The remote job did not succeed."), context.logger);
            }
        } else {
            context.logger.println("Not blocking local job until remote job completes - fire and forget.");
        }
    }

    @NonNull
    private QueueItemData getQueueItemData(@NonNull String queueId, @NonNull BuildContext context) throws IOException, InterruptedException {
        if (context.effectiveRemoteServer.getAddress() == null) {
            throw new AbortException("The remote server address can not be empty, or it must be overridden on the job configuration.");
        }
        String queueQuery = String.format("%s/queue/item/%s/api/json/", context.effectiveRemoteServer.getAddress(), queueId);
        ConnectionResponse response = this.doGet(queueQuery, context, RemoteBuildStatus.QUEUED);
        JSONObject queueResponse = response.getBody();
        if (queueResponse == null || queueResponse.isNullObject()) {
            throw new AbortException(String.format("Unexpected queue item response: code %s for request %s", response.getResponseCode(), queueQuery));
        }
        QueueItemData queueItem = new QueueItemData();
        queueItem.update(context, queueResponse);
        if (queueItem.isBlocked()) {
            context.logger.println(String.format("The remote job is blocked. %s.", queueItem.getWhy()));
        }
        if (queueItem.isPending()) {
            context.logger.println(String.format("The remote job is pending. %s.", queueItem.getWhy()));
        }
        if (queueItem.isBuildable()) {
            context.logger.println(String.format("The remote job is buildable. %s.", queueItem.getWhy()));
        }
        if (queueItem.isCancelled()) {
            throw new AbortException("The remote job was canceled");
        }
        return queueItem;
    }

    @NonNull
    public RemoteBuildInfo updateBuildInfo(@NonNull RemoteBuildInfo buildInfo, @NonNull BuildContext context) throws IOException, InterruptedException {
        if (buildInfo.isNotTriggered()) {
            return buildInfo;
        }
        if (buildInfo.isQueued()) {
            String queueId = buildInfo.getQueueId();
            if (queueId == null) {
                throw new AbortException(String.format("Unexpected status: %s. The queue id was not found.", buildInfo.toString()));
            }
            QueueItemData queueItem = this.getQueueItemData(queueId, context);
            if (queueItem.isExecuted()) {
                URL remoteBuildURL = queueItem.getBuildURL();
                String effectiveRemoteServerAddress = context.effectiveRemoteServer.getAddress();
                URL effectiveRemoteBuildURL = RemoteBuildConfiguration.generateEffectiveRemoteBuildURL(remoteBuildURL, effectiveRemoteServerAddress);
                buildInfo.setBuildData(queueItem.getBuildNumber(), effectiveRemoteBuildURL);
            }
            return buildInfo;
        }
        String buildUrlString = String.format("%sapi/json/?tree=result,building&seed=%d", buildInfo.getBuildURL(), System.currentTimeMillis());
        JSONObject responseObject = this.doGet(buildUrlString, context, buildInfo.getStatus()).getBody();
        try {
            if (responseObject == null || responseObject.getString("result") == null && !responseObject.getBoolean("building")) {
                return buildInfo;
            }
            if (responseObject.getBoolean("building")) {
                buildInfo.setBuildStatus(RemoteBuildStatus.RUNNING);
            } else if (responseObject.getString("result") != null) {
                buildInfo.setBuildResult(responseObject.getString("result"));
            } else {
                context.logger.println("WARNING: Unhandled condition!");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return buildInfo;
    }

    protected static URL generateEffectiveRemoteBuildURL(URL remoteBuildURL, String effectiveRemoteServerAddress) throws AbortException {
        if (effectiveRemoteServerAddress == null || remoteBuildURL == null) {
            return remoteBuildURL;
        }
        try {
            URI effectiveUri = new URI(effectiveRemoteServerAddress);
            return new URL(effectiveUri.getScheme(), effectiveUri.getHost(), effectiveUri.getPort(), remoteBuildURL.getPath());
        }
        catch (MalformedURLException | URISyntaxException ex) {
            throw new AbortException(String.format("Unexpected syntax error: %s.", ex.toString()));
        }
    }

    private String printOffsetConsoleOutput(BuildContext context, String offset, RemoteBuildInfo buildInfo) throws IOException, InterruptedException {
        Map<String, List<String>> header;
        if (offset == null || offset.equals("-1")) {
            return "-1";
        }
        String buildUrlString = String.format("%slogText/progressiveText?start=%s", buildInfo.getBuildURL(), offset);
        ConnectionResponse response = this.doGet(buildUrlString, context, buildInfo.getStatus());
        String rawBody = response.getRawBody();
        if (rawBody != null && !rawBody.equals("")) {
            context.logger.println(rawBody);
        }
        if ((header = response.getHeader()).containsKey("X-More-Data") && header.containsKey("X-Text-Size")) {
            return header.get("X-Text-Size").get(0);
        }
        return "-1";
    }

    public ConnectionResponse doGet(String urlString, BuildContext context, RemoteBuildStatus remoteBuildStatus) throws IOException, InterruptedException {
        return HttpHelper.tryGet(urlString, context, this.getHttpGetReadTimeout(), this.getPollInterval(remoteBuildStatus), this.getConnectionRetryLimit(), this.getAuth2(), this.getLock(urlString));
    }

    private void logAuthInformation(@NonNull BuildContext context) {
        Auth2 serverAuth = context.effectiveRemoteServer.getAuth2();
        Auth2 localAuth = this.getAuth2();
        if (localAuth != null && !(localAuth instanceof NullAuth)) {
            String authString = context.run == null ? localAuth.getDescriptor().getDisplayName() : localAuth.toString((Item)context.run.getParent());
            context.logger.printf("  Using job-level defined " + authString + "%n", new Object[0]);
        } else if (serverAuth != null && !(serverAuth instanceof NullAuth)) {
            String authString = context.run == null ? serverAuth.getDescriptor().getDisplayName() : serverAuth.toString((Item)context.run.getParent());
            context.logger.printf("  Using globally defined " + authString + "%n", new Object[0]);
        } else {
            context.logger.println("  No credentials configured");
        }
    }

    private void logConfiguration(@NonNull BuildContext context, Map<String, String> effectiveParams) throws IOException {
        String _jobExpanded;
        String _job = this.getJob();
        Object _jobExpandedLogEntry = _job.equals(_jobExpanded = this.getJobExpanded(context)) ? "" : "(" + _jobExpanded + ")";
        String _remoteJenkinsName = this.getRemoteJenkinsName();
        String _remoteJenkinsUrl = this.getRemoteJenkinsUrl();
        boolean _trustAllCertificates = context.effectiveRemoteServer.getTrustAllCertificates();
        Auth2 _auth = this.getAuth2();
        int _connectionRetryLimit = this.getConnectionRetryLimit();
        boolean _blockBuildUntilComplete = this.getBlockBuildUntilComplete();
        context.logger.println("################################################################################################################");
        context.logger.println("  Parameterized Remote Trigger Configuration:");
        context.logger.printf("    - job:                     %s %s%n", _job, _jobExpandedLogEntry);
        if (!StringUtils.isEmpty((String)_remoteJenkinsName)) {
            context.logger.printf("    - remoteJenkinsName:       %s%n", _remoteJenkinsName);
        }
        if (!StringUtils.isEmpty((String)_remoteJenkinsUrl)) {
            context.logger.printf("    - remoteJenkinsUrl:        %s%n", _remoteJenkinsUrl);
        }
        if (_auth != null && !(_auth instanceof NullAuth)) {
            String authString = context.run == null ? _auth.getDescriptor().getDisplayName() : _auth.toString((Item)context.run.getParent());
            context.logger.printf("    - auth:                    %s%n", authString);
        }
        context.logger.printf("    - parameters:              %s%n", effectiveParams);
        context.logger.printf("    - blockBuildUntilComplete: %s%n", _blockBuildUntilComplete);
        context.logger.printf("    - connectionRetryLimit:    %s%n", _connectionRetryLimit);
        context.logger.printf("    - trustAllCertificates:    %s%n", _trustAllCertificates);
        context.logger.println("################################################################################################################");
    }

    public boolean isAbortTriggeredJob() {
        return this.abortTriggeredJob;
    }

    public int getMaxConn() {
        return this.maxConn;
    }

    public String getRemoteJenkinsName() {
        return this.remoteJenkinsName;
    }

    public String getRemoteJenkinsUrl() {
        return StringUtils.trimToNull((String)this.remoteJenkinsUrl);
    }

    public int getHttpGetReadTimeout() {
        return this.httpGetReadTimeout;
    }

    public int getHttpPostReadTimeout() {
        return this.httpPostReadTimeout;
    }

    public boolean getOverrideAuth() {
        if (this.auth2 == null) {
            return false;
        }
        return !(this.auth2 instanceof NullAuth);
    }

    public Auth2 getAuth2() {
        return this.auth2 != null ? this.auth2 : DEFAULT_AUTH;
    }

    public boolean getShouldNotFailBuild() {
        return this.shouldNotFailBuild;
    }

    public boolean getPreventRemoteBuildQueue() {
        return this.preventRemoteBuildQueue;
    }

    public int getPollInterval(RemoteBuildStatus remoteBuildStatus) {
        switch (remoteBuildStatus) {
            case NOT_TRIGGERED: 
            case QUEUED: {
                return 30;
            }
        }
        return this.pollInterval;
    }

    public boolean getBlockBuildUntilComplete() {
        return this.blockBuildUntilComplete;
    }

    public String getJob() {
        return StringUtils.trimToEmpty((String)this.job);
    }

    private String getJobExpanded(BasicBuildContext context) throws IOException {
        return TokenMacroUtils.applyTokenMacroReplacements(this.getJob(), context);
    }

    public String getToken() {
        return StringUtils.trimToEmpty((String)this.token);
    }

    public boolean getEnhancedLogging() {
        return this.enhancedLogging;
    }

    public JobParameters getParameters2() {
        return this.parameters2 != null ? this.parameters2 : DEFAULT_PARAMETERS;
    }

    public int getConnectionRetryLimit() {
        return 5;
    }

    public boolean isDisabled() {
        return this.disabled;
    }

    @NonNull
    private JSONObject getRemoteJobMetadata(String jobNameOrUrl, @NonNull BuildContext context) throws IOException, InterruptedException {
        Object remoteJobUrl = RemoteBuildConfiguration.generateJobUrl(context.effectiveRemoteServer, jobNameOrUrl);
        Map<String, String> parameters = Collections.singletonMap("tree", "actions[parameterDefinitions],property[parameterDefinitions],name,fullName,displayName,fullDisplayName,url");
        JSONObject jsonObject = DropCachePeriodicWork.safeGetJobInfo((String)(remoteJobUrl = (String)remoteJobUrl + "/api/json?" + HttpHelper.buildUrlQueryString(parameters)), this.isUseJobInfoCache());
        if (jsonObject != null) {
            return jsonObject;
        }
        ConnectionResponse response = this.doGet((String)remoteJobUrl, context, RemoteBuildStatus.FINISHED);
        if (response.getResponseCode() < 400 && response.getBody() != null) {
            return DropCachePeriodicWork.safePutJobInfo((String)remoteJobUrl, response.getBody(), this.isUseJobInfoCache());
        }
        if (response.getResponseCode() == 401 || response.getResponseCode() == 403) {
            throw new AbortException("Unauthorized to trigger " + (String)remoteJobUrl + " - status code " + response.getResponseCode());
        }
        if (response.getResponseCode() == 404) {
            throw new AbortException("Remote job does not exist " + (String)remoteJobUrl + " - status code " + response.getResponseCode());
        }
        throw new AbortException("Unexpected response from " + (String)remoteJobUrl + " - status code " + response.getResponseCode());
    }

    private boolean isRemoteJobParameterized(JSONObject remoteJobMetadata) throws IOException {
        boolean isParameterized = false;
        if (remoteJobMetadata != null) {
            if (remoteJobMetadata.getJSONArray("actions").size() >= 1) {
                for (Object obj : remoteJobMetadata.getJSONArray("actions")) {
                    if (!(obj instanceof JSONObject) || ((JSONObject)obj).get("parameterDefinitions") == null) continue;
                    isParameterized = true;
                }
            }
            if (!isParameterized && remoteJobMetadata.getJSONArray("property").size() >= 1) {
                for (Object obj : remoteJobMetadata.getJSONArray("property")) {
                    if (!(obj instanceof JSONObject) || ((JSONObject)obj).get("parameterDefinitions") == null) continue;
                    isParameterized = true;
                }
            }
        } else {
            throw new AbortException("Could not identify if job is parameterized. Job metadata not accessible or with unexpected content.");
        }
        return isParameterized;
    }

    protected static String generateJobUrl(RemoteJenkinsServer remoteServer, String jobNameOrUrl) throws AbortException {
        String remoteJobUrl;
        if (StringUtils.isEmpty((String)jobNameOrUrl)) {
            throw new IllegalArgumentException("Invalid job name/url: " + jobNameOrUrl);
        }
        String _jobNameOrUrl = jobNameOrUrl.trim();
        if (FormValidationUtils.isURL(_jobNameOrUrl)) {
            remoteJobUrl = _jobNameOrUrl;
        } else {
            String[] split;
            remoteJobUrl = remoteServer.getAddress();
            if (remoteJobUrl == null) {
                throw new AbortException("The remote server address can not be empty, or it must be overridden on the job configuration.");
            }
            while (remoteJobUrl.endsWith("/")) {
                remoteJobUrl = remoteJobUrl.substring(0, remoteJobUrl.length() - 1);
            }
            for (String segment : split = _jobNameOrUrl.trim().split("/")) {
                remoteJobUrl = String.format("%s/job/%s", remoteJobUrl, HttpHelper.encodeValue(segment));
            }
        }
        return remoteJobUrl;
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    public boolean isUseCrumbCache() {
        return this.useCrumbCache;
    }

    public boolean isUseJobInfoCache() {
        return this.useJobInfoCache;
    }

    public boolean getTrustAllCertificates() {
        return this.trustAllCertificates;
    }

    public boolean getOverrideTrustAllCertificates() {
        return this.overrideTrustAllCertificates;
    }

    @Extension
    public static final class DescriptorImpl
    extends BuildStepDescriptor<Builder> {
        private CopyOnWriteList<RemoteJenkinsServer> remoteSites = new CopyOnWriteList();

        public DescriptorImpl() {
            this(true);
        }

        private DescriptorImpl(boolean load) {
            if (load) {
                this.load();
            }
        }

        public static DescriptorImpl newInstanceForTests() {
            return new DescriptorImpl(false);
        }

        public boolean isApplicable(Class<? extends AbstractProject> aClass) {
            return true;
        }

        @NonNull
        public String getDisplayName() {
            return "Trigger a remote parameterized job";
        }

        public boolean configure(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            this.remoteSites.replaceBy((Collection)req.bindJSONToList(RemoteJenkinsServer.class, formData.get("remoteSites")));
            this.save();
            return super.configure(req, formData);
        }

        @Restricted(value={NoExternalUse.class})
        public FormValidation doCheckTrustAllCertificates(@QueryParameter(value="trustAllCertificates") boolean value) {
            if (value) {
                return FormValidation.warning((String)"Accepting all certificates is potentially unsafe.");
            }
            return FormValidation.ok();
        }

        @Restricted(value={NoExternalUse.class})
        public FormValidation doCheckJob(@QueryParameter(value="job") String value, @QueryParameter(value="remoteJenkinsUrl") String remoteJenkinsUrl, @QueryParameter(value="remoteJenkinsName") String remoteJenkinsName) {
            FormValidationUtils.RemoteURLCombinationsResult result = FormValidationUtils.checkRemoteURLCombinations(remoteJenkinsUrl, remoteJenkinsName, value);
            if (result.isAffected(FormValidationUtils.AffectedField.JOB_NAME_OR_URL)) {
                return result.formValidation;
            }
            return FormValidation.ok();
        }

        @Restricted(value={NoExternalUse.class})
        public FormValidation doCheckRemoteJenkinsUrl(@QueryParameter(value="remoteJenkinsUrl") String value, @QueryParameter(value="remoteJenkinsName") String remoteJenkinsName, @QueryParameter(value="job") String job) {
            FormValidationUtils.RemoteURLCombinationsResult result = FormValidationUtils.checkRemoteURLCombinations(value, remoteJenkinsName, job);
            if (result.isAffected(FormValidationUtils.AffectedField.REMOTE_JENKINS_URL)) {
                return result.formValidation;
            }
            return FormValidation.ok();
        }

        @Restricted(value={NoExternalUse.class})
        public FormValidation doCheckRemoteJenkinsName(@QueryParameter(value="remoteJenkinsName") String value, @QueryParameter(value="remoteJenkinsUrl") String remoteJenkinsUrl, @QueryParameter(value="job") String job) {
            FormValidationUtils.RemoteURLCombinationsResult result = FormValidationUtils.checkRemoteURLCombinations(remoteJenkinsUrl, value, job);
            if (result.isAffected(FormValidationUtils.AffectedField.REMOTE_JENKINS_NAME)) {
                return result.formValidation;
            }
            return FormValidation.ok();
        }

        @Restricted(value={NoExternalUse.class})
        @NonNull
        public ListBoxModel doFillRemoteJenkinsNameItems() {
            ListBoxModel model = new ListBoxModel();
            model.add("");
            Arrays.stream(this.getRemoteSites()).filter(Objects::nonNull).map(RemoteJenkinsServer::getDisplayName).forEach(arg_0 -> ((ListBoxModel)model).add(arg_0));
            return model;
        }

        public RemoteJenkinsServer[] getRemoteSites() {
            return (RemoteJenkinsServer[])this.remoteSites.toArray((Object[])new RemoteJenkinsServer[this.remoteSites.size()]);
        }

        public void setRemoteSites(RemoteJenkinsServer ... remoteSites) {
            this.remoteSites.replaceBy((Object[])remoteSites);
        }

        public static List<Auth2.Auth2Descriptor> getAuth2Descriptors() {
            return Auth2.all();
        }

        public static List<JobParameters.ParametersDescriptor> getParametersDescriptors() {
            return JobParameters.all();
        }

        public static Auth2.Auth2Descriptor getDefaultAuth2Descriptor() {
            return NullAuth.DESCRIPTOR;
        }

        public static JobParameters.ParametersDescriptor getDefaultParametersDescriptor() {
            return MapParameters.DESCRIPTOR;
        }
    }
}

