/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.ParameterizedRemoteTrigger;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.Collectors;
import net.sf.json.JSONObject;

public class ConnectionResponse {
    @NonNull
    private final Map<String, List<String>> header = new TreeMap<String, List<String>>(String.CASE_INSENSITIVE_ORDER);
    @Nullable
    @CheckForNull
    private final JSONObject body;
    @Nullable
    @CheckForNull
    private final String rawBody;
    @NonNull
    private final int responseCode;

    public ConnectionResponse(@NonNull Map<String, List<String>> header, @Nullable JSONObject body, @NonNull int responseCode) {
        this.loadHeader(header);
        this.body = body;
        this.rawBody = null;
        this.responseCode = responseCode;
    }

    public ConnectionResponse(@NonNull Map<String, List<String>> header, @Nullable String rawBody, @NonNull int responseCode) {
        this.loadHeader(header);
        this.body = null;
        this.rawBody = rawBody;
        this.responseCode = responseCode;
    }

    public ConnectionResponse(@NonNull Map<String, List<String>> header, @NonNull int responseCode) {
        this.loadHeader(header);
        this.body = null;
        this.rawBody = null;
        this.responseCode = responseCode;
    }

    private void loadHeader(Map<String, List<String>> header) {
        Map<String, List> filtered = header.entrySet().stream().filter(entry -> entry.getKey() != null).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        this.header.putAll(filtered);
    }

    public Map<String, List<String>> getHeader() {
        return this.header;
    }

    public JSONObject getBody() {
        return this.body;
    }

    public String getRawBody() {
        return this.rawBody;
    }

    public int getResponseCode() {
        return this.responseCode;
    }
}

