/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.ParameterizedRemoteTrigger;

import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import hudson.FilePath;
import hudson.model.Run;
import hudson.model.TaskListener;
import java.io.PrintStream;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.plugins.ParameterizedRemoteTrigger.BasicBuildContext;
import org.jenkinsci.plugins.ParameterizedRemoteTrigger.RemoteJenkinsServer;

public class BuildContext
extends BasicBuildContext {
    @NonNull
    public final PrintStream logger;
    @NonNull
    public RemoteJenkinsServer effectiveRemoteServer;
    @NonNull
    public final String currentItem;

    public BuildContext(@Nullable Run<?, ?> run, @Nullable FilePath workspace, @Nullable TaskListener listener, @NonNull PrintStream logger, @NonNull RemoteJenkinsServer effectiveRemoteServer, @Nullable String currentItem) {
        super(run, workspace, listener);
        this.logger = logger;
        this.effectiveRemoteServer = effectiveRemoteServer;
        this.currentItem = this.getCurrentItem(run, currentItem);
    }

    public BuildContext(@Nullable Run<?, ?> run, @Nullable FilePath workspace, @Nullable TaskListener listener, @NonNull PrintStream logger, @NonNull RemoteJenkinsServer effectiveRemoteServer) {
        this(run, workspace, listener, logger, effectiveRemoteServer, null);
    }

    public BuildContext(@NonNull PrintStream logger, @NonNull RemoteJenkinsServer effectiveRemoteServer, @Nullable String currentItem) {
        this(null, null, null, logger, effectiveRemoteServer, currentItem);
    }

    @NonNull
    private String getCurrentItem(Run<?, ?> run, String currentItem) {
        String runItem = null;
        String curItem = StringUtils.trimToNull((String)currentItem);
        if (run != null && run.getParent() != null) {
            runItem = StringUtils.trimToNull((String)run.getParent().getFullName());
        }
        if (runItem != null && curItem != null) {
            if (runItem.equals(curItem)) {
                return runItem;
            }
            throw new IllegalArgumentException(String.format("Current Item ('%s') and Parent Item from Run ('%s') differ!", curItem, runItem));
        }
        if (runItem != null) {
            return runItem;
        }
        if (curItem != null) {
            return curItem;
        }
        throw new IllegalArgumentException("Both null, Run and Current Item!");
    }
}

